/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.test;

import gama.core.common.interfaces.IColored;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.dev.COUNTER;
import gama.gaml.interfaces.INamed;
import gama.gaml.statements.test.TestState;
import gama.gaml.statements.test.WithTestSummary;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.eclipse.emf.common.util.URI;

public abstract class AbstractSummary<S extends WithTestSummary<?>>
implements INamed,
IColored {
    private final URI uri;
    private final String title;
    public final int index = COUNTER.GET_UNIQUE();
    public String error;

    public AbstractSummary(S s) {
        if (s != null) {
            this.title = s.getTitleForSummary();
            this.uri = s.getURI();
        } else {
            this.title = null;
            this.uri = null;
        }
    }

    public void setError(String string) {
        this.error = string;
    }

    public String getError() {
        return this.error;
    }

    public int getIndex() {
        return this.index;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public abstract long getTimeStamp();

    @Override
    public GamaColor getColor(IScope iScope) {
        return this.getState().getColor(iScope);
    }

    public abstract TestState getState();

    public abstract void setState(TestState var1);

    public void reset() {
        this.error = null;
    }

    public abstract Map<String, ? extends AbstractSummary<?>> getSummaries();

    public abstract int countTestsWith(TestState var1);

    public abstract int size();

    public final String toString() {
        TestState testState = this.getState();
        if (GamaPreferences.Runtime.FAILED_TESTS.getValue().booleanValue() && testState != TestState.FAILED && testState != TestState.ABORTED) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.printHeader(stringBuilder);
        stringBuilder.append(testState).append(": ").append(this.getTitle()).append(" ");
        if (this.error != null) {
            stringBuilder.append('[').append(this.error).append(']');
        }
        this.printFooter(stringBuilder);
        for (AbstractSummary<?> abstractSummary : this.getSummaries().values()) {
            String string = abstractSummary.toString();
            if (string.isEmpty()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected void printFooter(StringBuilder stringBuilder) {
    }

    protected void printHeader(StringBuilder stringBuilder) {
    }

    public AbstractSummary<?> getSummaryOf(URI uRI) {
        if (uRI.equals(this.uri)) {
            return this;
        }
        return StreamEx.ofValues(this.getSummaries()).findFirst(abstractSummary -> abstractSummary.getSummaryOf(uRI) != null).orElse(null);
    }
}

