/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.variables;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaDateType;
import gama.gaml.variables.Variable;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-203}, optional=false, doc={@GamlAnnotations.doc(value="The name of the attribute")}), @GamlAnnotations.facet(name="type", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="The type of the attribute, either 'int', 'float', 'point' or 'date'")}), @GamlAnnotations.facet(name="init", type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="The initial value of the attribute. Same as '<-'")}), @GamlAnnotations.facet(name="<-", internal=true, type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="The initial value of the attribute. Same as 'init:'")}), @GamlAnnotations.facet(name="update", type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="An expression that will be evaluated each cycle to compute a new value for the attribute")}), @GamlAnnotations.facet(name="function", type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="Used to specify an expression that will be evaluated each time the attribute is accessed. Equivalent to '->'. This facet is incompatible with both 'init:' and 'update:'")}), @GamlAnnotations.facet(name="->", internal=true, type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="Used to specify an expression that will be evaluated each time the attribute is accessed. Equivalent to 'function:'. This facet is incompatible with both 'init:' and 'update:' and 'on_change:' (or the equivalent final block)")}), @GamlAnnotations.facet(name="const", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates whether this attribute can be subsequently modified or not")}), @GamlAnnotations.facet(name="on_change", type={0}, optional=true, doc={@GamlAnnotations.doc(value="Provides a block of statements that will be executed whenever the value of the attribute changes")}), @GamlAnnotations.facet(name="min", type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="The minimum value this attribute can take. The value will be automatically clamped if it is lower.")}), @GamlAnnotations.facet(name="max", type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="The maximum value this attribute can take. The value will be automatically clampled if it is higher.")}), @GamlAnnotations.facet(name="step", type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="A discrete step (used in conjunction with min and max) that constrains the values this variable can take")}), @GamlAnnotations.facet(name="among", type={5}, optional=true, doc={@GamlAnnotations.doc(value="A list of constant values among which the attribute can take its value")})}, omissible="name")
@GamlAnnotations.inside(kinds={0, 13, 1})
@GamlAnnotations.doc(value="Declaration of an attribute of a species or an experiment; this type of attributes accepts min:, max: and step: facets, automatically clamping the value if it is lower than min or higher than max.")
public class NumberVariable<T extends Comparable, Step extends Comparable>
extends Variable {
    private final IExpression min = this.getFacet("min");
    private final IExpression max = this.getFacet("max");
    private final IExpression step = this.getFacet("step");
    private GAMA.InScope<T> minVal;
    private GAMA.InScope<T> maxVal;
    private GAMA.InScope<Step> stepVal;

    public NumberVariable(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        if (this.min != null && this.min.isConst()) {
            switch (this.type.id()) {
                case 1: {
                    this.minVal = iScope -> Cast.asInt(iScope, this.min.value(iScope));
                    break;
                }
                case 2: {
                    this.minVal = iScope -> Cast.asFloat(iScope, this.min.value(iScope));
                    break;
                }
                case 7: {
                    this.minVal = iScope -> Cast.asPoint(iScope, this.min.value(iScope));
                    break;
                }
                case 23: {
                    this.minVal = iScope -> GamaDateType.staticCast(iScope, this.min.value(iScope), null, false);
                }
            }
        } else {
            this.minVal = null;
        }
        if (this.max != null && this.max.isConst()) {
            switch (this.type.id()) {
                case 1: {
                    this.maxVal = iScope -> Cast.asInt(iScope, this.max.value(iScope));
                    break;
                }
                case 2: {
                    this.maxVal = iScope -> Cast.asFloat(iScope, this.max.value(iScope));
                    break;
                }
                case 7: {
                    this.maxVal = iScope -> Cast.asPoint(iScope, this.max.value(iScope));
                    break;
                }
                case 23: {
                    this.maxVal = iScope -> GamaDateType.staticCast(iScope, this.max.value(iScope), null, false);
                }
            }
        } else {
            this.maxVal = null;
        }
        if (this.step != null && this.step.isConst()) {
            switch (this.type.id()) {
                case 1: {
                    this.stepVal = iScope -> Cast.asInt(iScope, this.step.value(iScope));
                    break;
                }
                case 2: {
                    this.stepVal = iScope -> Cast.asFloat(iScope, this.step.value(iScope));
                    break;
                }
                case 7: {
                    this.stepVal = iScope -> Cast.asPoint(iScope, this.step.value(iScope));
                    break;
                }
                case 23: {
                    this.stepVal = iScope -> Cast.asFloat(iScope, this.step.value(iScope));
                }
            }
        } else {
            this.stepVal = null;
        }
    }

    @Override
    public Object coerce(IAgent iAgent, IScope iScope, Object object) throws GamaRuntimeException {
        Object object2 = super.coerce(iAgent, iScope, object);
        return switch (this.type.id()) {
            case 1 -> this.checkMinMax(iAgent, iScope, (Integer)object2);
            case 2 -> this.checkMinMax(iAgent, iScope, (Double)object2);
            case 23 -> this.checkMinMax(iAgent, iScope, (GamaDate)object2);
            case 7 -> this.checkMinMax(iAgent, iScope, (GamaPoint)object2);
            default -> throw GamaRuntimeException.error("Impossible to create " + this.getName(), iScope);
        };
    }

    protected Integer checkMinMax(IAgent iAgent, IScope iScope, Integer n) throws GamaRuntimeException {
        Integer n2;
        if (this.min != null) {
            Integer n3 = n2 = this.minVal == null ? Cast.asInt(iScope, iScope.evaluate(this.min, iAgent).getValue()) : (Integer)this.minVal.run(iScope);
            if (n < n2) {
                return n2;
            }
        }
        if (this.max != null) {
            Integer n4 = n2 = this.maxVal == null ? Cast.asInt(iScope, iScope.evaluate(this.max, iAgent).getValue()) : (Integer)this.maxVal.run(iScope);
            if (n > n2) {
                return n2;
            }
        }
        return n;
    }

    protected Double checkMinMax(IAgent iAgent, IScope iScope, Double d) throws GamaRuntimeException {
        Double d2;
        if (this.min != null) {
            Double d3 = d2 = this.minVal == null ? Cast.asFloat(iScope, iScope.evaluate(this.min, iAgent).getValue()) : (Double)this.minVal.run(iScope);
            if (d < d2) {
                return d2;
            }
        }
        if (this.max != null) {
            Double d4 = d2 = this.maxVal == null ? Cast.asFloat(iScope, iScope.evaluate(this.max, iAgent).getValue()) : (Double)this.maxVal.run(iScope);
            if (d > d2) {
                return d2;
            }
        }
        return d;
    }

    protected GamaPoint checkMinMax(IAgent iAgent, IScope iScope, GamaPoint gamaPoint) throws GamaRuntimeException {
        GamaPoint gamaPoint2;
        if (gamaPoint == null) {
            return null;
        }
        if (this.min != null && gamaPoint.smallerThan(gamaPoint2 = (GamaPoint)(this.minVal == null ? Cast.asPoint(iScope, iScope.evaluate(this.min, iAgent).getValue()) : (Comparable)this.minVal.run(iScope)))) {
            return gamaPoint2;
        }
        if (this.max != null && gamaPoint.biggerThan(gamaPoint2 = (GamaPoint)(this.maxVal == null ? Cast.asPoint(iScope, iScope.evaluate(this.max, iAgent).getValue()) : (Comparable)this.maxVal.run(iScope)))) {
            return gamaPoint2;
        }
        return gamaPoint;
    }

    protected GamaDate checkMinMax(IAgent iAgent, IScope iScope, GamaDate gamaDate) throws GamaRuntimeException {
        GamaDate gamaDate2;
        if (gamaDate == null) {
            return null;
        }
        if (this.min != null && gamaDate.compareTo(gamaDate2 = (GamaDate)(this.minVal == null ? GamaDateType.staticCast(iScope, iScope.evaluate(this.min, iAgent).getValue(), null, false) : (Comparable<GamaDate>)this.minVal.run(iScope))) < 0) {
            return gamaDate2;
        }
        if (this.max != null && gamaDate.compareTo(gamaDate2 = (GamaDate)(this.maxVal == null ? GamaDateType.staticCast(iScope, iScope.evaluate(this.max, iAgent).getValue(), null, false) : (Comparable<GamaDate>)this.maxVal.run(iScope))) > 0) {
            return gamaDate2;
        }
        return gamaDate;
    }

    public T getMinValue(IScope iScope) {
        return (T)(this.minVal == null ? null : (Comparable)this.minVal.run(iScope));
    }

    public T getMaxValue(IScope iScope) {
        return (T)(this.maxVal == null ? null : (Comparable)this.maxVal.run(iScope));
    }

    public Step getStepValue(IScope iScope) {
        return (Step)(this.stepVal == null ? null : (Comparable)this.stepVal.run(iScope));
    }

    @Override
    public boolean acceptsSlider(IScope iScope) {
        return this.min != null && this.max != null && this.step != null;
    }
}

