/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.outputs.AbstractOutput;
import gama.core.outputs.AbstractOutputManager;
import gama.core.outputs.IOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.dev.DEBUG;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.factories.DescriptionFactory;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.doc(value="Represents the outputs of the experiment itself. In a batch experiment, the permanent section allows to define an output block that will NOT be re-initialized at the beginning of each simulation but will be filled at the end of each simulation.", usages={@GamlAnnotations.usage(value="For instance, this permanent section will allow to display for each simulation the end value of the food_gathered variable:", examples={@GamlAnnotations.example(value="permanent {", isExecutable=false), @GamlAnnotations.example(value="\tdisplay Ants background: rgb('white') refresh_every: 1 {", isExecutable=false), @GamlAnnotations.example(value="\t\tchart \"Food Gathered\" type: series {", isExecutable=false), @GamlAnnotations.example(value="\t\t\tdata \"Food\" value: food_gathered;", isExecutable=false), @GamlAnnotations.example(value="\t\t}", isExecutable=false), @GamlAnnotations.example(value="\t}", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
public class ExperimentOutputManager
extends AbstractOutputManager {
    static {
        DEBUG.ON();
    }

    public static ExperimentOutputManager createEmpty() {
        return new ExperimentOutputManager(DescriptionFactory.create("permanent", null));
    }

    public ExperimentOutputManager(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public boolean init(IScope iScope) {
        Symbol symbol = this.layout == null ? this : this.layout;
        String string = this.layout == null ? "layout" : "value";
        Integer n = symbol.getFacetValue(iScope, string, GamaPreferences.Displays.LAYOUTS.indexOf(GamaPreferences.Displays.CORE_DISPLAY_LAYOUT.getValue()));
        super.init(iScope);
        iScope.getGui().applyLayout(iScope, n);
        if (GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue().booleanValue()) {
            GAMA.getGui().updateParameterView(iScope);
        }
        return true;
    }

    @Override
    public boolean step(IScope iScope) {
        super.step(iScope);
        if (GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue().booleanValue()) {
            GAMA.getGui().updateParameterView(iScope);
        }
        return true;
    }

    @Override
    protected boolean initialStep(IScope iScope, IOutput iOutput) {
        if (iScope.getExperiment().getSpecies().isBatch()) {
            return true;
        }
        return super.initialStep(iScope, iOutput);
    }

    @Override
    public void add(IOutput iOutput) {
        ((AbstractOutput)iOutput).setPermanent();
        super.add(iOutput);
    }

    @Override
    public synchronized void dispose() {
        GAMA.getGui().cleanAfterExperiment();
        super.dispose();
    }
}

