/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.layers.charts.ChartDataSet;
import gama.core.outputs.layers.charts.ChartDataSourceUnique;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.doc(value="This statement allows to describe the values that will be displayed on the chart.")
@GamlAnnotations.inside(symbols={"chart"}, kinds={11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="value", type={2, 7, 5}, optional=false, doc={@GamlAnnotations.doc(value="The value to output on the chart")}), @GamlAnnotations.facet(name="legend", type={4}, optional=false, doc={@GamlAnnotations.doc(value="The legend of the chart")}), @GamlAnnotations.facet(name="use_second_y_axis", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Use second y axis for this serie")}), @GamlAnnotations.facet(name="y_err_values", type={2, 5}, optional=true, doc={@GamlAnnotations.doc(value="the Y Error bar values to display. Has to be a List. Each element can be a number or a list with two values (low and high value)")}), @GamlAnnotations.facet(name="x_err_values", type={2, 5}, optional=true, doc={@GamlAnnotations.doc(value="the X Error bar values to display. Has to be a List. Each element can be a number or a list with two values (low and high value)")}), @GamlAnnotations.facet(name="y_minmax_values", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the Y MinMax bar values to display (BW charts). Has to be a List. Each element can be a number or a list with two values (low and high value)")}), @GamlAnnotations.facet(name="marker_size", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Size in pixels of the marker")}), @GamlAnnotations.facet(name="color", type={6, 5}, optional=true, doc={@GamlAnnotations.doc(value="color of the serie, for heatmap can be a list to specify [minColor,maxColor] or [minColor,medColor,maxColor]")}), @GamlAnnotations.facet(name="accumulate_values", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Force to replace values at each step (false) or accumulate with previous steps (true)")}), @GamlAnnotations.facet(name="line_visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether lines are visible or not")}), @GamlAnnotations.facet(name="marker", type={3}, optional=true, doc={@GamlAnnotations.doc(value="marker visible or not")}), @GamlAnnotations.facet(name="marker_shape", type={-201}, values={"marker_empty", "marker_square", "marker_circle", "marker_up_triangle", "marker_diamond", "marker_hor_rectangle", "marker_down_triangle", "marker_hor_ellipse", "marker_right_triangle", "marker_vert_rectangle", "marker_left_triangle"}, optional=true, doc={@GamlAnnotations.doc(value="Shape of the marker")}), @GamlAnnotations.facet(name="fill", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Marker filled (true) or not (false)")}), @GamlAnnotations.facet(name="thickness", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The thickness of the lines to draw")}), @GamlAnnotations.facet(name="style", type={-201}, values={"line", "area", "bar", "dot", "step", "spline", "stack", "3d", "ring", "exploded"}, optional=true, doc={@GamlAnnotations.doc(value="Style for the serie (if not the default one sepecified on chart statement)")})}, omissible="legend")
public class ChartDataStatement
extends AbstractStatement {
    public static final String MARKER = "marker";
    public static final String USE_SECOND_Y_AXIS = "use_second_y_axis";
    public static final String MARKERSHAPE = "marker_shape";
    public static final String MARKERSIZE = "marker_size";
    public static final String FILL = "fill";
    public static final String LINE_VISIBLE = "line_visible";
    public static final String CUMUL_VALUES = "accumulate_values";
    public static final String XERR_VALUES = "x_err_values";
    public static final String YERR_VALUES = "y_err_values";
    public static final String YMINMAX_VALUES = "y_minmax_values";
    public static final String MARKER_EMPTY = "marker_empty";
    public static final String MARKER_SQUARE = "marker_square";
    public static final String MARKER_CIRCLE = "marker_circle";
    public static final String MARKER_UP_TRIANGLE = "marker_up_triangle";
    public static final String MARKER_DIAMOND = "marker_diamond";
    public static final String MARKER_HOR_RECTANGLE = "marker_hor_rectangle";
    public static final String MARKER_DOWN_TRIANGLE = "marker_down_triangle";
    public static final String MARKER_HOR_ELLIPSE = "marker_hor_ellipse";
    public static final String MARKER_RIGHT_TRIANGLE = "marker_right_triangle";
    public static final String MARKER_VERT_RECTANGLE = "marker_vert_rectangle";
    public static final String MARKER_LEFT_TRIANGLE = "marker_left_triangle";
    public static final String THICKNESS = "thickness";

    public ChartDataStatement(IDescription iDescription) {
        super(iDescription);
    }

    public ChartDataSourceUnique createDataSource(IScope iScope, ChartDataSet chartDataSet) throws GamaRuntimeException {
        Object var7_7;
        ChartDataSourceUnique chartDataSourceUnique = new ChartDataSourceUnique();
        chartDataSourceUnique.setDataset(iScope, chartDataSet);
        String string = this.getLiteral("style");
        if (string != null) {
            chartDataSourceUnique.setStyle(iScope, string);
        }
        boolean bl = this.getFacetValue(iScope, MARKER, true);
        chartDataSourceUnique.setMarkerBool(iScope, bl);
        bl = this.getFacetValue(iScope, LINE_VISIBLE, true);
        chartDataSourceUnique.setShowLine(iScope, bl);
        bl = this.getFacetValue(iScope, FILL, true);
        chartDataSourceUnique.setFillMarker(iScope, bl);
        bl = this.getFacetValue(iScope, USE_SECOND_Y_AXIS, false);
        chartDataSourceUnique.setUseSecondYAxis(iScope, bl);
        string = Cast.asString(iScope, this.getFacetValue(iScope, "legend"));
        chartDataSourceUnique.setLegend(iScope, string);
        IExpression iExpression = this.getFacet("value").resolveAgainst(iScope);
        chartDataSourceUnique.setValueExp(iScope, iExpression);
        iExpression = this.getFacet(YERR_VALUES);
        if (iExpression != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceUnique.setYErrValueExp(iScope, iExpression);
        }
        if ((iExpression = this.getFacet(XERR_VALUES)) != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceUnique.setXErrValueExp(iScope, iExpression);
        }
        if ((iExpression = this.getFacet(YMINMAX_VALUES)) != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceUnique.setYMinMaxValueExp(iScope, iExpression);
        }
        if ((iExpression = this.getFacet("color")) != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceUnique.setColorExp(iScope, iExpression);
        }
        if ((iExpression = this.getFacet(THICKNESS)) != null) {
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceUnique.setLineThickness(iExpression);
        }
        if ((var7_7 = this.getFacetValue(iScope, CUMUL_VALUES, null)) != null) {
            chartDataSourceUnique.setCumulative(iScope, Cast.asBool(iScope, var7_7));
            chartDataSourceUnique.setForceCumulative(iScope, true);
        }
        chartDataSourceUnique.createInitialSeries(iScope);
        iExpression = this.getFacet(MARKERSIZE);
        if (iExpression != null) {
            chartDataSourceUnique.setUseSize(true);
            iExpression = iExpression.resolveAgainst(iScope);
            chartDataSourceUnique.setMarkerSize(iScope, iExpression);
        }
        string = this.getFacetValue(iScope, MARKERSHAPE, null);
        chartDataSourceUnique.setMarkerShape(iScope, string);
        return chartDataSourceUnique;
    }

    @Override
    protected Object privateExecuteIn(IScope iScope) {
        ChartDataSet chartDataSet = (ChartDataSet)iScope.getVarValue("chart_dataset_transfer");
        ChartDataSourceUnique chartDataSourceUnique = this.createDataSource(iScope, chartDataSet);
        chartDataSet.addDataSource(chartDataSourceUnique);
        return chartDataSourceUnique;
    }
}

