/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.properties;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.properties.CameraDefinition;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;

@GamlAnnotations.inside(symbols={"display"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={4}, optional=false, doc={@GamlAnnotations.doc(value="The name of the camera. Will be used to populate a menu with the other camera presets. Can provide a value to the 'camera:' facet of the display, which specifies which camera to use.Using the special constant #default will make it the default of the surrounding display")}), @GamlAnnotations.facet(name="dynamic", type={3}, optional=true, doc={@GamlAnnotations.doc(value="If true, the location, distance and target are automatically recomputed every step. Default is false. When true, will also set 'locked' to true, to avoid interferences from users")}), @GamlAnnotations.facet(name="distance", type={2}, optional=true, doc={@GamlAnnotations.doc(value="If the 'location:' facet is not defined, defines the distance (in world units) that separates the camera from its target. If 'location:' is defined, especially if it is using a symbolic position, allows to specify the distance to keep from the target. If neither 'location:' or 'distance:' is defined, the default distance is the maximum between the width and the height of the world")}), @GamlAnnotations.facet(name="location", type={7, 4}, optional=true, doc={@GamlAnnotations.doc(value="Allows to define the location of the camera in the world, i.e. from where it looks at its target. If 'distance:' is specified, the final location is translated on the target-camera axis to respect the distance. Can be a (possibly dynamically computed) point or a symbolic position (#from_above, #from_left, #from_right, #from_up_right, #from_up_left, #from_front, #from_up_front) that will be dynamically recomputed if the target movesIf 'location:' is not defined, it will be that of the default camera (#from_top, #from_left...) defined in the preferences.")}), @GamlAnnotations.facet(name="target", type={7, 11, 13}, optional=true, doc={@GamlAnnotations.doc(value="Allows to define the target of the camera (what does it look at). It can be a point (in world coordinates), a geometry or an agent, in which case its (possibly dynamic) location it used as the target. This facet can be complemented by 'distance:' and/or 'location:' to specify from where the target is looked at. If 'target:' is not defined, the default target is the centroid of the world shape. ")}), @GamlAnnotations.facet(name="lens", type={2, 1}, optional=true, doc={@GamlAnnotations.doc(value="Allows to define the lens -- field of view in degrees -- of the camera. Between 0 and 360. Defaults to 45\u00b0")}), @GamlAnnotations.facet(name="locked", type={3}, optional=true, doc={@GamlAnnotations.doc(value="If true, the user cannot modify the camera location and target by interacting with the display. It is automatically set when the camera is dynamic, so that the display can 'follow' the coordinates; but it can also be used with fixed coordinates to 'focus' the display on a specific scene")})}, omissible="name")
@GamlAnnotations.doc(value="`camera` allows the modeler to define a camera. The display will then be able to choose among the camera defined (either within this statement or globally in GAMA) in a dynamic way. Several preset cameras are provided and accessible in the preferences (to choose the default) or in GAML using the keywords #from_above, #from_left, #from_right, #from_up_right, #from_up_left, #from_front, #from_up_front, #isometric.These cameras are unlocked (so that they can be manipulated by the user), look at the center of the world from a symbolic position, and the distance between this position and the target is equal to the maximum of the width and height of the world's shape. These preset cameras can be reused when defining new cameras, since their names can become symbolic positions for them. For instance: camera 'my_camera' location: #from_top distance: 10; will lower (or extend) the distance between the camera and the center of the world to 10. camera 'my_camera' locked: true location: #from_up_front target: people(0); will continuously follow the first agent of the people species from the up-front position. ", see={"display", "agents", "chart", "event", "graphics", "display_grid", "image_layer", "species_layer"})
@validator(value=AbstractLayerStatement.OpenGLSpecificLayerValidator.class)
public class CameraStatement
extends AbstractLayerStatement {
    final CameraDefinition definition = new CameraDefinition(this);

    public CameraStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return ILayerStatement.LayerType.CAMERA;
    }

    @Override
    protected boolean _init(IScope iScope) {
        this.definition.refresh(iScope);
        return true;
    }

    @Override
    protected boolean _step(IScope iScope) {
        this.definition.refresh(iScope);
        return true;
    }

    public CameraDefinition getDefinition() {
        return this.definition;
    }
}

