/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime;

import org.eclipse.core.runtime.Platform;

public class PlatformHelper {
    private static String platformString = Platform.getOS();
    private static boolean isWindows = "win32".equals(platformString);
    private static boolean isMac = "macosx".equals(platformString);
    private static boolean isLinux = "linux".equals(platformString);
    private static boolean isARM = "aarch64".equals(Platform.getOSArch());
    private static volatile Boolean isDeveloper;
    public static final int JAVA_VERSION;

    static {
        JAVA_VERSION = PlatformHelper.parseVersion(System.getProperty("java.version"));
    }

    private PlatformHelper() {
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isDeveloper() {
        if (isDeveloper == null) {
            isDeveloper = Platform.getInstallLocation() == null || Platform.getInstallLocation().getURL().getPath().contains("org.eclipse.pde.core");
        }
        return isDeveloper;
    }

    static int parseVersion(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        n6 = ++n5;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n2 = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        n6 = ++n5;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n3 = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return PlatformHelper.javaVersion(n, n2, n3);
    }

    public static int javaVersion(int n, int n2, int n3) {
        return (n << 16) + (n2 << 8) + n3;
    }

    public static boolean isARM() {
        return isARM;
    }
}

