/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import java.io.IOException;
import java.io.Writer;

class JsonWriter {
    private static final int CONTROL_CHARACTERS_END = 31;
    private static final char[] QUOT_CHARS = new char[]{'\\', '\"'};
    private static final char[] BS_CHARS = new char[]{'\\', '\\'};
    private static final char[] LF_CHARS = new char[]{'\\', 'n'};
    private static final char[] CR_CHARS = new char[]{'\\', 'r'};
    private static final char[] TAB_CHARS = new char[]{'\\', 't'};
    private static final char[] UNICODE_2028_CHARS = new char[]{'\\', 'u', '2', '0', '2', '8'};
    private static final char[] UNICODE_2029_CHARS = new char[]{'\\', 'u', '2', '0', '2', '9'};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected final Writer writer;

    JsonWriter(Writer writer) {
        this.writer = writer;
    }

    protected void writeLiteral(String string) throws IOException {
        this.writer.write(string);
    }

    protected void writeNumber(String string) throws IOException {
        this.writer.write(string);
    }

    protected void writeString(String string) throws IOException {
        this.writer.write(34);
        this.writeJsonString(string);
        this.writer.write(34);
    }

    protected void writeArrayOpen() throws IOException {
        this.writer.write(91);
    }

    protected void writeArrayClose() throws IOException {
        this.writer.write(93);
    }

    protected void writeArraySeparator() throws IOException {
        this.writer.write(44);
    }

    protected void writeObjectOpen() throws IOException {
        this.writer.write(123);
    }

    protected void writeObjectClose() throws IOException {
        this.writer.write(125);
    }

    protected void writeMemberName(String string) throws IOException {
        this.writer.write(34);
        this.writeJsonString(string);
        this.writer.write(34);
    }

    protected void writeMemberSeparator() throws IOException {
        this.writer.write(58);
    }

    protected void writeObjectSeparator() throws IOException {
        this.writer.write(44);
    }

    protected void writeJsonString(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char[] cArray = JsonWriter.getReplacementChars(string.charAt(n3));
            if (cArray != null) {
                this.writer.write(string, n2, n3 - n2);
                this.writer.write(cArray);
                n2 = n3 + 1;
            }
            ++n3;
        }
        this.writer.write(string, n2, n - n2);
    }

    private static char[] getReplacementChars(char c) {
        if (c > '\\') {
            if (c < '\u2028' || c > '\u2029') {
                return null;
            }
            return c == '\u2028' ? UNICODE_2028_CHARS : UNICODE_2029_CHARS;
        }
        if (c == '\\') {
            return BS_CHARS;
        }
        if (c > '\"') {
            return null;
        }
        if (c == '\"') {
            return QUOT_CHARS;
        }
        if (c > '\u001f') {
            return null;
        }
        switch (c) {
            case '\n': {
                return LF_CHARS;
            }
            case '\r': {
                return CR_CHARS;
            }
            case '\t': {
                return TAB_CHARS;
            }
        }
        return new char[]{'\\', 'u', '0', '0', HEX_DIGITS[c >> 4 & 0xF], HEX_DIGITS[c & 0xF]};
    }
}

