/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.weighted_tasks;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.architecture.weighted_tasks.WeightedTaskStatement;
import gama.gaml.architecture.weighted_tasks.WeightedTasksArchitecture;
import gama.gaml.compilation.ISymbol;
import java.util.Arrays;

@GamlAnnotations.skill(name="probabilistic_tasks", concept={"architecture", "behavior", "task_based"})
@GamlAnnotations.doc(value="A control architecture, based on the concept of tasks, which are executed with a probability depending on their weight. This skill extends WeightedTasksArchitecture skills and have all his actions and variables")
public class ProbabilisticTasksArchitecture
extends WeightedTasksArchitecture {
    public static final String PT = "probabilistic_tasks";
    double[] weights;

    @Override
    protected WeightedTaskStatement chooseTask(IScope iScope) throws GamaRuntimeException {
        Double d = 0.0;
        int n = 0;
        while (n < this.weights.length) {
            double d2 = ((WeightedTaskStatement)this.tasks.get(n)).computeWeight(iScope);
            d = d + d2;
            this.weights[n] = d2;
            ++n;
        }
        Double d3 = iScope.getRandom().between(0.0, d);
        d = 0.0;
        int n2 = 0;
        while (n2 < this.weights.length) {
            double d4 = this.weights[n2];
            if (d3 > d && d3 <= d + d4) {
                return (WeightedTaskStatement)this.tasks.get(n2);
            }
            d = d + d4;
            ++n2;
        }
        return null;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        super.setChildren(iterable);
        this.weights = new double[this.tasks.size()];
        Arrays.fill(this.weights, 0.0);
    }
}

