/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.Iterables;
import gama.core.runtime.GAMA;
import gama.core.util.ConsumerWithPruning;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.compilation.IAgentConstructor;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.descriptions.ValidationContext;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.statements.Facets;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.Types;
import gama.gaml.types.TypesManager;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class ModelDescription
extends SpeciesDescription {
    public static final String MODEL_SUFFIX = "_model";
    public static volatile ModelDescription ROOT;
    public static volatile Map<String, ModelDescription> BUILT_IN_MODELS;
    private IMap<String, ExperimentDescription> experiments;
    final ITypesManager types;
    private String modelFilePath;
    private final String modelProjectPath;
    private final Set<String> alternatePaths;
    private final ValidationContext validationContext;
    private IMap<String, ModelDescription> microModels;
    private String alias = "";
    private Collection<String> importedModelNames;

    static {
        BUILT_IN_MODELS = new HashMap<String, ModelDescription>();
    }

    public Collection<String> getAlternatePaths() {
        return this.alternatePaths == null ? Collections.EMPTY_LIST : this.alternatePaths;
    }

    public ModelDescription getMicroModel(String string) {
        if (this.microModels == null) {
            return null;
        }
        return (ModelDescription)this.microModels.get(string);
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isMicroModel() {
        return this.alias != null && !this.alias.isEmpty();
    }

    @Override
    public boolean isModel() {
        return true;
    }

    public ModelDescription(String string, Class clazz, String string2, String string3, EObject eObject, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, Iterable<? extends IDescription> iterable, Facets facets2, ValidationContext validationContext, Set<String> set, IAgentConstructor iAgentConstructor, Set<String> set2) {
        super("model", clazz, speciesDescription == null ? GamaMetaModel.getExperimentDescription() : speciesDescription, speciesDescription2, iterable, eObject, facets2, set2);
        this.setName(string);
        this.types = speciesDescription2 instanceof ModelDescription ? new TypesManager(((ModelDescription)speciesDescription2).types) : Types.builtInTypes;
        this.modelFilePath = string3;
        this.modelProjectPath = string2;
        this.validationContext = validationContext;
        this.alternatePaths = set;
        if (iAgentConstructor != null) {
            this.setAgentConstructor(iAgentConstructor);
        }
    }

    public ModelDescription(String string, Class clazz, String string2, String string3, EObject eObject, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, Iterable<? extends IDescription> iterable, Facets facets2, ValidationContext validationContext, Set<String> set, IAgentConstructor iAgentConstructor) {
        this(string, clazz, string2, string3, eObject, speciesDescription, speciesDescription2, iterable, facets2, validationContext, set, iAgentConstructor, Collections.EMPTY_SET);
    }

    @Override
    public SymbolSerializer createSerializer() {
        return MODEL_SERIALIZER;
    }

    @Override
    public String getTitle() {
        return this.getName().replace(MODEL_SUFFIX, "");
    }

    @Override
    protected boolean verifyParent() {
        if (this.parent == ROOT) {
            return true;
        }
        return super.verifyParent();
    }

    @Override
    public void markAttributeRedefinition(VariableDescription variableDescription, VariableDescription variableDescription2) {
        EObject eObject;
        if (variableDescription2.isBuiltIn()) {
            return;
        }
        if (variableDescription.isBuiltIn()) {
            variableDescription2.info("This definition of " + variableDescription2.getName() + " supersedes the one in " + variableDescription.getOriginName(), "gaml.redefinition.info", "name", new String[0]);
            return;
        }
        EObject eObject2 = variableDescription2.getUnderlyingElement().eContainer();
        if (Objects.equals(eObject2, eObject = variableDescription.getUnderlyingElement().eContainer())) {
            variableDescription.error("Attribute " + variableDescription2.getName() + " is defined twice", "gaml.duplicate.definition.issue", "name", new String[0]);
            variableDescription2.error("Attribute " + variableDescription2.getName() + " is defined twice", "gaml.duplicate.definition.issue", "name", new String[0]);
            return;
        }
        if (eObject != null) {
            variableDescription2.info("This definition of " + variableDescription2.getName() + " supersedes the one in imported file " + eObject.eResource().getURI().lastSegment(), "gaml.redefinition.info", "name", new String[0]);
        }
    }

    @Override
    public void documentThis(IGamlDescription.Doc doc2) {
        String string = this.getParent() == null ? "nil" : this.getParent().getName();
        doc2.append("<b>Subspecies of:</b> ").append(string).append("<br>");
        Iterable<String> iterable = this.getSkillsNames();
        if (!Iterables.isEmpty(iterable)) {
            doc2.append("<b>Skills:</b> ").append(iterable.toString()).append("<br>");
        }
        this.documentAttributes(doc2);
        this.documentActions(doc2);
    }

    public void setWorkingDirectory(String string) {
        this.modelFilePath = string + File.separator + new File(this.modelFilePath).getName();
    }

    @Override
    public String toString() {
        if (this.modelFilePath == null || this.modelFilePath.isEmpty()) {
            return "abstract model " + this.getName();
        }
        return "description of " + this.modelFilePath.substring(this.modelFilePath.lastIndexOf(File.separator));
    }

    @Override
    public void dispose() {
        if (this.isBuiltIn()) {
            return;
        }
        super.dispose();
        this.experiments = null;
        this.types.dispose();
    }

    public String getModelFilePath() {
        return this.modelFilePath;
    }

    public String getModelFolderPath() {
        return new File(this.modelFilePath).getParent();
    }

    public String getModelProjectPath() {
        return this.modelProjectPath;
    }

    public void buildTypes() {
        this.types.init(this);
    }

    @Override
    public IDescription addChild(IDescription iDescription) {
        if (iDescription == null) {
            return null;
        }
        if (iDescription instanceof ModelDescription) {
            ModelDescription modelDescription = (ModelDescription)iDescription;
            modelDescription.getTypesManager().setParent(this.getTypesManager());
            if (this.microModels == null) {
                this.microModels = GamaMapFactory.create();
            }
            this.microModels.put(((ModelDescription)iDescription).getAlias(), (ModelDescription)iDescription);
        }
        if (iDescription instanceof ExperimentDescription) {
            String string = iDescription.getName();
            if (this.experiments == null) {
                this.experiments = GamaMapFactory.createOrdered();
            }
            this.experiments.put(string, (ExperimentDescription)iDescription);
        } else {
            super.addChild(iDescription);
        }
        return iDescription;
    }

    @Override
    public void addOwnAttribute(VariableDescription variableDescription) {
        this.setIf(IDescription.Flag.StartingDateDefined, !variableDescription.isBuiltIn() && "starting_date".equals(variableDescription.getName()));
        super.addOwnAttribute(variableDescription);
    }

    public boolean isStartingDateDefined() {
        return this.isSet(IDescription.Flag.StartingDateDefined);
    }

    public boolean hasExperiment(String string) {
        if (this.experiments == null) {
            return false;
        }
        if (this.experiments.containsKey(string)) {
            return true;
        }
        for (ExperimentDescription experimentDescription : this.experiments.values()) {
            String string2 = experimentDescription.getExperimentTitleFacet();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModelDescription getModelDescription() {
        return this;
    }

    @Override
    public SpeciesDescription getSpeciesDescription(String string) {
        if (string.equals(this.getName()) || this.importedModelNames != null && this.importedModelNames.contains(string)) {
            return this;
        }
        if ("experiment".equals(string) && GAMA.getExperiment() != null) {
            return GAMA.getExperiment().getDescription();
        }
        if (this.getTypesManager() != null) {
            return this.getTypesManager().get(string).getSpecies();
        }
        if (this.hasMicroSpecies()) {
            return (SpeciesDescription)this.getMicroSpecies().get(string);
        }
        return null;
    }

    @Override
    public IType getTypeNamed(String string) {
        if (this.types == null) {
            return Types.NO_TYPE;
        }
        return this.types.get(string);
    }

    public ITypesManager getTypesManager() {
        return this.types;
    }

    @Override
    public SpeciesDescription getSpeciesContext() {
        return this;
    }

    public Set<String> getExperimentNames() {
        if (this.experiments == null) {
            return Collections.EMPTY_SET;
        }
        return new LinkedHashSet<String>(this.experiments.keySet());
    }

    public Set<String> getExperimentTitles() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.experiments != null) {
            this.experiments.forEachPair((string, experimentDescription) -> {
                if (experimentDescription.getOriginName().equals(this.getName())) {
                    linkedHashSet.add(experimentDescription.getExperimentTitleFacet());
                }
                return true;
            });
        }
        return linkedHashSet;
    }

    @Override
    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public ExperimentDescription getExperiment(String string) {
        if (this.experiments == null) {
            return null;
        }
        ExperimentDescription experimentDescription = (ExperimentDescription)this.experiments.get(string);
        if (experimentDescription == null) {
            for (ExperimentDescription experimentDescription2 : this.experiments.values()) {
                if (!experimentDescription2.getExperimentTitleFacet().equals(string)) continue;
                return experimentDescription2;
            }
        }
        return experimentDescription;
    }

    @Override
    public boolean visitChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        boolean bl = super.visitChildren(descriptionVisitor);
        if (bl && this.experiments != null) {
            bl &= this.experiments.forEachValue(descriptionVisitor);
        }
        return bl;
    }

    @Override
    public boolean visitOwnChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        return super.visitOwnChildren(descriptionVisitor) && (this.experiments == null || this.experiments.forEachValue(descriptionVisitor));
    }

    @Override
    public boolean visitOwnChildrenRecursively(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        IDescription.DescriptionVisitor descriptionVisitor2 = iDescription -> {
            if (!descriptionVisitor.process((IDescription)iDescription)) {
                return false;
            }
            return iDescription.visitOwnChildrenRecursively(descriptionVisitor);
        };
        return super.visitOwnChildrenRecursively(descriptionVisitor) && (this.experiments == null || this.experiments.forEachValue(descriptionVisitor2));
    }

    @Override
    public boolean finalizeDescription() {
        if (!super.finalizeDescription()) {
            return false;
        }
        if (this.actions != null) {
            for (ActionDescription actionDescription : this.actions.values()) {
                if (!actionDescription.isAbstract() || actionDescription.getUnderlyingElement() != null && actionDescription.getUnderlyingElement().eResource().equals(this.getUnderlyingElement().eResource())) continue;
                this.error("Abstract action '" + actionDescription.getName() + "', defined in " + actionDescription.getOriginName() + ", should be redefined.", "gaml.missing.action.issue");
                return false;
            }
        }
        return true;
    }

    @Override
    public ModelDescription validate() {
        if (!this.isSet(IDescription.Flag.Validated)) {
            super.validate();
            this.validationContext.doDocument(this);
        }
        return this;
    }

    public Collection<? extends ExperimentDescription> getExperiments() {
        if (this.experiments == null) {
            return Collections.EMPTY_LIST;
        }
        return this.experiments.values();
    }

    public void setImportedModelNames(Collection<String> collection) {
        this.importedModelNames = collection;
    }

    public void visitAllSpecies(final ConsumerWithPruning<SpeciesDescription> consumerWithPruning) {
        consumerWithPruning.process(this);
        if (!this.visitMicroSpecies(new IDescription.DescriptionVisitor<SpeciesDescription>(){

            @Override
            public boolean process(SpeciesDescription speciesDescription) {
                consumerWithPruning.process(speciesDescription);
                return speciesDescription.visitMicroSpecies(this);
            }
        })) {
            return;
        }
        if (this.experiments != null) {
            this.experiments.forEachValue(consumerWithPruning);
        }
    }

    public void getAllSpecies(List<SpeciesDescription> list) {
        IDescription.DescriptionVisitor descriptionVisitor = speciesDescription -> {
            list.add((SpeciesDescription)speciesDescription);
            return true;
        };
        this.visitAllSpecies(descriptionVisitor);
    }

    @Override
    protected boolean parentIsVisible() {
        if (!this.getParent().isModel()) {
            return false;
        }
        return this.parent.isBuiltIn();
    }
}

