/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.variables;

import gama.annotations.precompiler.GamlProperties;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.ICollector;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.variables.SelfExpression;
import gama.gaml.expressions.variables.VariableExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.IType;

public class AgentVariableExpression
extends VariableExpression
implements IVarExpression.Agent {
    public AgentVariableExpression(String string, IType iType, boolean bl, IDescription iDescription) {
        super(string, iType, bl, iDescription);
    }

    @Override
    public IExpression getOwner() {
        return new SelfExpression(this.getDefinitionDescription().getSpeciesContext().getGamlType());
    }

    @Override
    public Object _value(IScope iScope) throws GamaRuntimeException {
        return iScope.getAgentVarValue(iScope.getAgent(), this.getName());
    }

    @Override
    public void setVal(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        iScope.setAgentVarValue(iScope.getAgent(), this.getName(), object);
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        IDescription iDescription = this.getDefinitionDescription();
        if (iDescription == null) {
            return new IGamlDescription.ConstantDoc("Type " + this.type.getTitle());
        }
        IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc(new StringBuilder());
        VariableDescription variableDescription = iDescription.getSpeciesContext().getAttribute(this.name);
        regularDoc.append("Type ").append(this.type.getTitle()).append("<br/>");
        String string = null;
        if (variableDescription != null) {
            string = variableDescription.getBuiltInDoc();
        }
        if (string != null) {
            regularDoc.append(string).append("<br/>");
        }
        regularDoc.append(iDescription.isBuiltIn() ? "Built in " : (string == null ? "Defined in " : "Redefined in ")).append(iDescription.getTitle());
        return regularDoc;
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        if (this.getDefinitionDescription().isBuiltIn()) {
            gamlProperties.put("attributes", this.getName());
        }
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        SpeciesDescription speciesDescription2 = this.getDefinitionDescription().getSpeciesContext();
        if (speciesDescription.equals(speciesDescription2) || speciesDescription.hasParent(speciesDescription2)) {
            iCollector2.add(speciesDescription2.getAttribute(this.getName()));
        }
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        return this;
    }
}

