/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IMap;
import gama.core.util.path.IPath;
import gama.gaml.operators.Maths;
import gama.gaml.skills.MovingSkill;
import gama.gaml.types.GamaGeometryType;

@GamlAnnotations.doc(value="The moving skill 3D is intended to define the minimal set of behaviours required for agents that are able to move on different topologies")
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="speed", type=2, init="1.0", doc={@GamlAnnotations.doc(value="the speed of the agent (in meter/second)")}), @GamlAnnotations.variable(name="heading", type=2, init="rnd(360.0)", doc={@GamlAnnotations.doc(value="the absolute heading of the agent in degrees (in the range 0-359)")}), @GamlAnnotations.variable(name="pitch", type=2, init="rnd(360.0)", doc={@GamlAnnotations.doc(value="the absolute pitch of the agent in degrees (in the range 0-359)")}), @GamlAnnotations.variable(name="roll", type=2, init="rnd(360.0)", doc={@GamlAnnotations.doc(value="the absolute roll of the agent in degrees (in the range 0-359)")}), @GamlAnnotations.variable(name="destination", type=7, depends_on={"speed", "heading", "location"}, doc={@GamlAnnotations.doc(value="continuously updated destination of the agent with respect to its speed and heading (read-only)")})})
@GamlAnnotations.skill(name="moving3D", concept={"3d", "skill"})
public class MovingSkill3D
extends MovingSkill {
    @Override
    @GamlAnnotations.getter(value="destination")
    public GamaPoint getDestination(IAgent iAgent) {
        GamaPoint gamaPoint = iAgent.getLocation();
        double d = this.computeDistance(iAgent.getScope(), iAgent);
        ITopology iTopology = this.getTopology(iAgent);
        return iTopology.getDestination3D(iAgent.getScope(), gamaPoint, this.getHeading(iAgent), this.getPitch(iAgent), d, false);
    }

    @GamlAnnotations.getter(value="pitch")
    public Double getPitch(IAgent iAgent) {
        Double d = (Double)iAgent.getAttribute("pitch");
        if (d == null) {
            d = iAgent.getScope().getRandom().next() * 360.0;
            this.setPitch(iAgent, d);
        }
        return Maths.checkHeading(d);
    }

    @GamlAnnotations.setter(value="pitch")
    public void setPitch(IAgent iAgent, double d) {
        iAgent.setAttribute("pitch", d);
    }

    @GamlAnnotations.getter(value="roll")
    public Double getRoll(IAgent iAgent) {
        Double d = (Double)iAgent.getAttribute("roll");
        if (d == null) {
            d = iAgent.getScope().getRandom().next() * 360.0;
            this.setRoll(iAgent, d);
        }
        return Maths.checkHeading(d);
    }

    @GamlAnnotations.setter(value="roll")
    public void setRoll(IAgent iAgent, Double d) {
        iAgent.setAttribute("roll", d);
    }

    protected double computePitchFromAmplitude(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        int n = iScope.hasArg("amplitude") ? iScope.getIntArg("amplitude") : 359;
        this.setPitch(iAgent, this.getPitch(iAgent) + (double)iScope.getRandom().between(-n / 2, n / 2));
        return this.getPitch(iAgent);
    }

    protected double computePitch(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        Integer n;
        Integer n2 = n = iScope.hasArg("pitch") ? iScope.getIntArg("pitch") : null;
        if (n != null) {
            this.setPitch(iAgent, n.intValue());
        }
        return this.getPitch(iAgent);
    }

    @Override
    @GamlAnnotations.action(name="move", args={@GamlAnnotations.arg(name="speed", type=2, optional=true, doc={@GamlAnnotations.doc(value="the speed to use for this move (replaces the current value of speed)")}), @GamlAnnotations.arg(name="heading", type=1, optional=true, doc={@GamlAnnotations.doc(value="int, optional, the direction to take for this move (replaces the current value of heading)")}), @GamlAnnotations.arg(name="pitch", type=1, optional=true, doc={@GamlAnnotations.doc(value="int, optional, the direction to take for this move (replaces the current value of pitch)")}), @GamlAnnotations.arg(name="roll", type=1, optional=true, doc={@GamlAnnotations.doc(value="int, optional, the direction to take for this move (replaces the current value of roll)")}), @GamlAnnotations.arg(name="bounds", type=13, optional=true, doc={@GamlAnnotations.doc(value="the geometry (the localized entity geometry) that restrains this move (the agent moves inside this geometry")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do move speed: speed - 10 heading: heading + rnd (30) bounds: agentA;")}, value="moves the agent forward, the distance being computed with respect to its speed and heading. The value of the corresponding variables are used unless arguments are passed.")})
    public IPath primMoveForward(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        GamaPoint gamaPoint = iAgent.getLocation();
        double d = this.computeDistance(iScope, iAgent);
        double d2 = this.computeHeading(iScope, iAgent);
        double d3 = this.computePitch(iScope, iAgent);
        GamaPoint gamaPoint2 = iScope.getTopology().getDestination3D(iScope, gamaPoint, d2, d3, d, true);
        if (gamaPoint2 == null) {
            this.setHeading(iAgent, d2 - 180.0);
            this.setPitch(iAgent, -d3);
        } else {
            this.setLocation(iAgent, gamaPoint2);
            this.setHeading(iAgent, d2);
            this.setPitch(iAgent, d3);
        }
        return null;
    }

    @Override
    public boolean primMoveRandomly(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        GamaPoint gamaPoint = iAgent.getLocation();
        double d = this.computeHeadingFromAmplitude(iScope, iAgent);
        double d2 = this.computePitchFromAmplitude(iScope, iAgent);
        double d3 = this.computeDistance(iScope, iAgent);
        GamaPoint iShape = iScope.getTopology().getDestination3D(iScope, gamaPoint, d, d2, d3, true);
        if (iShape == null) {
            this.setHeading(iAgent, d - 180.0);
            this.setPitch(iAgent, -d2);
        } else {
            Object object = iScope.getArg("on", 15);
            Double d4 = null;
            if (object instanceof GamaSpatialGraph) {
                GamaSpatialGraph gamaSpatialGraph = (GamaSpatialGraph)object;
                IMap iMap = null;
                if (iScope.hasArg("proba_edges")) {
                    iMap = (IMap)iScope.getVarValue("proba_edges");
                }
                this.moveToNextLocAlongPathSimplified(iScope, iAgent, gamaSpatialGraph, d3, iMap);
                return true;
            }
            Object object2 = iScope.getArg("bounds", 0);
            if (object2 != null) {
                GamaPoint gamaPoint2;
                IShape iShape3 = GamaGeometryType.staticCast(iScope, object2, null, false);
                if (iShape3.getGeometries().size() > 1) {
                    for (IShape iShape22 : iShape3.getGeometries()) {
                        if (!(iShape22.euclidianDistanceTo(gamaPoint) < 0.01)) continue;
                        iShape3 = iShape22;
                        break;
                    }
                }
                if (iShape3.getInnerGeometry() != null && !(gamaPoint2 = this.computeLocationForward(iScope, d3, iShape, iShape3)).equals(iShape)) {
                    d4 = d - 180.0;
                    iShape = gamaPoint2;
                }
            }
            this.setLocation(iAgent, iShape);
            if (d4 != null) {
                this.setHeading(iAgent, d4);
            }
            this.setHeading(iAgent, d);
            this.setPitch(iAgent, d2);
        }
        return true;
    }

    @Override
    public IPath primGoto(IScope iScope) throws GamaRuntimeException {
        Object object = iScope.getArg("target", 0);
        if (object == null) {
            return null;
        }
        IAgent iAgent = this.getCurrentAgent(iScope);
        GamaPoint gamaPoint = iAgent.getLocation();
        super.primGoto(iScope);
        GamaPoint gamaPoint2 = iAgent.getLocation();
        GamaPoint gamaPoint3 = gamaPoint2.minus(gamaPoint);
        int n = Maths.signum(gamaPoint3.x);
        int n2 = Maths.signum(gamaPoint3.y);
        if (n == 0) {
            this.setHeading(iAgent, n2 == 0 ? 0 : (n2 > 0 ? 90 : 270));
        } else {
            this.setHeading(iAgent, Math.atan(gamaPoint3.y / gamaPoint3.x) * 57.29577951308232 + (double)(n > 0 ? 0 : 180));
        }
        if (n == 0 && n2 == 0) {
            int n3 = Maths.signum(gamaPoint3.z);
            this.setPitch(iAgent, n3 == 0 ? 0 : (n3 > 0 ? 90 : 270));
        } else {
            this.setPitch(iAgent, Math.atan(gamaPoint3.z / Math.sqrt(gamaPoint3.x * gamaPoint3.x + gamaPoint3.y * gamaPoint3.y)) * 57.29577951308232);
        }
        return null;
    }
}

