/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.IContainer;
import gama.core.util.IMap;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.Color;
import java.util.List;
import java.util.Map;

@GamlAnnotations.type(name="rgb", id=6, wraps={GamaColor.class, Color.class}, kind=104, concept={"type", "color"}, doc={@GamlAnnotations.doc(value="The type rgb represents colors in GAML, with their three red, green, blue components and, optionally, a fourth alpha component ")})
public class GamaColorType
extends GamaType<GamaColor> {
    @Override
    @GamlAnnotations.doc(value="Transforms the parameter into a rgb color. A second parameter can be used to express the transparency of the color, either an int (between 0 and 255) or a float (between 0 and 1)")
    public GamaColor cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaColorType.staticCast(iScope, object, object2, bl);
    }

    public static GamaColor staticCast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        Object object3;
        String[] stringArray;
        Object object4;
        if (object == null) {
            return null;
        }
        if (object instanceof GamaColor) {
            GamaColor gamaColor = (GamaColor)object;
            if (object2 instanceof Integer) {
                Integer n = (Integer)object2;
                return GamaColor.get(gamaColor.getRed(), gamaColor.getGreen(), gamaColor.getBlue(), (int)n);
            }
            if (object2 instanceof Double) {
                Double d = (Double)object2;
                return GamaColor.getWithDoubleAlpha(gamaColor.getRed(), gamaColor.getGreen(), gamaColor.getBlue(), d);
            }
            return (GamaColor)object;
        }
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            return switch (n) {
                case 0 -> GamaColor.get(Color.black);
                case 1, 2 -> GamaColorType.staticCast(iScope, ((List)object).get(0), object2, bl);
                case 3 -> GamaColor.get(Cast.asInt(iScope, list.get(0)), (int)Cast.asInt(iScope, list.get(1)), (int)Cast.asInt(iScope, list.get(2)), 255);
                default -> GamaColor.get(Cast.asInt(iScope, list.get(0)), (int)Cast.asInt(iScope, list.get(1)), (int)Cast.asInt(iScope, list.get(2)), (int)Cast.asInt(iScope, list.get(3)));
            };
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return GamaColor.get(Cast.asInt(iScope, map.get("red")), (int)Cast.asInt(iScope, map.get("green")), (int)Cast.asInt(iScope, map.get("blue")), (int)Cast.asInt(iScope, map.get("alpha")));
        }
        if (object instanceof IContainer) {
            return GamaColorType.staticCast(iScope, ((IContainer)object).listValue(iScope, Types.NO_TYPE, false), object2, bl);
        }
        if (object instanceof String) {
            object4 = ((String)object).toLowerCase();
            GamaColor gamaColor = GamaColor.colors.get(object4);
            if (gamaColor == null) {
                block24: {
                    try {
                        gamaColor = GamaColor.get(Color.decode((String)object4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        gamaColor = null;
                        if (object4 != null && ((String)object4).contains("rgb") && (stringArray = ((String)(object3 = ((String)object4).replace(" ", "").replace("rgb", "").replace("(", "").replace(")", ""))).split(",")).length >= 3) {
                            Integer n;
                            Integer n2 = Integer.valueOf(stringArray[0]);
                            Integer n3 = Integer.valueOf(stringArray[1]);
                            Integer n4 = Integer.valueOf(stringArray[2]);
                            Integer n5 = n = stringArray.length == 4 ? Integer.valueOf(stringArray[3]) : null;
                            if (n2 != null && n4 != null && n3 != null) {
                                gamaColor = GamaColor.get(n2, (int)n3, (int)n4, n == null ? 255 : n);
                            }
                        }
                        if (gamaColor != null) break block24;
                        throw GamaRuntimeException.error("'" + (String)object4 + "' is not a valid color name", iScope);
                    }
                }
                GamaColor.colors.put((String)object4, gamaColor);
            }
            if (object2 == null) {
                return gamaColor;
            }
            if (object2 instanceof Integer) {
                object3 = (Integer)object2;
                return GamaColor.get((Color)gamaColor, ((Integer)object3).intValue());
            }
            if (object2 instanceof Double) {
                stringArray = (Double)object2;
                return GamaColor.get((Color)gamaColor, stringArray.doubleValue());
            }
        }
        if (object instanceof Boolean) {
            object4 = (Boolean)object;
            return ((Boolean)object4).booleanValue() ? GamaColor.get(Color.black) : GamaColor.get(Color.white);
        }
        int n = Cast.asInt(iScope, object);
        if (object2 instanceof Integer) {
            object3 = (Integer)object2;
            return GamaColor.get(n, ((Integer)object3).intValue());
        }
        if (object2 instanceof Double) {
            stringArray = (String[])object2;
            return GamaColor.get(n, Double.valueOf(stringArray.doubleValue() * 255.0).intValue());
        }
        return GamaColor.get(n);
    }

    @Override
    public GamaColor getDefault() {
        return null;
    }

    @Override
    public IType getContentType() {
        return Types.get(1);
    }

    @Override
    public IType getKeyType() {
        return Types.get(1);
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    @Override
    public GamaColor deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        return this.cast(iScope, iMap, null, false);
    }
}

