/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaFont;
import gama.core.util.IMap;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaType;
import java.awt.Font;

@GamlAnnotations.type(name="font", id=19, wraps={GamaFont.class}, kind=104, doc={@GamlAnnotations.doc(value="Represents font objects that can be passed directly as arguments to draw statements and text layers. A font is identified by its face name (e.g. 'Helvetica'), its size in points (e.g. 12) and its style (i.e., #bold, #italic, or an addition of the 2")}, concept={"type", "text", "display"})
public class GamaFontType
extends GamaType<GamaFont> {
    @Override
    @GamlAnnotations.doc(value="Cast any object as a font", usages={@GamlAnnotations.usage(value="if the operand is a number, returns with the operand value as font size and the default display font style", examples={@GamlAnnotations.example(value="font f <- font(12);")}), @GamlAnnotations.usage(value="if the operand is a string, returns a font with this font name", examples={@GamlAnnotations.example(value="font f <- font(12);")})})
    public GamaFont cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaFontType.staticCast(iScope, object, bl);
    }

    public static GamaFont staticCast(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        if (object instanceof Number) {
            Number number = (Number)object;
            GamaFont gamaFont = GamaPreferences.Displays.DEFAULT_DISPLAY_FONT.getValue();
            return new GamaFont(gamaFont.getName(), gamaFont.getStyle(), number.intValue());
        }
        if (object instanceof GamaFont) {
            if (bl) {
                return new GamaFont((Font)object);
            }
            return (GamaFont)object;
        }
        if (object instanceof String) {
            return new GamaFont(Font.decode((String)object));
        }
        return GamaPreferences.Displays.DEFAULT_DISPLAY_FONT.getValue();
    }

    @Override
    public GamaFont getDefault() {
        return GamaPreferences.Displays.DEFAULT_DISPLAY_FONT.getValue();
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    public GamaFont deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        return new GamaFont(Cast.asString(iScope, iMap.get("name")), Cast.asInt(iScope, iMap.get("style")), Cast.asInt(iScope, iMap.get("size")));
    }
}

