/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization;

import gama.core.kernel.batch.Neighborhood;
import gama.core.kernel.batch.Neighborhood1Var;
import gama.core.kernel.batch.optimization.AOptimizationAlgorithm;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ALocalSearchAlgorithm
extends AOptimizationAlgorithm {
    protected static final String INIT_SOL = "init_solution";
    protected Neighborhood neighborhood;
    protected ParametersSet solutionInit;
    protected IExpression initSolExpression;

    public ALocalSearchAlgorithm(IDescription iDescription) {
        super(iDescription);
    }

    public Map<ParametersSet, Double> testSolutions(List<ParametersSet> list) {
        IMap iMap = GamaMapFactory.create();
        list.removeIf(parametersSet -> parametersSet == null);
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        for (ParametersSet iValue2 : list) {
            if (this.testedSolutions.containsKey(iValue2)) {
                iMap.put(iValue2, (Double)this.testedSolutions.get(iValue2));
                continue;
            }
            arrayList.add(iValue2);
        }
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent != null) {
            Map<ParametersSet, Double> map = batchAgent.runSimulationsAndReturnResults(arrayList).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getFirstFitness((Map)entry.getValue())));
            this.testedSolutions.putAll(map);
            iMap.putAll(map);
        }
        return iMap;
    }

    @Override
    public void initializeFor(IScope iScope, BatchAgent batchAgent) throws GamaRuntimeException {
        IMap iMap;
        super.initializeFor(iScope, batchAgent);
        List<IParameter.Batch> list = batchAgent.getParametersToExplore();
        this.neighborhood = new Neighborhood1Var(list);
        this.solutionInit = new ParametersSet(iScope, list, true);
        this.initSolExpression = this.getFacet(INIT_SOL);
        if (this.initSolExpression != null && (iMap = Cast.asMap(iScope, this.initSolExpression.value(iScope), false)) != null) {
            this.initSolution(iScope, iMap);
        }
    }

    public void initSolution(IScope iScope, Map<String, Object> map) {
        for (String string : map.keySet()) {
            if (!this.solutionInit.containsKey(string)) continue;
            this.solutionInit.put(string, map.get(string));
        }
    }
}

