/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.population;

import com.google.common.collect.Iterables;
import gama.core.common.interfaces.IValue;
import gama.core.common.util.RandomUtils;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.IPopulationSet;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.matrix.IMatrix;
import gama.gaml.species.ISpecies;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;

public class MetaPopulation
implements IContainer.Addressable<Integer, IAgent>,
IPopulationSet {
    protected final List<IPopulationSet<? extends IAgent>> populationSets;
    protected IMap<String, IPopulation> setOfPopulations;
    protected IContainerType type = Types.LIST.of(Types.AGENT);

    public MetaPopulation() {
        this.populationSets = new ArrayList<IPopulationSet<? extends IAgent>>();
    }

    public MetaPopulation(IPopulation<? extends IAgent>[] iPopulationArray) {
        this();
        IPopulation<? extends IAgent>[] iPopulationArray2 = iPopulationArray;
        int n = iPopulationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPopulation<? extends IAgent> iPopulation = iPopulationArray2[n2];
            this.addPopulation(iPopulation);
            ++n2;
        }
    }

    @Override
    public IPopulation<? extends IAgent> getPopulation(IScope iScope) {
        this.getMapOfPopulations(iScope);
        if (this.setOfPopulations.size() == 1) {
            return (IPopulation)this.setOfPopulations.values().iterator().next();
        }
        return null;
    }

    @Override
    public StreamEx<IAgent> stream(IScope iScope) {
        return StreamEx.of(this.populationSets).flatMap(iPopulationSet -> iPopulationSet.stream(iScope));
    }

    public void addPopulation(IPopulation iPopulation) {
        this.populationSets.add(iPopulation);
    }

    public void addPopulationSet(IPopulationSet iPopulationSet) {
        this.populationSets.add(iPopulationSet);
    }

    @Override
    public IContainerType getGamlType() {
        return this.type;
    }

    @Override
    public boolean hasAgentList() {
        return true;
    }

    @Override
    public IContainer<?, ? extends IAgent> getAgents(IScope iScope) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Collector.AsList asList = Collector.getList();){
            for (IPopulationSet<? extends IAgent> iPopulationSet : this.populationSets) {
                asList.add(iPopulationSet.iterable(iScope));
            }
            return GamaListFactory.create(iScope, Types.AGENT, Iterables.concat((Iterable)asList.items()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean accept(IScope iScope, IShape iShape, IShape iShape2) {
        IAgent iAgent = iShape2.getAgent();
        if (iAgent == iShape.getAgent()) {
            return false;
        }
        return this.contains(iScope, iAgent);
    }

    @Override
    public void filter(IScope iScope, IShape iShape2, Collection<? extends IShape> collection) {
        IAgent iAgent = iShape2 == null ? null : iShape2.getAgent();
        collection.remove(iAgent);
        collection.removeIf(iShape -> !this.contains(iScope, iShape));
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.serializeToGaml(false);
    }

    @Override
    public IValue copy(IScope iScope) throws GamaRuntimeException {
        MetaPopulation metaPopulation = new MetaPopulation();
        metaPopulation.populationSets.addAll(this.populationSets);
        return metaPopulation;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.populationSets.size() * 10);
        stringBuilder.append('[');
        int n = 0;
        while (n < this.populationSets.size()) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(StringUtils.toGaml(this.populationSets.get(n), bl));
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public IAgent get(IScope iScope, Integer n) throws GamaRuntimeException {
        return this.listValue(iScope, Types.NO_TYPE, false).get(iScope, n);
    }

    @Override
    public IAgent getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        return this.listValue(iScope, Types.NO_TYPE, false).getFromIndicesList(iScope, iList);
    }

    @Override
    public boolean contains(IScope iScope, Object object) throws GamaRuntimeException {
        if (!(object instanceof IAgent)) {
            return false;
        }
        for (IPopulationSet<? extends IAgent> iPopulationSet : this.populationSets) {
            if (!iPopulationSet.contains(iScope, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(IScope iScope, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n > 0 && n < this.length(iScope);
        }
        return false;
    }

    @Override
    public IAgent firstValue(IScope iScope) throws GamaRuntimeException {
        if (this.populationSets.size() == 0) {
            return null;
        }
        return (IAgent)this.populationSets.get(0).firstValue(iScope);
    }

    @Override
    public IAgent lastValue(IScope iScope) throws GamaRuntimeException {
        if (this.populationSets.size() == 0) {
            return null;
        }
        return (IAgent)this.populationSets.get(this.populationSets.size() - 1).lastValue(iScope);
    }

    @Override
    public int length(IScope iScope) {
        int n = 0;
        for (IPopulationSet<? extends IAgent> iPopulationSet : this.populationSets) {
            n += iPopulationSet.length(iScope);
        }
        return n;
    }

    @Override
    public boolean isEmpty(IScope iScope) {
        for (IPopulationSet<? extends IAgent> iPopulationSet : this.populationSets) {
            if (iPopulationSet.isEmpty(iScope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IContainer reverse(IScope iScope) throws GamaRuntimeException {
        return this.listValue(iScope, Types.AGENT, false).reverse(iScope);
    }

    @Override
    public IAgent anyValue(IScope iScope) {
        if (this.populationSets.size() == 0) {
            return null;
        }
        RandomUtils randomUtils = iScope.getRandom();
        int n = randomUtils.between(0, this.populationSets.size() - 1);
        return (IAgent)this.populationSets.get(n).anyValue(iScope);
    }

    @Override
    public IList<? extends IAgent> listValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        return GamaListFactory.create(iScope, iType, this.iterable(iScope));
    }

    @Override
    public IMatrix matrixValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        return this.listValue(iScope, iType, false).matrixValue(iScope, iType, false);
    }

    @Override
    public IMatrix matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        return this.listValue(iScope, iType, false).matrixValue(iScope, iType, gamaPoint, false);
    }

    @Override
    public IMap mapValue(IScope iScope, IType iType, IType iType2, boolean bl) throws GamaRuntimeException {
        return this.listValue(iScope, iType2, false).mapValue(iScope, iType, iType2, false);
    }

    @Override
    public Iterable<? extends IAgent> iterable(IScope iScope) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Collector.AsList asList = Collector.getList();){
            for (IPopulationSet<? extends IAgent> iPopulationSet : this.populationSets) {
                asList.add(iPopulationSet.iterable(iScope));
            }
            return Iterables.concat((Iterable)asList.items());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ISpecies getSpecies() {
        return null;
    }

    private Map<String, IPopulation> getMapOfPopulations(IScope iScope) {
        if (this.setOfPopulations == null) {
            this.setOfPopulations = GamaMapFactory.create();
            for (IPopulationSet<? extends IAgent> iPopulationSet : this.populationSets) {
                if (iPopulationSet instanceof MetaPopulation) {
                    this.setOfPopulations.putAll(((MetaPopulation)iPopulationSet).getMapOfPopulations(iScope));
                    continue;
                }
                Collection<IPopulation<IAgent>> collection = iPopulationSet.getPopulations(iScope);
                for (IPopulation<IAgent> iPopulation : collection) {
                    this.setOfPopulations.put(iPopulation.getName(), iPopulation);
                }
            }
        }
        return this.setOfPopulations;
    }

    public Collection<? extends IPopulation> getPopulations(IScope iScope) {
        return this.getMapOfPopulations(iScope).values();
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.array(this.populationSets);
    }
}

