/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.grid;

import gama.core.metamodel.agent.AbstractAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.metamodel.topology.grid.IGridAgent;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

public class MinimalGridAgent
extends AbstractAgent
implements IGridAgent {
    private final IShape geometry;
    private final GridPopulation population;

    public MinimalGridAgent(GridPopulation gridPopulation, int n) {
        super(n);
        this.population = gridPopulation;
        this.geometry = this.population.grid.matrix[n].getGeometry();
    }

    @Override
    public GamaColor getColor() {
        if (this.population.grid.isHexagon.booleanValue()) {
            return (GamaColor)this.getAttribute("color");
        }
        return GamaColor.get(this.population.grid.supportImagePixels[this.getIndex()]);
    }

    @Override
    public void setColor(GamaColor gamaColor) {
        if (this.population.grid.isHexagon.booleanValue()) {
            this.setAttribute("color", gamaColor);
        } else {
            this.population.grid.supportImagePixels[this.getIndex()] = gamaColor.getRGB();
        }
    }

    @Override
    public void setGeometricalType(IShape.Type type2) {
    }

    @Override
    public final int getX() {
        if (this.population.grid.isHexagon().booleanValue()) {
            return this.population.grid.getX(this.getGeometry());
        }
        return (int)(this.getLocation().getX() / this.population.grid.cellWidth);
    }

    @Override
    public final int getY() {
        if (this.population.grid.isHexagon().booleanValue()) {
            return this.population.grid.getY(this.getGeometry());
        }
        return (int)(this.getLocation().getY() / this.population.grid.cellHeight);
    }

    @Override
    public double getValue() {
        if (this.population.grid.gridValue != null) {
            return this.population.grid.gridValue[this.getIndex()];
        }
        return 0.0;
    }

    @Override
    public void setValue(double d) {
        if (this.population.grid.gridValue != null) {
            this.population.grid.gridValue[this.getIndex()] = d;
        }
    }

    public IPopulation<?> getPopulation() {
        return this.population;
    }

    @Override
    public IShape getGeometry(IScope iScope) {
        return this.geometry;
    }

    @Override
    public IList<IAgent> getNeighbors(IScope iScope) {
        return Cast.asList(iScope, this.population.grid.getNeighborhood().getNeighborsIn(iScope, this.getIndex(), 1));
    }

    @Override
    public IList<GamaPoint> getPoints() {
        return this.geometry.getPoints();
    }

    @Override
    public void setDepth(double d) {
    }

    @Override
    public Double getArea() {
        return this.geometry.getArea();
    }

    @Override
    public Double getVolume() {
        return this.geometry.getVolume();
    }

    @Override
    public double getPerimeter() {
        return this.geometry.getPerimeter();
    }

    @Override
    public IList<GamaShape> getHoles() {
        return this.geometry.getHoles();
    }

    @Override
    public GamaPoint getCentroid() {
        return this.geometry.getCentroid();
    }

    @Override
    public GamaShape getExteriorRing(IScope iScope) {
        return this.geometry.getExteriorRing(iScope);
    }

    @Override
    public Double getWidth() {
        return this.geometry.getWidth();
    }

    @Override
    public Double getHeight() {
        return this.geometry.getHeight();
    }

    @Override
    public Double getDepth() {
        return this.geometry.getDepth();
    }

    @Override
    public GamaShape getGeometricEnvelope() {
        return this.geometry.getGeometricEnvelope();
    }

    @Override
    public IList<? extends IShape> getGeometries() {
        return this.geometry.getGeometries();
    }

    @Override
    public boolean isMultiple() {
        return this.geometry.isMultiple();
    }

    @Override
    public IList<Double> getBands() {
        if (this.population.grid.nbBands == 1) {
            IList<Double> iList = GamaListFactory.create(null, (IType)Types.FLOAT, new Double[0]);
            iList.add(this.getValue());
            return iList;
        }
        return this.population.grid.bands.get(this.getIndex());
    }
}

