/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gama.core.common.interfaces.IStepable;
import gama.core.common.preferences.GamaPreferences;
import gama.core.outputs.AbstractOutput;
import gama.core.outputs.IOutput;
import gama.core.outputs.IOutputManager;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.LayoutStatement;
import gama.core.outputs.MonitorOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public abstract class AbstractOutputManager
extends Symbol
implements IOutputManager {
    final IExpression autosave;
    volatile boolean inInitPhase;
    LayoutStatement layout;
    protected final OutputMap outputs = new OutputMap();
    protected int displayIndex;
    protected boolean hasMonitors;

    static {
        DEBUG.OFF();
    }

    public AbstractOutputManager(IDescription iDescription) {
        super(iDescription);
        boolean bl;
        this.autosave = iDescription.getFacetExpr("autosave");
        boolean bl2 = bl = GamaPreferences.Runtime.CORE_SYNC.getValue() != false || "true".equals(iDescription.getLitteral("synchronized")) || iDescription.hasFacet("autosave") && !"false".equals(iDescription.getLitteral("autosave"));
        if (bl) {
            GAMA.synchronizeFrontmostExperiment();
        }
    }

    @Override
    public Iterator<IOutput> iterator() {
        return this.outputs.values().iterator();
    }

    @Override
    public IOutput getOutputWithId(String string) {
        return this.outputs.get(string);
    }

    @Override
    public void putAll(Map<String, IOutput> map) {
        this.outputs.putAll((Map<? extends String, ? extends IOutput>)map);
    }

    @Override
    public IOutput getOutputWithOriginalName(String string) {
        return this.outputs.findOutputWith(iOutput -> iOutput.getOriginalName().equals(string));
    }

    @Override
    public void add(IOutput iOutput) {
        this.hasMonitors |= iOutput instanceof MonitorOutput;
        this.outputs.put(iOutput.getId(), iOutput);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        try {
            GAMA.desynchronizeFrontmostExperiment();
            for (IOutput iOutput : this.outputs.values()) {
                iOutput.dispose();
            }
            this.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void clear() {
        this.outputs.clear();
    }

    @Override
    public void remove(IOutput iOutput) {
        if (!(iOutput instanceof AbstractOutput)) {
            return;
        }
        if (((AbstractOutput)iOutput).isUserCreated()) {
            iOutput.dispose();
            this.outputs.remove(iOutput.getName());
        } else {
            iOutput.setPaused(true);
        }
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        for (ISymbol iSymbol : iterable) {
            if (iSymbol instanceof LayoutStatement) {
                this.layout = (LayoutStatement)iSymbol;
                continue;
            }
            if (!(iSymbol instanceof IOutput)) continue;
            IOutput iOutput = (IOutput)iSymbol;
            if (iOutput.isAutoSave()) {
                GAMA.synchronizeFrontmostExperiment();
            }
            this.add(iOutput);
            iOutput.setUserCreated(false);
            if (!(iOutput instanceof LayeredDisplayOutput)) continue;
            LayeredDisplayOutput layeredDisplayOutput = (LayeredDisplayOutput)iOutput;
            layeredDisplayOutput.setIndex(this.displayIndex++);
        }
    }

    @Override
    public void forceUpdateOutputs() {
        this.outputs.forEach((BiConsumer<? super String, ? super IOutput>)((BiConsumer<String, IOutput>)(string, iOutput) -> iOutput.update()));
    }

    @Override
    public void pause() {
        this.outputs.forEach((BiConsumer<? super String, ? super IOutput>)((BiConsumer<String, IOutput>)(string, iOutput) -> iOutput.setPaused(true)));
    }

    @Override
    public void resume() {
        this.outputs.forEach((BiConsumer<? super String, ? super IOutput>)((BiConsumer<String, IOutput>)(string, iOutput) -> iOutput.setPaused(false)));
    }

    @Override
    public void close() {
        this.outputs.forEach((BiConsumer<? super String, ? super IOutput>)((BiConsumer<String, IOutput>)(string, iOutput) -> iOutput.close()));
    }

    @Override
    public Collection<MonitorOutput> getMonitors() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.outputs.values(), MonitorOutput.class));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean init(IScope iScope) {
        this.name = iScope.getRoot().getName();
        for (IOutput iOutput : ImmutableList.copyOf(this.outputs.values())) {
            if (this.open(iScope, iOutput)) continue;
            return false;
        }
        this.evaluateAutoSave(iScope);
        return true;
    }

    private boolean evaluateAutoSave(IScope iScope) throws GamaRuntimeException {
        boolean bl = false;
        if (this.autosave != null) {
            String string = null;
            bl = this.autosave.getGamlType().equals(Types.STRING) ? (string = Cast.asString(iScope, this.autosave.value(iScope))) != null && !string.isBlank() : Cast.asBool(iScope, this.autosave.value(iScope));
            if (bl) {
                iScope.getGui().getSnapshotMaker().takeAndSaveScreenshot(iScope, string);
            }
        }
        return bl;
    }

    public void setLayout(LayoutStatement layoutStatement) {
        this.layout = layoutStatement;
    }

    public LayoutStatement getLayout() {
        return this.layout;
    }

    @Override
    public boolean open(IScope iScope, IOutput iOutput) {
        if (iScope.init(iOutput).passed()) {
            iOutput.setPaused(false);
            if (this.initialStep(iScope, iOutput)) {
                try {
                    iOutput.open();
                    iOutput.update();
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean initialStep(IScope iScope, IOutput iOutput) {
        this.inInitPhase = true;
        boolean bl = false;
        try {
            bl = iScope.step(iOutput).passed();
        }
        finally {
            this.inInitPhase = false;
        }
        return bl;
    }

    @Override
    public boolean step(IScope iScope) {
        this.outputs.forEach((BiConsumer<? super String, ? super IOutput>)((BiConsumer<String, IOutput>)(string, iOutput) -> {
            if (iOutput instanceof LayeredDisplayOutput) {
                LayeredDisplayOutput layeredDisplayOutput = (LayeredDisplayOutput)iOutput;
                layeredDisplayOutput.linkScopeWithGraphics();
            }
            if (iOutput.isRefreshable() && iOutput.getScope().step((IStepable)iOutput).passed()) {
                iOutput.update();
            }
        }));
        this.evaluateAutoSave(iScope);
        return true;
    }

    @Override
    public boolean hasMonitors() {
        return this.hasMonitors;
    }

    @Override
    public boolean isEmpty() {
        return this.outputs.isEmpty();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super IOutput> biConsumer) {
        this.outputs.forEach(biConsumer);
    }

    static class OutputMap
    implements Map<String, IOutput> {
        int monitorOrder;
        final Map<String, IOutput> actualOutputs = new ConcurrentHashMap<String, IOutput>();
        final LinkedHashSet<String> outputNames = new LinkedHashSet();
        final IMap<String, IOutput> virtualOutputs = GamaMapFactory.create();

        OutputMap() {
        }

        @Override
        public int size() {
            return this.outputNames.size();
        }

        @Override
        public boolean isEmpty() {
            return this.outputNames.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.actualOutputs.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.actualOutputs.containsValue(object);
        }

        @Override
        public IOutput get(Object object) {
            return this.actualOutputs.get(object);
        }

        @Override
        public IOutput put(String string, IOutput iOutput) {
            if (iOutput == null) {
                return null;
            }
            if (iOutput.isVirtual()) {
                return this.virtualOutputs.put(string, iOutput);
            }
            if (iOutput instanceof MonitorOutput) {
                MonitorOutput monitorOutput = (MonitorOutput)iOutput;
                monitorOutput.setOrder(this.monitorOrder++);
            }
            if (this.actualOutputs.containsKey(string)) {
                this.outputNames.remove(string);
            }
            this.outputNames.add(string);
            return this.actualOutputs.put(string, iOutput);
        }

        @Override
        public IOutput remove(Object object) {
            return this.outputNames.remove(object) ? this.actualOutputs.remove(object) : null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends IOutput> map) {
            map.forEach(this::put);
        }

        @Override
        public void clear() {
            this.outputNames.clear();
            this.actualOutputs.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.outputNames;
        }

        @Override
        public Collection<IOutput> values() {
            ArrayList<IOutput> arrayList = new ArrayList<IOutput>();
            this.outputNames.forEach((? super T string) -> arrayList.add(this.actualOutputs.get(string)));
            return arrayList;
        }

        @Override
        public Set<Map.Entry<String, IOutput>> entrySet() {
            return this.actualOutputs.entrySet();
        }

        @Override
        public void forEach(BiConsumer<? super String, ? super IOutput> biConsumer) {
            this.outputNames.forEach((? super T string) -> biConsumer.accept((String)string, this.actualOutputs.get(string)));
        }

        public IOutput findOutputWith(Predicate<? super IOutput> predicate) {
            for (IOutput iOutput : this.actualOutputs.values()) {
                if (!predicate.test(iOutput)) continue;
                return iOutput;
            }
            return null;
        }
    }
}

