/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.graph.GamaGraph;
import gama.dev.DEBUG;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.operators.Cast;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;

@GamlAnnotations.species(name="graph_node", concept={"graph", "node"}, doc={@GamlAnnotations.doc(value="A base species to use as a parent for species representing agents that are nodes of a graph")})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="my_graph", type=15, doc={@GamlAnnotations.doc(value="A reference to the graph containing the agent")})})
@GamlAnnotations.doc(value="A base species to use as a parent for species representing agents that are nodes of a graph")
public class AbstractGraphNodeAgent
extends GamlAgent {
    static final Arguments args = new Arguments();

    public AbstractGraphNodeAgent(IPopulation<? extends IAgent> iPopulation, int n) throws GamaRuntimeException {
        super(iPopulation, n);
    }

    IStatement.WithArgs getAction() {
        return this.getSpecies().getAction("related_to");
    }

    @GamlAnnotations.action(doc={@GamlAnnotations.doc(value="This operator should never be called")}, name="related_to", virtual=true, args={@GamlAnnotations.arg(doc={@GamlAnnotations.doc(value="The other agent")}, name="other", optional=false, type=11)})
    public Boolean relatedTo(IScope iScope) {
        DEBUG.LOG((Object)"Should never be called !");
        return false;
    }

    @GamlAnnotations.getter(value="my_graph")
    public GamaGraph getGraph() {
        return (GamaGraph)this.getTopology().getPlaces();
    }

    public static class NodeRelation
    implements GamaSpatialGraph.VertexRelationship<AbstractGraphNodeAgent> {
        IStatement.WithArgs action;

        @Override
        public boolean related(IScope iScope, AbstractGraphNodeAgent abstractGraphNodeAgent, AbstractGraphNodeAgent abstractGraphNodeAgent2) {
            args.put("other", ConstantExpressionDescription.create(abstractGraphNodeAgent2));
            ExecutionResult executionResult = iScope.execute(this.getAction(abstractGraphNodeAgent), abstractGraphNodeAgent, args);
            return Cast.asBool(iScope, executionResult.getValue());
        }

        @Override
        public boolean equivalent(IScope iScope, AbstractGraphNodeAgent abstractGraphNodeAgent, AbstractGraphNodeAgent abstractGraphNodeAgent2) {
            return abstractGraphNodeAgent == abstractGraphNodeAgent2;
        }

        IStatement.WithArgs getAction(AbstractGraphNodeAgent abstractGraphNodeAgent) {
            if (this.action == null) {
                this.action = abstractGraphNodeAgent.getAction();
            }
            return this.action;
        }
    }
}

