/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation.kernel;

import com.google.common.collect.Iterables;
import gama.core.common.interfaces.ISkill;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SkillDescription;
import gama.gaml.descriptions.VariableDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class GamaSkillRegistry {
    public static final GamaSkillRegistry INSTANCE = new GamaSkillRegistry();
    private final IMap<String, SkillDescription> skills = GamaMapFactory.createUnordered();
    private final Map<Class, String> classSkillNames = new HashMap<Class, String>();
    private List<String> architectureNames = null;
    private List<String> skillNames = null;

    private GamaSkillRegistry() {
    }

    public SkillDescription register(String string, Class<? extends ISkill> clazz, String string2, Iterable<IDescription> iterable, String ... stringArray) {
        IDescription iDescription2;
        if (iterable != null) {
            for (IDescription iDescription2 : iterable) {
                iDescription2.setOriginName("skill " + string);
                iDescription2.setDefiningPlugin(GamaBundleLoader.CURRENT_PLUGIN_NAME);
            }
        }
        iDescription2 = new SkillDescription(string, clazz, iterable, string2);
        this.classSkillNames.put(clazz, string);
        this.skills.put(string, (SkillDescription)iDescription2);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            GamaMetaModel.INSTANCE.addSpeciesSkill(string3, string);
            ++n2;
        }
        return iDescription2;
    }

    public SkillDescription get(String string) {
        return (SkillDescription)this.skills.get(string);
    }

    public SkillDescription get(Class clazz) {
        String string = this.classSkillNames.get(clazz);
        if (string == null) {
            return null;
        }
        return (SkillDescription)this.skills.get(string);
    }

    public ISkill getSkillInstanceFor(String string) {
        SkillDescription skillDescription = (SkillDescription)this.skills.get(string);
        return skillDescription == null ? null : skillDescription.getInstance();
    }

    public Class<? extends ISkill> getSkillClassFor(String string) {
        SkillDescription skillDescription = (SkillDescription)this.skills.get(string);
        return skillDescription == null ? null : skillDescription.getJavaBase();
    }

    public String getSkillNameFor(Class clazz) {
        return this.classSkillNames.get(clazz);
    }

    public boolean hasSkill(String string) {
        return this.skills.containsKey(string);
    }

    public Collection<String> getAllSkillNames() {
        return this.skills.keySet();
    }

    public Collection<String> getSkillNames() {
        if (this.skillNames != null) {
            return this.skillNames;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : this.getAllSkillNames()) {
            SkillDescription skillDescription = (SkillDescription)this.skills.get(string);
            if (skillDescription.isControl()) continue;
            linkedHashSet.add(string);
        }
        this.skillNames = new ArrayList<String>(linkedHashSet);
        return linkedHashSet;
    }

    public Collection<String> getArchitectureNames() {
        if (this.architectureNames != null) {
            return this.architectureNames;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : this.getAllSkillNames()) {
            SkillDescription skillDescription = (SkillDescription)this.skills.get(string);
            if (!skillDescription.isControl()) continue;
            linkedHashSet.add(string);
        }
        this.architectureNames = new ArrayList<String>(linkedHashSet);
        return linkedHashSet;
    }

    public Iterable<? extends IDescription> getVariablesForSkill(String string) {
        SkillDescription skillDescription = (SkillDescription)this.skills.get(string);
        if (skillDescription == null) {
            return Collections.EMPTY_LIST;
        }
        return skillDescription.getOwnAttributes();
    }

    public Iterable<? extends IDescription> getActionsForSkill(String string) {
        SkillDescription skillDescription = (SkillDescription)this.skills.get(string);
        if (skillDescription == null) {
            return Collections.EMPTY_LIST;
        }
        return skillDescription.getOwnActions();
    }

    public void visitSkills(IDescription.DescriptionVisitor descriptionVisitor) {
        this.skills.forEachValue(descriptionVisitor);
    }

    public Iterable<SkillDescription> getRegisteredSkills() {
        return this.skills.values();
    }

    public Iterable<? extends VariableDescription> getRegisteredSkillsAttributes() {
        return Iterables.concat((Iterable)Iterables.transform(this.getRegisteredSkills(), skillDescription -> skillDescription.getOwnAttributes()));
    }

    public Iterable<? extends ActionDescription> getRegisteredSkillsActions() {
        return Iterables.concat((Iterable)Iterables.transform(this.getRegisteredSkills(), skillDescription -> skillDescription.getOwnActions()));
    }
}

