/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.units;

import gama.core.runtime.IScope;
import gama.core.util.GamaDate;
import gama.gaml.expressions.units.UnitConstantExpression;
import gama.gaml.types.IType;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Set;

public class TimeUnitConstantExpression
extends UnitConstantExpression {
    private static final Set<String> UNCOMPUTABLE_DURATIONS = Set.of("month", "year", "months", "years", "y");
    final boolean isTimeDependent;
    final boolean isMonth;

    public static double approximalQuery(GamaDate gamaDate, ChronoUnit chronoUnit) {
        return gamaDate.until(gamaDate.plus(1L, (TemporalUnit)chronoUnit), ChronoUnit.SECONDS);
    }

    public TimeUnitConstantExpression(Object object, IType<?> iType, String string, String string2, String[] stringArray) {
        super(object, iType, string, string2, stringArray);
        this.isTimeDependent = UNCOMPUTABLE_DURATIONS.contains(string);
        this.isMonth = string.startsWith("m");
    }

    @Override
    public Object _value(IScope iScope) {
        return this.isTimeDependent ? Double.valueOf(TimeUnitConstantExpression.approximalQuery(iScope.getClock().getCurrentDate(), this.isMonth ? ChronoUnit.MONTHS : ChronoUnit.YEARS)) : super._value(iScope);
    }

    @Override
    public boolean isConst() {
        return !this.isTimeDependent;
    }

    @Override
    public boolean isAllowedInParameters() {
        return !this.isTimeDependent;
    }
}

