/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.PrimitiveDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.operators.Strings;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import java.util.Set;

@GamlAnnotations.inside(kinds={3, 11, 6}, symbols={"chart"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="action", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the name of an action or a primitive")}), @GamlAnnotations.facet(name="with", type={10}, of=0, index=4, optional=true, doc={@GamlAnnotations.doc(value="a map expression containing the parameters of the action")}), @GamlAnnotations.facet(name="internal_function", type={0}, optional=true, internal=true)}, omissible="action")
@GamlAnnotations.doc(value="Allows the agent to execute an action or a primitive.  For a list of primitives available in every species, see this [BuiltIn161 page]; for the list of primitives defined by the different skills, see this [Skills161 page]. Finally, see this [Species161 page] to know how to declare custom actions.", usages={@GamlAnnotations.usage(value="The simple syntax (when the action does not expect any argument and the result is not to be kept) is:", examples={@GamlAnnotations.example(value="do name_of_action_or_primitive;", isExecutable=false)}), @GamlAnnotations.usage(value="In case the action expects one or more arguments to be passed, they are defined by using facets (enclosed tags or a map are now deprecated):", examples={@GamlAnnotations.example(value="do name_of_action_or_primitive arg1: expression1 arg2: expression2;", isExecutable=false)}), @GamlAnnotations.usage(value="In case the result of the action needs to be made available to the agent, the action can be called with the agent calling the action (`self` when the agent itself calls the action) instead of `do`; the result should be assigned to a temporary variable:", examples={@GamlAnnotations.example(value="type_returned_by_action result <- self name_of_action_or_primitive [];", isExecutable=false)}), @GamlAnnotations.usage(value="In case of an action expecting arguments and returning a value, the following syntax is used:", examples={@GamlAnnotations.example(value="type_returned_by_action result <- self name_of_action_or_primitive [arg1::expression1, arg2::expression2];", isExecutable=false)}), @GamlAnnotations.usage(value="Deprecated uses: following uses of the `do` statement (still accepted) are now deprecated:", examples={@GamlAnnotations.example(value="// Simple syntax: "), @GamlAnnotations.example(value="do action: name_of_action_or_primitive;", isExecutable=false), @GamlAnnotations.example(value=""), @GamlAnnotations.example(value="// In case the result of the action needs to be made available to the agent, the `returns` keyword can be defined; the result will then be referred to by the temporary variable declared in this attribute:"), @GamlAnnotations.example(value="do name_of_action_or_primitive returns: result;", isExecutable=false), @GamlAnnotations.example(value="do name_of_action_or_primitive arg1: expression1 arg2: expression2 returns: result;", isExecutable=false), @GamlAnnotations.example(value="type_returned_by_action result <- name_of_action_or_primitive(self, [arg1::expression1, arg2::expression2]);", isExecutable=false), @GamlAnnotations.example(value=""), @GamlAnnotations.example(value="// In case the result of the action needs to be made available to the agent"), @GamlAnnotations.example(value="let result <- name_of_action_or_primitive(self, []);", isExecutable=false), @GamlAnnotations.example(value=""), @GamlAnnotations.example(value="// In case the action expects one or more arguments to be passed, they can also be defined by using enclosed `arg` statements, or the `with` facet with a map of parameters:"), @GamlAnnotations.example(value="do name_of_action_or_primitive with: [arg1::expression1, arg2::expression2];", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="or", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="do name_of_action_or_primitive {", isExecutable=false), @GamlAnnotations.example(value="     arg arg1 value: expression1;", isExecutable=false), @GamlAnnotations.example(value="     arg arg2 value: expression2;", isExecutable=false), @GamlAnnotations.example(value="     ...", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
@validator(value=DoValidator.class)
@serializer(value=DoSerializer.class)
public class DoStatement
extends AbstractStatementSequence
implements IStatement.WithArgs {
    Arguments args;
    final String targetSpecies;
    final IExpression function;
    public static final Set<String> DO_FACETS = DescriptionFactory.getAllowedFacetsFor("do", "invoke");

    public DoStatement(IDescription iDescription) {
        super(iDescription);
        if (((StatementDescription)iDescription).isSuperInvocation()) {
            SpeciesDescription speciesDescription = iDescription.getSpeciesContext().getParent();
            this.targetSpecies = speciesDescription.getName();
        } else {
            this.targetSpecies = null;
        }
        this.function = this.getFacet("internal_function");
        this.setName(this.getLiteral("action"));
    }

    @Override
    public void enterScope(IScope iScope) {
        super.enterScope(iScope);
    }

    @Override
    public void setFormalArgs(Arguments arguments) {
        this.args = arguments;
    }

    public Arguments getRuntimeArgs(IScope iScope) {
        if (this.args == null) {
            return null;
        }
        return this.args.resolveAgainst(iScope);
    }

    private ISpecies getContext(IScope iScope) {
        return this.targetSpecies != null ? iScope.getModel().getSpecies(this.targetSpecies) : iScope.getAgent().getSpecies();
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        ISpecies iSpecies = this.getContext(iScope);
        if (iSpecies == null) {
            throw GamaRuntimeException.error("Impossible to find a species to execute " + this.getName(), iScope);
        }
        IStatement.WithArgs withArgs = iSpecies.getAction(this.name);
        Object object = null;
        if (withArgs != null) {
            ExecutionResult executionResult = iScope.execute(withArgs, this.getRuntimeArgs(iScope));
            object = executionResult.getValue();
        } else if (this.function != null) {
            object = this.function.value(iScope);
        } else {
            throw GamaRuntimeException.error("Impossible to find action " + this.getName() + " in " + iSpecies.getName(), iScope);
        }
        return object;
    }

    @Override
    public void setRuntimeArgs(IScope iScope, Arguments arguments) {
    }

    @Override
    public void dispose() {
        if (this.args != null) {
            this.args.dispose();
        }
        this.args = null;
        super.dispose();
    }

    public static class DoSerializer
    extends SymbolSerializer.StatementSerializer {
        @Override
        protected void serializeArg(IDescription iDescription, IDescription iDescription2, StringBuilder stringBuilder, boolean bl) {
            String string = iDescription2.getName();
            IExpressionDescription iExpressionDescription = iDescription2.getFacet("value");
            if (Strings.isGamaNumber(string).booleanValue()) {
                stringBuilder.append(iExpressionDescription.serializeToGaml(bl));
            } else {
                stringBuilder.append(string).append(":").append(iExpressionDescription.serializeToGaml(bl));
            }
        }

        @Override
        protected String serializeFacetValue(SymbolDescription symbolDescription, String string, boolean bl) {
            if (!DO_FACETS.contains(string)) {
                return null;
            }
            return super.serializeFacetValue(symbolDescription, string, bl);
        }
    }

    public static class DoValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            PrimitiveDescription primitiveDescription;
            String string;
            ActionDescription actionDescription;
            String string2 = statementDescription.getLitteral("action");
            boolean bl = statementDescription.isSuperInvocation();
            TypeDescription typeDescription = statementDescription.getSpeciesContext();
            if (!typeDescription.hasAction(string2, bl)) {
                statementDescription.error("Action " + string2 + " does not exist in " + typeDescription.getName(), "gaml.unknown.action.issue", "action", string2, typeDescription.getName());
            }
            if (bl) {
                typeDescription = typeDescription.getParent();
            }
            if ((actionDescription = typeDescription.getAction(string2)) instanceof PrimitiveDescription && (string = (primitiveDescription = (PrimitiveDescription)actionDescription).getDeprecated()) != null) {
                statementDescription.warning("Action " + string2 + " is deprecated: " + string, "gaml.deprecated.code.issue", "action", new String[0]);
            }
        }
    }
}

