/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.simulation;

import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.ExperimentPlan;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.ISerialisedAgent;
import gama.core.metamodel.population.GamaPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.topology.continuous.AmorphousTopology;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.concurrent.ISimulationRunner;
import gama.core.runtime.concurrent.SimulationRunner;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.compilation.IAgentConstructor;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.variables.IVariable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimulationPopulation
extends GamaPopulation<SimulationAgent> {
    private SimulationAgent currentSimulation;
    private final ISimulationRunner runner = SimulationRunner.of(this);

    public SimulationPopulation(ExperimentAgent experimentAgent, ISpecies iSpecies) {
        super(experimentAgent, iSpecies);
    }

    public int getMaxNumberOfConcurrentSimulations() {
        return GamaExecutorService.getParallelism(this.getHost().getScope(), this.getHost().getSpecies().getConcurrency(), GamaExecutorService.Caller.SIMULATION);
    }

    @Override
    public void removeValue(IScope iScope, Object object) {
        if (object instanceof SimulationAgent) {
            SimulationAgent simulationAgent = (SimulationAgent)object;
            int n = this.indexOf(simulationAgent);
            if (n == -1) {
                return;
            }
            this.setCurrentSimulation(this.nextSimulationAfter(n));
            super.removeValue(iScope, object);
        }
    }

    private SimulationAgent nextSimulationAfter(int n) {
        if (this.size() <= 1 || n == -1) {
            return null;
        }
        return (SimulationAgent)this.get((n + 1) % this.size());
    }

    @Override
    protected void fireAgentRemoved(IScope iScope, IAgent iAgent) {
        super.fireAgentRemoved(iScope, iAgent);
        this.runner.remove((SimulationAgent)iAgent);
    }

    @Override
    public void initializeFor(IScope iScope) {
        super.initializeFor(iScope);
        this.currentAgentIndex = 0;
    }

    @Override
    public void dispose() {
        this.runner.dispose();
        super.dispose();
    }

    @Override
    public Iterable<SimulationAgent> iterable(IScope iScope) {
        return (Iterable)((Object)this.getAgents(iScope));
    }

    @Override
    public IList<SimulationAgent> createAgents(IScope iScope, int n, List<? extends Map<String, Object>> list, boolean bl, boolean bl2, RemoteSequence remoteSequence) throws GamaRuntimeException {
        IList<SimulationAgent> iList = GamaListFactory.create(SimulationAgent.class);
        IAgentConstructor iAgentConstructor = this.species.getDescription().getAgentConstructor();
        iScope.getGui().getStatus().waitStatus("Initializing simulations", "status/status.simulation", () -> {
            int n2 = 0;
            while (n2 < n) {
                SimulationAgent simulationAgent = iAgentConstructor.createOneAgent(this, this.currentAgentIndex++);
                simulationAgent.setScheduled(bl2);
                simulationAgent.setName("Simulation " + simulationAgent.getIndex());
                this.add(simulationAgent);
                boolean bl3 = this.getHost().getSpecies().isBatch();
                if (!bl3) {
                    simulationAgent.setOutputs(((ExperimentPlan)this.host.getSpecies()).getOriginalSimulationOutputs());
                }
                if (!iScope.interrupted()) {
                    this.setCurrentSimulation(simulationAgent);
                    this.initSimulation(iScope, simulationAgent, list, n2, bl, bl2, remoteSequence);
                    if (bl2) {
                        this.runner.add(simulationAgent);
                    }
                    iList.add(simulationAgent);
                }
                ++n2;
            }
        });
        return iList;
    }

    private void initSimulation(IScope iScope, SimulationAgent simulationAgent, List<? extends Map<String, Object>> list, int n, boolean bl, boolean bl2, RemoteSequence remoteSequence) {
        iScope.getGui().getStatus().waitStatus("Instantiating agents", "status/status.simulation", () -> {
            Object object;
            ParametersSet parametersSet = list.isEmpty() ? ParametersSet.EMPTY : (Map)list.get(n);
            Object object2 = object = !parametersSet.isEmpty() ? parametersSet.values().toArray()[0] : null;
            if (object instanceof ISerialisedAgent) {
                ISerialisedAgent iSerialisedAgent = (ISerialisedAgent)object;
                simulationAgent.updateWith(iScope, iSerialisedAgent);
            } else {
                if (!this.getHost().getSpecies().isBatch()) {
                    simulationAgent.setExternalInits(this.getHost().getParameterValues());
                }
                simulationAgent.setExternalInits(parametersSet);
                this.createVariablesFor(simulationAgent.getScope(), Collections.singletonList(simulationAgent), Collections.singletonList(simulationAgent.getExternalInits()));
            }
            if (bl2) {
                if (bl || object instanceof ISerialisedAgent) {
                    simulationAgent.initOutputs();
                } else {
                    simulationAgent.schedule(iScope);
                    if (remoteSequence != null && !remoteSequence.isEmpty()) {
                        iScope.execute(remoteSequence, simulationAgent, null);
                    }
                }
            }
        });
    }

    @Override
    protected boolean allowVarInitToBeOverridenByExternalInit(IVariable iVariable) {
        return switch (iVariable.getName()) {
            case "rng", "seed" -> {
                if (iVariable.hasFacet("init")) {
                    yield false;
                }
                yield true;
            }
            default -> true;
        };
    }

    @Override
    public ExperimentAgent getHost() {
        return (ExperimentAgent)super.getHost();
    }

    @Override
    public SimulationAgent getAgent(IScope iScope, GamaPoint gamaPoint) {
        return (SimulationAgent)this.get((IScope)null, 0);
    }

    public void setHost(ExperimentAgent experimentAgent) {
        this.host = experimentAgent;
    }

    @Override
    public void computeTopology(IScope iScope) throws GamaRuntimeException {
        this.topology = new AmorphousTopology();
    }

    @Override
    protected boolean stepAgents(IScope iScope) {
        this.runner.step();
        return true;
    }

    public void unscheduleSimulation(SimulationAgent simulationAgent) {
        this.runner.remove(simulationAgent);
    }

    public Set<SimulationAgent> getRunningSimulations() {
        return this.runner.getStepable();
    }

    public int getNumberOfActiveThreads() {
        return this.runner.getActiveThreads();
    }

    public boolean hasScheduledSimulations() {
        return this.runner.hasSimulations();
    }

    public SimulationAgent getCurrentSimulation() {
        return this.currentSimulation;
    }

    public void setCurrentSimulation(SimulationAgent simulationAgent) {
        this.currentSimulation = simulationAgent;
        GAMA.changeCurrentTopLevelAgent((ITopLevelAgent)((Object)(simulationAgent == null ? this.getHost() : simulationAgent)), false);
    }
}

