/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.graph;

import gama.core.runtime.GAMA;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.graph.GamaGraph;
import gama.core.util.matrix.GamaIntMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.GraphWalk;

public class FloydWarshallShortestPathsGAMA<V, E> {
    private final GamaGraph<V, E> graph;
    private final List<V> vertices;
    private int nShortestPaths = 0;
    private double diameter = 0.0;
    private double[][] d = null;
    private int[][] backtrace = null;
    private GamaIntMatrix matrix = null;
    private IMap<Pair<V, V>, GraphPath<V, E>> paths = null;

    public FloydWarshallShortestPathsGAMA(GamaGraph<V, E> gamaGraph) {
        this.graph = gamaGraph;
        this.vertices = new ArrayList<V>(gamaGraph.getVertexMap().keySet());
    }

    public FloydWarshallShortestPathsGAMA(GamaGraph<V, E> gamaGraph, GamaIntMatrix gamaIntMatrix) {
        this.graph = gamaGraph;
        this.vertices = new ArrayList<V>(gamaGraph.getVertexMap().keySet());
        this.paths = GamaMapFactory.createUnordered();
        this.nShortestPaths = 0;
        this.matrix = gamaIntMatrix;
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public int getShortestPathsCount() {
        this.lazyCalculatePaths();
        return this.nShortestPaths;
    }

    public double[][] getD() {
        return this.d;
    }

    public int[][] getBacktrace() {
        return this.backtrace;
    }

    public void lazyCalculateMatrix() {
        this.matrix = null;
        if (this.d != null) {
            return;
        }
        int n = this.vertices.size();
        this.backtrace = new int[n][n];
        int n2 = 0;
        while (n2 < n) {
            Arrays.fill(this.backtrace[n2], -1);
            ++n2;
        }
        this.d = new double[n][n];
        n2 = 0;
        while (n2 < n) {
            Arrays.fill(this.d[n2], Double.POSITIVE_INFINITY);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.d[n2][n2] = 0.0;
            ++n2;
        }
        Set set = this.graph.edgeSet();
        for (Object e : set) {
            Object object = this.graph.getEdgeSource(e);
            Object object2 = this.graph.getEdgeTarget(e);
            int n3 = this.vertices.indexOf(object);
            int n4 = this.vertices.indexOf(object2);
            this.d[n3][n4] = this.graph.getEdgeWeight(e);
            if (this.graph.isDirected()) continue;
            this.d[n4][n3] = this.graph.getEdgeWeight(e);
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = 0;
                while (n7 < n) {
                    double d = this.d[n6][n5] + this.d[n5][n7];
                    if (d < this.d[n6][n7]) {
                        this.d[n6][n7] = d;
                        this.backtrace[n6][n7] = n5;
                        this.diameter = this.diameter > this.d[n6][n7] ? this.diameter : this.d[n6][n7];
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
    }

    public double getDiameter() {
        this.lazyCalculateMatrix();
        return this.diameter;
    }

    public void shortestPathRecur(List<E> list, int n, int n2) {
        int n3 = this.backtrace[n][n2];
        if (n3 == -1) {
            Set set = this.graph.getAllEdges(this.vertices.get(n), this.vertices.get(n2));
            double d = Double.MAX_VALUE;
            Object e = null;
            for (Object e2 : set) {
                double d2 = this.graph.getEdgeWeight(e2);
                if (!(d2 < d)) continue;
                d = d2;
                e = e2;
            }
            if (e != null) {
                list.add(e);
            }
        } else {
            this.shortestPathRecur(list, n, n3);
            this.shortestPathRecur(list, n3, n2);
        }
    }

    public int succRecur(int n, int n2) {
        int n3 = this.backtrace[n][n2];
        if (n3 != -1) {
            return this.succRecur(n, n3);
        }
        if (!this.graph.containsEdge(this.vertices.get(n), this.vertices.get(n2))) {
            return -1;
        }
        return n2;
    }

    public GraphPath<V, E> getShortestPath(V v, V v2) {
        this.lazyCalculatePaths();
        return this.getShortestPathImpl(v, v2);
    }

    private GraphPath<V, E> getShortestPathImpl(V v, V v2) {
        Object object;
        int n = this.vertices.indexOf(v);
        int n2 = this.vertices.indexOf(v2);
        int n3 = n;
        ArrayList arrayList = new ArrayList();
        if (this.matrix != null) {
            n = this.matrix.get(GAMA.getRuntimeScope(), n2, n);
            if (n != -1) {
                while (n3 != n2) {
                    object = this.graph.getAllEdges(this.vertices.get(n3), this.vertices.get(n));
                    if (object.isEmpty()) {
                        return null;
                    }
                    double d = Double.MAX_VALUE;
                    Object e = null;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        double d2 = this.graph.getEdgeWeight(e2);
                        if (!(d2 < d)) continue;
                        d = d2;
                        e = e2;
                    }
                    arrayList.add(e);
                    if (n3 == n2) continue;
                    n3 = n;
                }
            }
        } else {
            this.shortestPathRecur(arrayList, n, n2);
        }
        if (arrayList.size() < 1) {
            return null;
        }
        object = new GraphWalk(this.graph, v, v2, arrayList, (double)arrayList.size());
        if (this.graph.getPathComputer().isSaveComputedShortestPaths()) {
            V v3 = this.vertices.get(n);
            V v4 = this.vertices.get(n2);
            this.paths.put((Pair<Object, Object>)new Pair(v3, v4), (GraphPath<Object, E>)object);
            ++this.nShortestPaths;
        }
        return object;
    }

    private void lazyCalculatePaths() {
        if (this.paths != null || this.matrix != null) {
            return;
        }
        this.lazyCalculateMatrix();
        this.paths = GamaMapFactory.createUnordered();
        this.nShortestPaths = 0;
    }
}

