/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import gama.core.runtime.IScope;
import gama.core.util.GamaMap;
import gama.core.util.GamaMapSimpleWrapper;
import gama.core.util.GamaMapWrapper;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class GamaMapFactory {
    private static final int DEFAULT_SIZE = 10;

    public static <K, V> IMap<K, V> wrap(IType iType, IType iType2, Map<K, V> map) {
        return new GamaMapWrapper<K, V>(map, iType, iType2, true);
    }

    public static <K, V> IMap<K, V> wrap(Map<K, V> map) {
        return new GamaMapWrapper<K, V>(map, Types.NO_TYPE, Types.NO_TYPE, true);
    }

    public static <K, V> IMap<K, V> wrap(IType iType, IType iType2, boolean bl, Map<K, V> map) {
        return new GamaMapWrapper<K, V>(map, iType, iType2, bl);
    }

    public static <K, V> IMap<K, V> synchronizedMap(IMap<K, V> iMap) {
        IType<?> iType = iMap.getGamlType().getKeyType();
        IType<?> iType2 = iMap.getGamlType().getContentType();
        boolean bl = iMap.isOrdered();
        return GamaMapFactory.wrap(iType, iType2, bl, Collections.synchronizedMap(iMap));
    }

    public static <K, V> Map<K, V> synchronizedOrderedMap() {
        IMap iMap = GamaMapFactory.create();
        return Collections.synchronizedMap(iMap);
    }

    public static <K, V> IMap<K, V> concurrentMap() {
        return GamaMapFactory.wrap(Types.NO_TYPE, Types.NO_TYPE, false, new ConcurrentHashMap());
    }

    public static IMap create() {
        return GamaMapFactory.createOrdered();
    }

    public static IMap createOrdered() {
        return new GamaMap(10, Types.NO_TYPE, Types.NO_TYPE);
    }

    public static IMap createUnordered() {
        final HashMap hashMap = new HashMap();
        return new GamaMapSimpleWrapper(){

            @Override
            public boolean isOrdered() {
                return false;
            }

            protected Map delegate() {
                return hashMap;
            }
        };
    }

    public static IMap createSynchronizedUnordered() {
        final Map map = Collections.synchronizedMap(new HashMap());
        return new GamaMapSimpleWrapper(){

            @Override
            public boolean isOrdered() {
                return false;
            }

            protected Map delegate() {
                return map;
            }
        };
    }

    public static IMap create(IType iType, IType iType2) {
        return GamaMapFactory.create(iType, iType2, 10);
    }

    public static IMap create(IType iType, IType iType2, boolean bl) {
        return GamaMapFactory.create(iType, iType2, 10, bl);
    }

    public static IMap create(IType iType, IType iType2, int n) {
        return GamaMapFactory.create(iType, iType2, n, true);
    }

    public static IMap create(IType iType, IType iType2, int n, boolean bl) {
        if (bl) {
            return new GamaMap(n, iType, iType2);
        }
        return new GamaMapWrapper(new HashMap(n), iType, iType2, false);
    }

    public static <K, V> IMap<K, V> createWithoutCasting(IType<K> iType, IType<V> iType2, Map<K, V> map) {
        return GamaMapFactory.createWithoutCasting(iType, iType2, map, true);
    }

    public static <K, V> IMap<K, V> createWithoutCasting(IType<K> iType, IType<V> iType2, Map<K, V> map, boolean bl) {
        IMap iMap = GamaMapFactory.create(iType, iType2, map.size(), bl);
        iMap.putAll(map);
        return iMap;
    }

    public static <K, V> IMap<K, V> create(IScope iScope, IType<K> iType, IType<V> iType2, Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return GamaMapFactory.create(iType, iType2);
        }
        IMap iMap = GamaMapFactory.create(iType, iType2, map.size());
        map.forEach((object, object2) -> iMap.setValueAtIndex(iScope, object, object2));
        return iMap;
    }

    public static <K, V> IMap<K, V> create(IScope iScope, IType<K> iType, IType<V> iType2, Map<K, V> map, boolean bl) {
        if (map == null || map.isEmpty()) {
            return GamaMapFactory.create(iType, iType2, bl);
        }
        IMap iMap = GamaMapFactory.create(iType, iType2, map.size(), bl);
        map.forEach((object, object2) -> iMap.setValueAtIndex(iScope, object, object2));
        return iMap;
    }

    public static <K, V> IMap<K, V> create(IScope iScope, IType<K> iType, IType<V> iType2, IList<K> iList, IList<V> iList2) {
        IMap iMap = GamaMapFactory.create(iType, iType2, iList.length(iScope));
        int n = 0;
        while (n < Math.min(iList.length(iScope), iList2.length(iScope))) {
            iMap.put(iList.get(n), iList2.get(n));
            ++n;
        }
        return iMap;
    }

    public static boolean equals(IMap iMap, IMap iMap2) {
        if (iMap.size() != iMap2.size()) {
            return false;
        }
        return iMap.forEachPair((object, object2) -> Objects.equals(object2, iMap2.get(object)));
    }

    public static class GamaMapSupplier
    implements Supplier<IMap> {
        IType k;
        IType c;

        public GamaMapSupplier(IType iType, IType iType2) {
            this.k = iType;
            this.c = iType2;
        }

        @Override
        public IMap get() {
            return GamaMapFactory.create(this.k, this.c);
        }
    }
}

