/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions;

import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.benchmark.StopWatch;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.gaml.compilation.GAML;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

public abstract class AbstractExpression
implements IExpression {
    protected IType type = null;

    @Override
    public IType<?> getGamlType() {
        return this.type == null ? Types.NO_TYPE : this.type;
    }

    public static void parenthesize(StringBuilder stringBuilder, IExpression ... iExpressionArray) {
        if (iExpressionArray.length == 1 && !iExpressionArray[0].shouldBeParenthesized()) {
            stringBuilder.append(iExpressionArray[0].serializeToGaml(false));
        } else {
            AbstractExpression.surround(stringBuilder, '(', ')', iExpressionArray);
        }
    }

    public static String surround(StringBuilder stringBuilder, char c, char c2, IExpression ... iExpressionArray) {
        stringBuilder.append(c);
        int n = 0;
        while (n < iExpressionArray.length) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(iExpressionArray[n] == null ? "nil" : iExpressionArray[n].serializeToGaml(false));
            ++n;
        }
        n = stringBuilder.length();
        if (n > 2 && stringBuilder.charAt(n - 1) == ' ') {
            stringBuilder.setLength(n - 1);
        }
        stringBuilder.append(c2);
        return stringBuilder.toString();
    }

    @Override
    public String getTitle() {
        return this.serializeToGaml(false);
    }

    @Override
    public final Object value(IScope iScope) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StopWatch stopWatch = GAMA.benchmark(iScope, this);){
                return this._value(iScope);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            GamaExecutorService.EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), outOfMemoryError);
            return null;
        }
    }

    protected IExpression optimized() {
        return GamaPreferences.Experimental.CONSTANT_OPTIMIZATION.getValue() != false && this.isConst() ? GAML.getExpressionFactory().createConst(this.getConstValue(), this.getGamlType(), this.serializeToGaml(false)) : this;
    }

    protected abstract Object _value(IScope var1);
}

