/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaPair;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.graph.IGraph;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.AbstractContainerStatement;
import gama.gaml.statements.AddStatement;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="at", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the key or index at which to put the new value is specified by `container[index]`")}), @GamlAnnotations.facet(name="key", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the key or index at which to put the new value is specified by `container[index]`")}), @GamlAnnotations.facet(name="all", type={0}, optional=true, doc={@GamlAnnotations.doc(value="when no index is specified between the square brackets, the put assignement applies to all elements and changes their value to the one provided")}), @GamlAnnotations.facet(name="item", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the right member of the put assignment ('cont[index] <- expr;') is an expression expr that evaluates to the element(s) to be put in the container")}), @GamlAnnotations.facet(name="in", type={16, 14, 11, 13}, optional=false, doc={@GamlAnnotations.doc(value="the left member of the put assignment ('cont[index] <- expr;') is an expression cont that evaluates to a container (list, map, matrix). It makes no sense for graphs ")})}, omissible="item")
@GamlAnnotations.inside(kinds={3, 11, 6}, symbols={"chart"})
@validator(value=PutValidator.class)
@GamlAnnotations.doc(value="A statement used to put items into containers at specific keys or indices. It can be written using the classic syntax (`put ... in: ...`) or a compact one, which is now preferred.\n- To put an element in a container at a given index, use `container[index] <- element;` (classic form: `put element in: container at: index;`) \n- To put an element in a container at all indices (i.e. replace all values by the element),  use `container[] <- element` (classic form: `put element in: container all: true;`)", usages={@GamlAnnotations.usage(value="The allowed  configurations are the following ones:", examples={@GamlAnnotations.example(value="expr_container[index] <- expr; // put or replace expr at index in the container", isExecutable=false), @GamlAnnotations.example(value="expr_container[] <- expr;  // put expr at every index in the container (replace all values)", isExecutable=false)}), @GamlAnnotations.usage(value="In the case of a list, the position should be an integer in the bounds of the list. The facet all: is used to replace all the elements of the list by the given value.", examples={@GamlAnnotations.example(var="putList", value="[1,2,3,4,5]", returnType="list<int>", equals="[1,2,3,4,5]"), @GamlAnnotations.example(value="putList[1] <- -10;", var="putList", equals="[1,-10,3,4,5]"), @GamlAnnotations.example(value="putList[] <- 10;", var="putList", equals="[10,10,10,10,10]")}), @GamlAnnotations.usage(value="In the case of a matrix, the position should be a point in the bounds of the matrix. If no position is provided, it is used to replace all the elements of the matrix by the given value.", examples={@GamlAnnotations.example(var="putMatrix", value="matrix([[0,1],[2,3]])", returnType="matrix<int>", equals="matrix([[0,1],[2,3]])"), @GamlAnnotations.example(value="putMatrix[{1,1}] <- -10;", var="putMatrix", equals="matrix([[0,1],[2,-10]]);"), @GamlAnnotations.example(value="putMatrix[] <- 10;", var="putMatrix", equals="matrix([[10,10],[10,10]])")}), @GamlAnnotations.usage(value="In the case of a map, the position should be one of the key values of the map. Notice that if the given key value does not exist in the map, a\tnew pair key::value will be added to the map. The facet all is used to replace the value of all the pairs of the map.", examples={@GamlAnnotations.example(var="putMap", value="[\"x\"::4,\"y\"::7]", returnType="map<string,int>", equals="[\"x\"::4,\"y\"::7]"), @GamlAnnotations.example(value="putMap['y'] <- -10;", var="putMap", equals="[\"x\"::4,\"y\"::-10]"), @GamlAnnotations.example(value="putMap['z'] <- -20;", var="putMap", equals="[\"x\"::4,\"y\"::-10, \"z\"::-20]"), @GamlAnnotations.example(value="putMap[] <- -30 ;", var="putMap", equals="[\"x\"::-30,\"y\"::-30, \"z\"::-30]")})})
@serializer(value=PutSerializer.class)
public class PutStatement
extends AddStatement {
    public PutStatement(IDescription iDescription) {
        super(iDescription);
        this.setName("put in " + this.list.serializeToGaml(false));
    }

    @Override
    protected Object buildValue(IScope iScope, IGraph iGraph) {
        return iGraph.buildValue(iScope, this.item.value(iScope));
    }

    @Override
    protected void apply(IScope iScope, Object object, Object object2, IContainer.Modifiable modifiable) throws GamaRuntimeException {
        if (!this.asAll) {
            if (modifiable instanceof IList && object2 instanceof GamaPair) {
                ((IList)modifiable).replaceRange(iScope, (GamaPair)object2, object);
            } else {
                modifiable.setValueAtIndex(iScope, object2, object);
            }
        } else {
            modifiable.setAllValues(iScope, object);
        }
    }

    public static class PutSerializer
    extends SymbolSerializer<SymbolDescription> {
        @Override
        protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            IExpression iExpression = symbolDescription.getFacetExpr("item");
            IExpression iExpression2 = symbolDescription.getFacetExpr("to");
            IExpression iExpression3 = symbolDescription.getFacetExpr("at");
            stringBuilder.append(iExpression2.serializeToGaml(bl));
            stringBuilder.append('[');
            if (iExpression3 != null) {
                stringBuilder.append(iExpression3.serializeToGaml(bl));
            }
            stringBuilder.append(']');
            stringBuilder.append(" <- ");
            stringBuilder.append(iExpression.serializeToGaml(bl)).append(';');
        }
    }

    public static class PutValidator
    extends AbstractContainerStatement.ContainerValidator {
        @Override
        public void validate(IDescription iDescription) {
            boolean bl;
            IExpression iExpression = iDescription.getFacetExpr("at", "key");
            IExpression iExpression2 = iDescription.getFacetExpr("all");
            if (iExpression2 != null && iExpression2.getGamlType().id() != 3) {
                iDescription.error("Put cannot be used to add several values", "gaml.conflicting.facets", "all", new String[0]);
                return;
            }
            boolean bl2 = iExpression2 == null ? false : (bl = !"false".equals(iExpression2.literalValue()));
            if (!bl && iExpression == null) {
                iDescription.error("Put needs a valid index (facets 'at:' or 'key:') ", "gaml.missing.facet.issue", iDescription.getUnderlyingElement(), "at", "0");
            } else {
                super.validate(iDescription);
            }
        }
    }
}

