/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.BufferingController;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="The color with wich the message will be displayed. Note that different simulations will have different (default) colors to use for this purpose if this facet is not specified")}), @GamlAnnotations.facet(name="end", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The string to be appened at the end of the message. By default it's a new line character: '\\n' or '\\r\\n' depending on the operating system.")}), @GamlAnnotations.facet(name="buffering", type={4}, optional=true, doc={@GamlAnnotations.doc(value="Allows to specify a buffering strategy to write in the console. Accepted values are `per_cycle` and `per_simulation`, `no_buffering`. In the case of `per_cycle` or `per_simulation`, all the write operations in the simulation which used these values would be executed all at once at the end of the cycle or simulation while keeping the initial order. In case of 'per_agent' all operations will be released when the agent is killed (or the simulation ends). Those strategies can be used to optimise a simulation's execution time on models that extensively write in files. The `no_buffering` (which is the system's default) will directly write into the file.")}), @GamlAnnotations.facet(name="message", type={0}, optional=false, doc={@GamlAnnotations.doc(value="the message to display. Modelers can add some formatting characters to the message (carriage returns, tabs, or Unicode characters), which will be used accordingly in the console.")})}, omissible="message")
@GamlAnnotations.doc(value="The statement makes the agent output an arbitrary message in the console.", usages={@GamlAnnotations.usage(value="Outputting a message", examples={@GamlAnnotations.example(value="write \"This is a message from \" + self;")})})
@validator(value=WriteValidator.class)
public class WriteStatement
extends AbstractStatement {
    final IExpression message = this.getFacet("message");
    final IExpression color = this.getFacet("color");
    final IExpression bufferingStrategy = this.getFacet("buffering");
    final IExpression end = this.getFacet("end");

    @Override
    public String getTrace(IScope iScope) {
        return "";
    }

    public WriteStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        String string = null;
        if (iAgent != null && !iAgent.dead()) {
            string = Cast.asString(iScope, this.message.value(iScope));
            if (string == null) {
                string = "nil";
            }
            GamaColor gamaColor = null;
            if (this.color != null) {
                gamaColor = (GamaColor)this.color.value(iScope);
            }
            BufferingController.BufferingStrategies bufferingStrategies = BufferingController.stringToBufferingStrategies(iScope, (String)GamaPreferences.get("pref_write_buffering_strategy").value(iScope));
            if (this.bufferingStrategy != null) {
                bufferingStrategies = BufferingController.stringToBufferingStrategies(iScope, Cast.asString(iScope, this.bufferingStrategy.value(iScope)));
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            if (this.end != null) {
                stringBuilder.append(Cast.asString(iScope, this.end));
            } else {
                stringBuilder.append(Strings.LN);
            }
            GAMA.getBufferingController().askWriteConsole(iScope, stringBuilder, gamaColor, bufferingStrategies);
        }
        return string;
    }

    @GamlAnnotations.operator(value={"sample"}, doc={@GamlAnnotations.doc(value="Returns a string containing the GAML code of the expression passed in parameter, followed by the result of its evaluation")}, category={"Strings-related operators"})
    @GamlAnnotations.test(value="sample('a' in ['a', 'b']) = \"'a' in (['a','b']) -: true\"")
    public static String sample(IScope iScope, IExpression iExpression) {
        return WriteStatement.sample(iScope, iExpression == null ? "nil" : iExpression.serializeToGaml(false), iExpression);
    }

    @GamlAnnotations.operator(value={"sample"}, doc={@GamlAnnotations.doc(value="Returns a string containing the string passed in parameter, followed by the result of the evaluation of the expression")}, category={"Strings-related operators"})
    @GamlAnnotations.test(value="sample(\"result: \",'a' in ['a', 'b']) = \"result: -: true\"")
    public static String sample(IScope iScope, String string, IExpression iExpression) {
        return string == null ? "" : string.trim() + " -: " + (iExpression == null ? "nil" : StringUtils.toGaml(iExpression.value(iScope), false));
    }

    public static class WriteValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            StatementDescription statementDescription2 = statementDescription;
            IExpression iExpression = statementDescription2.getFacetExpr("buffering");
            if (iExpression != null && !BufferingController.BUFFERING_STRATEGIES.contains(iExpression.literalValue())) {
                statementDescription2.error("The value for buffering must be 'no_buffering', 'per_cycle', 'per_agent'' or 'per_simulation'.", "gaml.wrong.type.issue");
            }
        }
    }
}

