/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.root;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.core.common.util.RandomUtils;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.root.SystemInfo;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.population.GamaPopulation;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.continuous.AmorphousTopology;
import gama.core.outputs.IOutputManager;
import gama.core.runtime.ExecutionScope;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.MemoryUtils;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.MessageType;
import gama.core.util.GamaColor;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.dev.DEBUG;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.expressions.IExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.operators.Containers;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.java_websocket.WebSocket;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@GamlAnnotations.species(name="platform", internal=true, doc={@GamlAnnotations.doc(value="The species of the unique platform agent, called 'gama'")})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="machine_time", type=2, doc={@GamlAnnotations.doc(value="Returns the current system time in milliseconds (i.e. number of milliseconds since UNIX epoch day)", comment="The return value is a float number")}), @GamlAnnotations.variable(name="workspace_path", type=4, constant=true, doc={@GamlAnnotations.doc(value="Contains the absolute path to the workspace of GAMA. Can be used to list all the projects and files present in the platform", comment="Always terminated with a trailing separator", see={"workspace"})}), @GamlAnnotations.variable(name="info", type=4, constant=true, doc={@GamlAnnotations.doc(value="Returns information about GAMA, in a format suitable to be pasted into GitHub issues")}), @GamlAnnotations.variable(name="platform", type=4, constant=true, doc={@GamlAnnotations.doc(value="Returns the platform on which GAMA is currently executing.")}), @GamlAnnotations.variable(name="version", type=4, constant=true, doc={@GamlAnnotations.doc(value="Returns the version of the current GAMA installation")}), @GamlAnnotations.variable(name="plugins", type=5, of=4, constant=true, doc={@GamlAnnotations.doc(value="Lists all the plugins present in this installation of GAMA")}), @GamlAnnotations.variable(name="free_memory", type=2, constant=false, doc={@GamlAnnotations.doc(value="A float number that represents the free memory available to GAMA in bytes")}), @GamlAnnotations.variable(name="max_memory", type=2, constant=false, doc={@GamlAnnotations.doc(value="A float number that represents the maximum amount of memory available to GAMA in bytes")}), @GamlAnnotations.variable(name="workspace", type=12, constant=true, doc={@GamlAnnotations.doc(value="A folder representing the workspace of GAMA. Can be used to list all the projects and files present in the platform", see={"workspace_path"})})})
public class PlatformAgent
extends GamlAgent
implements ITopLevelAgent,
IExpression {
    public static final String WORKSPACE_PATH = "workspace_path";
    public static final String MACHINE_TIME = "machine_time";
    private final Timer polling = new Timer();
    Map<String, Object> prefsToRestore = GamaMapFactory.create();
    final IScope basicScope;
    private TimerTask currentTask;
    private final Json jsonEncoder = Json.getNew();

    public PlatformAgent() {
        this((IPopulation<PlatformAgent>)new GamaPopulation<PlatformAgent>(null, GamaMetaModel.INSTANCE.getAbstractModelSpecies().getMicroSpecies("platform")), 0);
    }

    public PlatformAgent(IPopulation<PlatformAgent> iPopulation, int n2) {
        super(iPopulation, n2);
        this.basicScope = new ExecutionScope(this, "Gama platform scope");
        if (GamaPreferences.Runtime.CORE_MEMORY_POLLING.getValue().booleanValue()) {
            this.startPollingMemory();
        }
        GamaPreferences.Runtime.CORE_MEMORY_POLLING.onChange(bl -> {
            if (bl.booleanValue()) {
                this.startPollingMemory();
            } else {
                this.stopPollingMemory();
            }
        });
        GamaPreferences.Runtime.CORE_MEMORY_FREQUENCY.onChange(n -> {
            this.stopPollingMemory();
            this.startPollingMemory();
        });
    }

    private void startPollingMemory() {
        if (this.currentTask == null) {
            this.currentTask = new TimerTask(){

                @Override
                public void run() {
                    IExperimentAgent iExperimentAgent;
                    if (MemoryUtils.memoryIsLow() && (iExperimentAgent = PlatformAgent.this.getExperiment()) != null) {
                        long l = (long)((double)MemoryUtils.availableMemory() / 1000000.0);
                        GamaRuntimeException gamaRuntimeException = GamaRuntimeException.warning("Memory is low (" + l + " megabytes). You should close the experiment, exit GAMA and give it more memory", iExperimentAgent.getScope());
                        GAMA.reportError(PlatformAgent.this.basicScope, gamaRuntimeException, false);
                    }
                }
            };
        }
        this.polling.scheduleAtFixedRate(this.currentTask, 0L, 1000L * (long)GamaPreferences.Runtime.CORE_MEMORY_FREQUENCY.getValue().intValue());
    }

    private void stopPollingMemory() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
    }

    @Override
    public Object primDie(IScope iScope) {
        this.stopPollingMemory();
        this.polling.cancel();
        GAMA.closeAllExperiments(false, true);
        iScope.getGui().exit();
        return null;
    }

    @Override
    public boolean isContextIndependant() {
        return false;
    }

    @Override
    public ITopology getTopology() {
        return new AmorphousTopology();
    }

    @Override
    public String getName() {
        return "gama";
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "gama";
    }

    @Override
    public ISpecies getSpecies() {
        return this.getPopulation().getSpecies();
    }

    @Override
    public SimulationClock getClock() {
        return new SimulationClock(this.getScope());
    }

    @Override
    public IScope getScope() {
        return this.basicScope;
    }

    @Override
    public GamaColor getColor() {
        return GamaColor.get(102, 114, 126);
    }

    @Override
    public RandomUtils getRandomGenerator() {
        return new RandomUtils();
    }

    @Override
    public IOutputManager getOutputManager() {
        if (this.getExperiment() != null) {
            return this.getExperiment().getOutputManager();
        }
        return null;
    }

    @Override
    public void postEndAction(IExecutable iExecutable) {
    }

    @Override
    public void postDisposeAction(IExecutable iExecutable) {
    }

    @Override
    public void postOneShotAction(IExecutable iExecutable) {
    }

    @Override
    public void executeAction(IExecutable iExecutable) {
    }

    @Override
    public boolean isOnUserHold() {
        return false;
    }

    @Override
    public void setOnUserHold(boolean bl) {
    }

    @Override
    public SimulationAgent getSimulation() {
        return GAMA.getSimulation();
    }

    @Override
    public IExperimentAgent getExperiment() {
        if (GAMA.getExperiment() != null) {
            return GAMA.getExperiment().getAgent();
        }
        return null;
    }

    @GamlAnnotations.getter(value="workspace_path", initializer=true)
    public String getWorkspacePath() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    @GamlAnnotations.getter(value="plugins", initializer=true)
    public IList<String> getPluginsList() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        return (IList)StreamEx.of((Object[])bundleContext.getBundles()).map(Bundle::getSymbolicName).toCollection((Supplier)Containers.listOf(Types.STRING));
    }

    @GamlAnnotations.getter(value="info", initializer=true)
    public String getInfo() {
        return SystemInfo.getSystemInfo();
    }

    @GamlAnnotations.getter(value="platform", initializer=true)
    public String getPlatform() {
        return Platform.getOS();
    }

    @GamlAnnotations.getter(value="version", initializer=true)
    public String getVersion() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        return bundleContext.getBundle().getVersion().toString();
    }

    @GamlAnnotations.getter(value="free_memory", initializer=true)
    public double getAvailableMemory() {
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return Runtime.getRuntime().maxMemory() - l;
    }

    @GamlAnnotations.getter(value="max_memory", initializer=true)
    public double getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @GamlAnnotations.getter(value="machine_time")
    public Double getMachineTime() {
        return System.currentTimeMillis();
    }

    @Override
    public String getTitle() {
        return "gama platform agent";
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return new IGamlDescription.ConstantDoc("The unique instance of the platform species. Used to access GAMA platform properties.");
    }

    @Override
    public String getDefiningPlugin() {
        return "gama.core";
    }

    @Override
    public Object value(IScope iScope) throws GamaRuntimeException {
        return this;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public String literalValue() {
        return "gama";
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        return this;
    }

    @Override
    public boolean shouldBeParenthesized() {
        return false;
    }

    @Override
    public IType<?> getGamlType() {
        return Types.get("platform");
    }

    public void savePrefToRestore(String string, Object object) {
        this.prefsToRestore.putIfAbsent(string, object);
    }

    public void restorePrefs() {
        this.prefsToRestore.forEach((string, object) -> {
            Pref<?> pref = GamaPreferences.get(string);
            if (pref != null) {
                pref.setValue(this.basicScope, object);
            }
        });
    }

    @Override
    public String getFamilyName() {
        return "platform";
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @GamlAnnotations.action(name="send", args={@GamlAnnotations.arg(name="message", optional=false, doc={@GamlAnnotations.doc(value="The message to send")})})
    public Object sendMessageThroughServer(IScope iScope) {
        Object object = iScope.getArg("message", 0);
        this.sendMessage(iScope, object);
        return object;
    }

    public void sendMessage(IScope iScope, Object object) {
        this.sendMessage(iScope, object, MessageType.SimulationOutput);
    }

    public void sendMessage(IScope iScope, Object object, MessageType messageType) {
        try {
            WebSocket webSocket = iScope.getServerConfiguration().socket();
            if (webSocket == null && GAMA.getServer() != null) {
                webSocket = GAMA.getServer().obtainGuiServerConfiguration().socket();
            }
            if (webSocket == null) {
                DEBUG.OUT((Object)("No socket found, maybe the client is already disconnected. Unable to send message: " + String.valueOf(object)));
                return;
            }
            webSocket.send(this.jsonEncoder.valueOf(new GamaServerMessage(messageType, object, iScope.getServerConfiguration().expId())).toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DEBUG.OUT((Object)("Unable to send message:" + String.valueOf(object)));
            DEBUG.OUT((Object)exception.toString());
        }
    }
}

