/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import com.google.common.collect.ForwardingMap;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.GamaPairList;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;

public abstract class GamaMapSimpleWrapper<K, V>
extends ForwardingMap<K, V>
implements IMap<K, V> {
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IMap)) {
            return false;
        }
        return GamaMapFactory.equals(this, (IMap)object);
    }

    @Override
    public IContainerType<?> getGamlType() {
        return Types.MAP;
    }

    @Override
    public V buildValue(IScope iScope, Object object) {
        return (V)object;
    }

    @Override
    public K buildIndex(IScope iScope, Object object) {
        return (K)object;
    }

    @Override
    public IList<K> getKeys() {
        return GamaListFactory.wrap(Types.NO_TYPE, this.keySet());
    }

    @Override
    public IList<V> getValues() {
        return GamaListFactory.wrap(Types.NO_TYPE, this.values());
    }

    @Override
    public IMap.IPairList getPairs() {
        GamaPairList gamaPairList = new GamaPairList(this);
        this.forEach((object, object2) -> {
            boolean bl = gamaPairList.add(new GamaPair<Object, Object>(object, object2, Types.NO_TYPE, Types.NO_TYPE));
        });
        return gamaPairList;
    }

    @Override
    public IList<V> listValue(IScope iScope, IType iType, boolean bl) {
        if (!bl) {
            return GamaListFactory.wrap(iType, this.values());
        }
        return GamaListFactory.create(iScope, iType, this.values());
    }

    @Override
    public IMap mapValue(IScope iScope, IType iType, IType iType2, boolean bl) {
        IMap iMap = GamaMapFactory.create(iType, iType2, this.size());
        for (Map.Entry entry : this.entrySet()) {
            iMap.put(iMap.buildIndex(iScope, entry.getKey()), iMap.buildValue(iScope, entry.getValue()));
        }
        return iMap;
    }

    @Override
    public IMap reverse(IScope iScope) {
        IMap iMap = this.isOrdered() ? GamaMapFactory.createOrdered() : GamaMapFactory.createUnordered();
        for (Map.Entry entry : this.entrySet()) {
            iMap.put(entry.getValue(), entry.getKey());
        }
        return iMap;
    }
}

