/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.core.common.util.FileUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.IModifiableContainer;
import gama.core.util.file.IGamaFile;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.matrix.IMatrix;
import gama.dependencies.webb.Webb;
import gama.dependencies.webb.WebbException;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.Facets;
import gama.gaml.types.IType;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import one.util.streamex.StreamEx;
import org.eclipse.emf.common.util.URI;

public abstract class GamaFile<Container extends IAddressableContainer & IModifiableContainer, Contents>
implements IGamaFile<Container, Contents> {
    private File file;
    protected final String localPath;
    protected final String originalPath;
    protected final URL url;
    protected boolean writable = false;
    private Container buffer;

    public GamaFile(IScope iScope, String string) throws GamaRuntimeException {
        this(iScope, string, true);
    }

    protected GamaFile(IScope iScope, String string, boolean bl) throws GamaRuntimeException {
        if (bl) {
            bl = iScope != null && iScope.getData("key_temporary_output") == null;
        }
        String string2 = this.originalPath = string;
        if (this.originalPath == null) {
            throw GamaRuntimeException.error("Attempt to " + (bl ? "read" : "write") + " a null file", iScope);
        }
        this.url = this.originalPath.startsWith("http") ? this.buildURL(iScope, this.originalPath) : null;
        if (this.url != null) {
            if (bl) {
                string2 = FileUtils.constructAbsoluteFilePath(iScope, this.fetchFromURL(iScope), bl);
                if (string2 == null) {
                    string2 = "";
                }
            } else {
                string2 = FileUtils.constructAbsoluteTempFilePath(iScope, this.url);
            }
        } else {
            string2 = FileUtils.constructAbsoluteFilePath(iScope, this.originalPath, bl);
        }
        this.localPath = string2;
        this.checkValidity(iScope);
    }

    public boolean isRemote() {
        return this.url != null;
    }

    public GamaFile(IScope iScope, String string, Container Container) {
        this(iScope, string, false);
        this.setWritable(iScope, true);
        this.setContents((boolean)Container);
    }

    @Override
    public String getOriginalPath() {
        return this.originalPath;
    }

    protected boolean automaticallyFetchFromURL() {
        return true;
    }

    protected String fetchFromURL(IScope iScope) {
        if (!this.automaticallyFetchFromURL()) {
            return null;
        }
        return FileUtils.fetchToTempFile(iScope, this.url);
    }

    protected void sendToURL(IScope iScope) throws GamaRuntimeException {
        String string = this.url.toExternalForm();
        String string2 = "Uploading file to " + string;
        iScope.getGui().getStatus().beginTask(string2, "status/status.download");
        Webb webb = Webb.create();
        try {
            try {
                webb.post(string).ensureSuccess().connectTimeout(20000).retry(1, false).header("Content-Type", (Object)this.getHttpContentType()).body((Object)this.getFile(iScope)).asVoid();
            }
            catch (WebbException webbException) {
                throw GamaRuntimeException.create(webbException, iScope);
            }
        }
        finally {
            iScope.getGui().getStatus().endTask(string2, "status/status.download");
        }
    }

    protected String getHttpContentType() {
        return "text/plain";
    }

    protected URL buildURL(IScope iScope, String string) throws GamaRuntimeException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw GamaRuntimeException.error("Malformed URL " + string, iScope);
        }
    }

    protected void checkValidity(IScope iScope) throws GamaRuntimeException {
        if (this.getFile(iScope).exists() && this.getFile(iScope).isDirectory()) {
            throw GamaRuntimeException.error(this.getFile(iScope).getAbsolutePath() + " is a folder. Files can not overwrite folders", iScope);
        }
    }

    @Override
    public void setWritable(IScope iScope, boolean bl) {
        this.writable = bl;
    }

    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        throw GamaRuntimeException.error("Loading is not yet impletemented for files of type " + this.getExtension(iScope) + ". Please post a request for enhancement to implement " + this.getClass().getSimpleName() + ".fillBuffer(IScope, Facets)", iScope);
    }

    protected void flushBuffer(IScope iScope, Facets facets2) throws GamaRuntimeException {
        throw new FlushBufferException(iScope, "Saving is not yet impletemented for files of type " + this.getExtension(iScope) + ". Please post a request for enhancement to implement " + this.getClass().getSimpleName() + ".flushBuffer(IScope, Facets)", false);
    }

    @Override
    public final void setContents(Container Container) throws GamaRuntimeException {
        if (this.writable) {
            this.setBuffer(Container);
        }
    }

    protected String _stringValue(IScope iScope) throws GamaRuntimeException {
        return this.getPath(iScope);
    }

    @Override
    public void addValue(IScope iScope, Object object) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).addValue(iScope, object);
    }

    @Override
    public void addValueAtIndex(IScope iScope, Object object, Object object2) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).addValueAtIndex(iScope, object, object2);
    }

    @Override
    public void setValueAtIndex(IScope iScope, Object object, Object object2) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).setValueAtIndex(iScope, object, object2);
    }

    @Override
    public void addValues(IScope iScope, Object object, IContainer iContainer) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).addValues(iScope, object, iContainer);
    }

    @Override
    public void setAllValues(IScope iScope, Object object) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).setAllValues(iScope, object);
    }

    @Override
    public void removeValue(IScope iScope, Object object) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).removeValue(iScope, object);
    }

    @Override
    public void removeIndex(IScope iScope, Object object) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).removeIndex(iScope, object);
    }

    @Override
    public void removeValues(IScope iScope, IContainer iContainer) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).removeValues(iScope, iContainer);
    }

    @Override
    public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).removeAllOccurrencesOfValue(iScope, object);
    }

    @Override
    public void removeIndexes(IScope iScope, IContainer iContainer) {
        this.fillBuffer(iScope);
        ((IModifiableContainer)this.getBuffer()).removeIndexes(iScope, iContainer);
    }

    @Override
    public boolean contains(IScope iScope, Object object) throws GamaRuntimeException {
        this.getContents(iScope);
        return this.getBuffer().contains(iScope, object);
    }

    @Override
    public IGamaFile copy(IScope iScope) {
        return this;
    }

    @Override
    public Boolean exists(IScope iScope) {
        return this.getFile(iScope).exists();
    }

    @Override
    public Contents firstValue(IScope iScope) throws GamaRuntimeException {
        this.getContents(iScope);
        return (Contents)this.getBuffer().firstValue(iScope);
    }

    @Override
    public Contents get(IScope iScope, Object object) throws GamaRuntimeException {
        this.getContents(iScope);
        return (Contents)this.getBuffer().get(iScope, (Object)object);
    }

    @Override
    public Contents getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        this.getContents(iScope);
        return (Contents)this.getBuffer().getFromIndicesList(iScope, iList);
    }

    @Override
    public String getExtension(IScope iScope) {
        String string = this.getOriginalPath().toLowerCase();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    @Override
    public String getName(IScope iScope) {
        return this.getFile(iScope).getName();
    }

    @Override
    public String getPath(IScope iScope) {
        return this.localPath;
    }

    @Override
    public Container getContents(IScope iScope) throws GamaRuntimeException {
        if (this.buffer == null && !this.exists(iScope).booleanValue()) {
            throw GamaRuntimeException.error("File " + this.getFile(iScope).getAbsolutePath() + " does not exist", iScope);
        }
        this.fillBuffer(iScope);
        return this.getBuffer();
    }

    @Override
    public boolean isEmpty(IScope iScope) {
        this.getContents(iScope);
        return this.getBuffer().isEmpty(iScope);
    }

    @Override
    public Boolean isFolder(IScope iScope) {
        return this.getFile(iScope).isDirectory();
    }

    @Override
    public Boolean isReadable(IScope iScope) {
        return this.getFile(iScope).canRead();
    }

    @Override
    public Boolean isWritable(IScope iScope) {
        return this.getFile(iScope).canWrite();
    }

    @Override
    public Iterable<? extends Contents> iterable(IScope iScope) {
        return this.getContents(iScope).iterable(iScope);
    }

    @Override
    public Contents lastValue(IScope iScope) throws GamaRuntimeException {
        this.getContents(iScope);
        return (Contents)this.getBuffer().lastValue(iScope);
    }

    @Override
    public int length(IScope iScope) {
        this.getContents(iScope);
        return this.getBuffer().length(iScope);
    }

    @Override
    public IList<Contents> listValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        this.getContents(iScope);
        return this.getBuffer().listValue(iScope, iType, bl);
    }

    @Override
    public StreamEx<Contents> stream(IScope iScope) {
        this.getContents(iScope);
        return this.getBuffer().stream(iScope);
    }

    @Override
    public IMap<?, ?> mapValue(IScope iScope, IType iType, IType iType2, boolean bl) throws GamaRuntimeException {
        this.getContents(iScope);
        return this.getBuffer().mapValue(iScope, iType, iType2, bl);
    }

    @Override
    public IMatrix<?> matrixValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        return this.matrixValue(iScope, iType, (GamaPoint)null, bl);
    }

    @Override
    public IMatrix<?> matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        return this._matrixValue(iScope, iType, gamaPoint, bl);
    }

    protected IMatrix _matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        this.getContents(iScope);
        return this.getBuffer().matrixValue(iScope, iType, gamaPoint, bl);
    }

    @Override
    public IContainer<?, ?> reverse(IScope iScope) throws GamaRuntimeException {
        this.getContents(iScope);
        return this.getBuffer().reverse(iScope);
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this._stringValue(iScope);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "file('" + this.getPath(GAMA.getRuntimeScope()) + "')";
    }

    @Override
    public Contents anyValue(IScope iScope) {
        this.getContents(iScope);
        return (Contents)this.getBuffer().anyValue(iScope);
    }

    public File getFile(IScope iScope) {
        if (this.file == null) {
            this.file = new File(this.getPath(iScope));
        }
        return this.file;
    }

    @Override
    public Container getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(Container Container) {
        this.buffer = Container;
    }

    public void invalidateContents() {
        this.buffer = null;
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    @Override
    public final void save(IScope iScope, Facets facets2) {
        boolean bl;
        IExpression iExpression = facets2.getExpr("rewrite");
        boolean bl2 = bl = iExpression == null || Cast.asBool(iScope, iExpression.value(iScope)) != false;
        if (bl && this.getFile(iScope).exists()) {
            this.getFile(iScope).delete();
        }
        if (!this.writable) {
            throw GamaRuntimeException.error("File " + this.getName(iScope) + " is not writable", iScope);
        }
        this.flushBuffer(iScope, facets2);
        if (this.isRemote()) {
            this.sendToURL(iScope);
        }
    }

    @Override
    public URI getURIRelativeToWorkspace() {
        return FileUtils.getURI(this.localPath, null);
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "path", this.originalPath);
    }

    public static class FlushBufferException
    extends GamaRuntimeException {
        protected FlushBufferException(IScope iScope, String string, boolean bl) {
            super(iScope, string, bl);
        }
    }
}

