/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.runtime.IScope;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.file.json.HashIndexTable;
import gama.core.util.file.json.IJsonConstants;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonObjectMember;
import gama.core.util.file.json.JsonValue;
import gama.core.util.file.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class JsonAbstractObject
extends JsonValue
implements Iterable<JsonObjectMember>,
IJsonConstants {
    protected final List<String> names;
    protected final List<JsonValue> values;
    private transient HashIndexTable table;
    protected final Json json;

    JsonAbstractObject(Json json) {
        this.json = json;
        this.names = new ArrayList<String>();
        this.values = new ArrayList<JsonValue>();
        this.table = new HashIndexTable();
    }

    public JsonAbstractObject add(String string, Object object) {
        this.add(string, this.json.valueOf(object));
        return this;
    }

    public JsonAbstractObject add(String string, int n) {
        this.add(string, this.json.valueOf(n));
        return this;
    }

    public JsonAbstractObject add(String string, long l) {
        this.add(string, this.json.valueOf(l));
        return this;
    }

    public JsonAbstractObject add(String string, float f) {
        this.add(string, this.json.valueOf(f));
        return this;
    }

    public JsonAbstractObject add(String string, double d) {
        this.add(string, this.json.valueOf(d));
        return this;
    }

    public JsonAbstractObject add(String string, boolean bl) {
        this.add(string, this.json.valueOf(bl));
        return this;
    }

    public JsonAbstractObject add(String string, String string2) {
        this.add(string, this.json.valueOf(string2));
        return this;
    }

    public JsonAbstractObject add(String string, JsonValue jsonValue) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        if (jsonValue == null) {
            throw new NullPointerException("value is null");
        }
        this.table.add(string, this.names.size());
        this.names.add(string);
        this.values.add(jsonValue);
        return this;
    }

    public JsonAbstractObject set(String string, JsonValue jsonValue) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        if (jsonValue == null) {
            throw new NullPointerException("value is null");
        }
        int n = this.indexOf(string);
        if (n != -1) {
            this.values.set(n, jsonValue);
        } else {
            this.table.add(string, this.names.size());
            this.names.add(string);
            this.values.add(jsonValue);
        }
        return this;
    }

    public JsonValue remove(String string) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        int n = this.indexOf(string);
        JsonValue jsonValue = null;
        if (n != -1) {
            this.table.remove(n);
            this.names.remove(n);
            jsonValue = this.values.remove(n);
        }
        return jsonValue;
    }

    public boolean contains(String string) {
        return this.names.contains(string);
    }

    public JsonValue get(String string) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        int n = this.indexOf(string);
        return n != -1 ? this.values.get(n) : null;
    }

    public int getInt(String string, int n) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asInt() : n;
    }

    public long getLong(String string, long l) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asLong() : l;
    }

    public float getFloat(String string, float f) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asFloat() : f;
    }

    public double getDouble(String string, double d) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asDouble() : d;
    }

    public boolean getBoolean(String string, boolean bl) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asBoolean() : bl;
    }

    public String getString(String string, String string2) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asString() : string2;
    }

    public int size() {
        return this.names.size();
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public List<String> names() {
        return Collections.unmodifiableList(this.names);
    }

    @Override
    public Iterator<JsonObjectMember> iterator() {
        final Iterator<String> iterator = this.names.iterator();
        final Iterator<JsonValue> iterator2 = this.values.iterator();
        return new Iterator<JsonObjectMember>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public JsonObjectMember next() {
                String string = (String)iterator.next();
                JsonValue jsonValue = (JsonValue)iterator2.next();
                return new JsonObjectMember(string, jsonValue);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    final void write(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeObjectOpen();
        this.writeMembers(jsonWriter);
        jsonWriter.writeObjectClose();
    }

    protected void writeMembers(JsonWriter jsonWriter) throws IOException {
        Iterator<String> iterator = this.names.iterator();
        Iterator<JsonValue> iterator2 = this.values.iterator();
        if (iterator.hasNext()) {
            jsonWriter.writeMemberName(iterator.next());
            jsonWriter.writeMemberSeparator();
            iterator2.next().write(jsonWriter);
            while (iterator.hasNext()) {
                jsonWriter.writeObjectSeparator();
                jsonWriter.writeMemberName(iterator.next());
                jsonWriter.writeMemberSeparator();
                iterator2.next().write(jsonWriter);
            }
        }
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + this.names.hashCode();
        n = 31 * n + this.values.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JsonAbstractObject jsonAbstractObject = (JsonAbstractObject)object;
        return this.names.equals(jsonAbstractObject.names) && this.values.equals(jsonAbstractObject.values);
    }

    int indexOf(String string) {
        int n = this.table.get(string);
        if (n != -1 && string.equals(this.names.get(n))) {
            return n;
        }
        return this.names.lastIndexOf(string);
    }

    @Override
    public abstract Object toGamlValue(IScope var1);

    protected IMap<String, Object> toMap(IScope iScope) {
        IMap iMap = GamaMapFactory.create();
        Iterator<String> iterator = this.names.iterator();
        Iterator<JsonValue> iterator2 = this.values.iterator();
        while (iterator.hasNext()) {
            iMap.put(iterator.next(), iterator2.next().toGamlValue(iScope));
        }
        return iMap;
    }
}

