/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.ImmutableSet;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaMapFactory;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.GamaHelper;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.IGamaHelper;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.statements.Facets;
import gama.gaml.types.GamaIntegerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class VariableDescription
extends SymbolDescription {
    private static Map<String, Collection<String>> dependencies = GamaMapFactory.create();
    public static final Set<String> INIT_DEPENDENCIES_FACETS = ImmutableSet.builder().add((Object[])new String[]{"init", "min", "max", "step", "size", "among"}).build();
    public static final Set<String> UPDATE_DEPENDENCIES_FACETS = ImmutableSet.builder().add((Object[])new String[]{"update", "value", "min", "max"}).build();
    public static final Set<String> FUNCTION_DEPENDENCIES_FACETS = ImmutableSet.builder().add((Object)"function").build();
    public static final Map<String, String> PREF_DEFINITIONS = new HashMap<String, String>();
    private String plugin;
    private Class<?> definitionClass;
    private IGamaHelper<?> get;
    private IGamaHelper<?> init;
    private IGamaHelper<?> set;

    public VariableDescription(String string, IDescription iDescription, EObject eObject, Facets facets2) {
        super(string, iDescription, eObject, facets2);
        if (facets2 != null) {
            this.setIf(IDescription.Flag.isContextualType, this.computesContextualType());
            if (!this.hasFacet("type") && !this.isExperimentParameter()) {
                facets2.putAsLabel("type", string);
            }
            this.setIf(IDescription.Flag.isFunction, this.hasFacet("function"));
            this.setIf(IDescription.Flag.IsParameter, this.isExperimentParameter() || this.hasFacet("parameter") && !facets2.equals("parameter", "false"));
            this.setIf(IDescription.Flag.Global, iDescription instanceof ModelDescription);
            this.setIf(IDescription.Flag.Unmodifiable, (facets2.containsKey("function") || facets2.equals("const", "true")) && !this.isParameter());
            this.setIf(IDescription.Flag.Updatable, !this.isSet(IDescription.Flag.Unmodifiable) && (this.hasFacet("value") || this.hasFacet("update")));
            if (this.isBuiltIn() && this.hasFacet("depends_on")) {
                IExpressionDescription iExpressionDescription = this.getFacet("depends_on");
                Collection<String> collection = iExpressionDescription.getStrings(this, false);
                dependencies.put(this.getName(), collection);
                this.removeFacets("depends_on");
            }
        }
    }

    public boolean isExperimentParameter() {
        return "parameter".equals(this.keyword);
    }

    public void setSyntheticSpeciesContainer() {
        this.set(IDescription.Flag.Synthetic);
    }

    public boolean isSyntheticSpeciesContainer() {
        return this.isSet(IDescription.Flag.Synthetic);
    }

    public boolean isFunction() {
        return this.isSet(IDescription.Flag.isFunction);
    }

    public boolean isDefinedInExperiment() {
        return this.getEnclosingDescription() instanceof ExperimentDescription;
    }

    @Override
    public void dispose() {
        if (this.isBuiltIn()) {
            return;
        }
        super.dispose();
    }

    public void copyFrom(VariableDescription variableDescription) {
        boolean bl = this.hasFacet("function");
        variableDescription.visitFacets((string, iExpressionDescription) -> {
            if (bl && ("init".equals(string) || "update".equals(string) || "value".equals(string))) {
                return true;
            }
            if (!this.hasFacet((String)string)) {
                this.setFacetExprDescription((String)string, (IExpressionDescription)iExpressionDescription);
            }
            return true;
        });
        if (this.get == null) {
            this.get = variableDescription.get;
        }
        if (this.set == null) {
            this.set = variableDescription.set;
        }
        if (this.init == null) {
            this.init = variableDescription.init;
        }
        this.definitionClass = variableDescription.definitionClass;
    }

    @Override
    public VariableDescription copy(IDescription iDescription) {
        VariableDescription variableDescription = new VariableDescription(this.getKeyword(), iDescription, this.element, this.getFacetsCopy());
        variableDescription.addHelpers(this.get, this.init, this.set);
        variableDescription.originName = this.getOriginName();
        variableDescription.setDefinitionClass(this.definitionClass);
        return variableDescription;
    }

    protected SymbolSerializer<VariableDescription> createSerializer() {
        return VAR_SERIALIZER;
    }

    private boolean computesContextualType() {
        String string = this.getLitteral("type");
        if (string != null && string.charAt(0) == '-') {
            return true;
        }
        string = this.getLitteral("of");
        return string != null && string.charAt(0) == '-';
    }

    @Override
    public IType<?> getTypeNamed(String string) {
        IType<?> iType = super.getTypeNamed(string);
        if (iType == Types.NO_TYPE) {
            int n = GamaIntegerType.staticCast(null, string, null, false);
            switch (n) {
                case -29: {
                    IDescription iDescription = this.getEnclosingDescription();
                    IDescription iDescription2 = iDescription.getEnclosingDescription();
                    if (iDescription2 == null) {
                        return Types.AGENT;
                    }
                    return iDescription2.getGamlType();
                }
                case -199: {
                    if (this.getEnclosingDescription() == null) {
                        return Types.AGENT;
                    }
                    return this.getEnclosingDescription().getGamlType();
                }
                case -27: {
                    ModelDescription modelDescription = this.getModelDescription();
                    if (modelDescription == null) {
                        return Types.get("model");
                    }
                    return modelDescription.getGamlType();
                }
                case -31: {
                    return Types.get("experiment");
                }
                case -28: {
                    if (this.getEnclosingDescription() == null) {
                        return null;
                    }
                    IExpression iExpression = this.getEnclosingDescription().getFacetExpr("mirrors");
                    if (iExpression != null) {
                        IType<?> iType2 = iExpression.getGamlType().getContentType();
                        if (iType2.isAgentType() && iType2.id() != 11) {
                            this.getEnclosingDescription().info("The 'target' attribute will be of type " + iType2.getSpeciesName(), "gaml.general.issue", "mirrors", new String[0]);
                        }
                        return iType2;
                    }
                    this.getEnclosingDescription().info("No common species detected in 'mirrors'. The 'target' variable will be of generic type 'agent'", "gaml.wrong.type.issue", "mirrors", new String[0]);
                }
            }
        }
        return iType;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public Collection<VariableDescription> getDependencies(Set<String> set, boolean bl, boolean bl2) {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Collection<VariableDescription> collection;
            Collector.AsSet<VariableDescription> asSet;
            Collector.AsSet<IVarDescriptionUser> asSet2;
            block21: {
                asSet2 = Collector.getSet();
                asSet = Collector.getSet();
                Collection<String> collection2 = dependencies.get(this.getName());
                if (collection2 != null) {
                    for (Object object : collection2) {
                        VariableDescription variableDescription = this.getSpeciesContext().getAttribute((String)object);
                        if (variableDescription == null) continue;
                        asSet.add(variableDescription);
                    }
                }
                this.visitFacets(set, (string, iExpressionDescription) -> {
                    IExpression iExpression = iExpressionDescription.getExpression();
                    if (iExpression != null) {
                        iExpression.collectUsedVarsOf(this.getSpeciesContext(), asSet2, asSet);
                    }
                    return true;
                });
                if (this.isSyntheticSpeciesContainer()) {
                    Object object;
                    object = (SpeciesDescription)this.getEnclosingDescription();
                    SpeciesDescription speciesDescription2 = ((SpeciesDescription)object).getMicroSpecies(this.getName());
                    speciesDescription2.collectUsedVarsOf((SpeciesDescription)object, asSet2, asSet);
                }
                if (!bl) {
                    asSet.remove(this);
                }
                if (!bl2) {
                    asSet.removeIf(VariableDescription::isSyntheticSpeciesContainer);
                }
                asSet.remove(null);
                collection = asSet.items();
                if (asSet != null) {
                    asSet.close();
                }
                if (asSet2 == null) break block21;
                asSet2.close();
            }
            return collection;
            {
                catch (Throwable throwable2) {
                    try {
                        if (asSet != null) {
                            asSet.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (asSet2 != null) {
                            asSet2.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public boolean isUpdatable() {
        return this.isSet(IDescription.Flag.Updatable);
    }

    public boolean isNotModifiable() {
        return this.isSet(IDescription.Flag.Unmodifiable);
    }

    public boolean isParameter() {
        return this.isSet(IDescription.Flag.IsParameter);
    }

    public IExpression getVarExpr(boolean bl) {
        boolean bl2 = this.isGlobal() && !bl;
        return GAML.getExpressionFactory().createVar(this.getName(), this.getGamlType(), this.isNotModifiable(), bl2 ? 0 : 1, this.getEnclosingDescription());
    }

    public String toString() {
        return this.getName() + " (description)";
    }

    public String getParameterName() {
        String string = this.getLitteral("parameter");
        if (string == null || "true".equals(string)) {
            return this.getName();
        }
        return string;
    }

    @Override
    public String getTitle() {
        String string = (this.isParameter() ? "Parameter " : (this.isNotModifiable() ? "Constant " : "Attribute ")) + this.getName() + ", of type " + this.getGamlType().getName() + ", ";
        if (this.getEnclosingDescription() == null) {
            return string;
        }
        return string + "defined in " + this.getEnclosingDescription().getTitle() + "<br/>";
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        String string = this.getBuiltInDoc();
        if (this.isBuiltIn()) {
            return new IGamlDescription.ConstantDoc(string == null ? "Not yet documented" : string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string).append("<br/>");
        }
        IGamlDescription.Doc doc2 = new IGamlDescription.RegularDoc(stringBuilder).append(this.getMeta().getDocumentation().toString());
        doc2.append("<hr/>").append("<b><p>").append(this.getGamlType().getTitle()).append("</p></b>").append("<br/>").append(this.getGamlType().getDocumentation().toString());
        return doc2;
    }

    public IGamlDescription.Doc getShortDocumentation() {
        IGamlDescription.Doc doc2 = new IGamlDescription.RegularDoc(this.isParameter() ? "parameter " : (this.isNotModifiable() ? "constant " : "attribute ")).append("of type ").append(this.getGamlType().getName());
        String string = this.getBuiltInDoc();
        if (string != null) {
            doc2.append(". ").append(string).append("<br/>");
        }
        return doc2;
    }

    public String getBuiltInDoc() {
        VariableDescription variableDescription = this.getBuiltInAncestor();
        if (variableDescription == null) {
            return null;
        }
        String string = "";
        if (this.definitionClass == null) {
            return PREF_DEFINITIONS.get(this.getName());
        }
        GamlAnnotations.vars vars2 = ((GamlAnnotations.vars[])this.definitionClass.getAnnotationsByType(GamlAnnotations.vars.class))[0];
        GamlAnnotations.variable[] variableArray = vars2.value();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.variable variable2 = variableArray[n2];
            if (variable2.name().equals(this.name)) {
                GamlAnnotations.doc[] docArray = variable2.doc();
                if (docArray.length <= 0) break;
                string = docArray[0].value();
                break;
            }
            ++n2;
        }
        return string;
    }

    private VariableDescription getBuiltInAncestor() {
        if (this.getEnclosingDescription() instanceof TypeDescription) {
            TypeDescription typeDescription = (TypeDescription)this.getEnclosingDescription();
            if (typeDescription.isBuiltIn()) {
                return this;
            }
            if (typeDescription.getParent() != null && typeDescription.getParent().hasAttribute(this.name)) {
                return typeDescription.getParent().getAttribute(this.name).getBuiltInAncestor();
            }
        }
        return null;
    }

    public void addHelpers(IGamaHelper<?> iGamaHelper, IGamaHelper<?> iGamaHelper2, IGamaHelper<?> iGamaHelper3) {
        this.get = iGamaHelper;
        this.set = iGamaHelper3;
        this.init = iGamaHelper2;
    }

    public void addHelpers(Class<?> clazz, IGamaHelper<?> iGamaHelper, IGamaHelper<?> iGamaHelper2, IGamaHelper<?> iGamaHelper3) {
        this.addHelpers(iGamaHelper != null ? new GamaHelper(this.name, clazz, iGamaHelper) : null, iGamaHelper2 != null ? new GamaHelper(this.name, clazz, iGamaHelper2) : null, iGamaHelper3 != null ? new GamaHelper(this.name, clazz, iGamaHelper3) : null);
    }

    public IGamaHelper<?> getGetter() {
        return this.get;
    }

    public IGamaHelper<?> getIniter() {
        return this.init;
    }

    public IGamaHelper<?> getSetter() {
        return this.set;
    }

    public boolean isGlobal() {
        return this.isSet(IDescription.Flag.Global);
    }

    @Override
    public String getDefiningPlugin() {
        return this.plugin;
    }

    @Override
    public void setDefiningPlugin(String string) {
        this.plugin = string;
    }

    public boolean visitChildren(IDescription.DescriptionVisitor descriptionVisitor) {
        return true;
    }

    public boolean visitOwnChildren(IDescription.DescriptionVisitor descriptionVisitor) {
        return true;
    }

    @Override
    public Iterable<IDescription> getOwnChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean isContextualType() {
        return this.isSet(IDescription.Flag.isContextualType);
    }

    public void setDefinitionClass(Class clazz) {
        this.definitionClass = clazz;
    }

    @Override
    protected void flagError(String string, String string2, GamlCompilationError.GamlCompilationErrorType gamlCompilationErrorType, EObject eObject, String ... stringArray) throws GamaRuntimeException {
        if (this.isExperimentParameter()) {
            EObject eObject2 = this.getUnderlyingElement();
            if (EcoreUtil.isAncestor((EObject)eObject2, (EObject)eObject)) {
                super.flagError(string, string2, gamlCompilationErrorType, eObject, stringArray);
            } else {
                super.flagError(string, string2, gamlCompilationErrorType, eObject2, stringArray);
            }
        } else {
            super.flagError(string, string2, gamlCompilationErrorType, eObject, stringArray);
        }
    }

    @Override
    protected IType<?> computeType() {
        return this.computeType(false);
    }
}

