/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.topology.grid.IGrid;
import gama.core.metamodel.topology.grid.IGridAgent;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.core.util.IList;
import gama.gaml.skills.Skill;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="color", type=6, init="#white", doc={@GamlAnnotations.doc(value="Represents the color of the cell, used by default to represent the grid on displays")}), @GamlAnnotations.variable(name="neighbors", type=5, of=-199, doc={@GamlAnnotations.doc(value="Represents the neighbor at distance 1 of the cell")}), @GamlAnnotations.variable(name="grid_value", type=2, doc={@GamlAnnotations.doc(value="Represents a floating point value (automatically set when the grid is initialized from a grid file, and used by default to represent the elevation of the cell when displaying it on a display)")}), @GamlAnnotations.variable(name="bands", type=5, of=2, doc={@GamlAnnotations.doc(value="Represents the values of the different bands of the cell (list of floating point value automatically set when the grid is initialized from a grid file)")}), @GamlAnnotations.variable(name="grid_x", type=1, constant=true, doc={@GamlAnnotations.doc(value="Returns the 0-based index of the column of the cell in the grid")}), @GamlAnnotations.variable(name="grid_y", type=1, constant=true, doc={@GamlAnnotations.doc(value="Returns the 0-based index of the row of the cell in the grid")})})
@GamlAnnotations.skill(name="grid", concept={"grid", "skill"}, internal=true)
public class GridSkill
extends Skill {
    public static final String SKILL_NAME = "grid";

    protected final IGrid getGrid(IAgent iAgent) {
        return (IGrid)iAgent.getPopulation().getTopology().getPlaces();
    }

    @GamlAnnotations.getter(value="grid_x")
    public final int getX(IAgent iAgent) {
        return ((IGridAgent)iAgent).getX();
    }

    @GamlAnnotations.getter(value="grid_value", initializer=true)
    public final double getValue(IAgent iAgent) {
        return ((IGridAgent)iAgent).getValue();
    }

    @GamlAnnotations.getter(value="bands", initializer=true)
    public final IList<Double> getBands(IAgent iAgent) {
        return ((IGridAgent)iAgent).getBands();
    }

    @GamlAnnotations.setter(value="bands")
    public final void setBands(IAgent iAgent, IList<Double> iList) {
    }

    @GamlAnnotations.getter(value="grid_y")
    public final int getY(IAgent iAgent) {
        return ((IGridAgent)iAgent).getY();
    }

    @GamlAnnotations.setter(value="grid_x")
    public final void setX(IAgent iAgent, Integer n) {
    }

    @GamlAnnotations.setter(value="grid_value")
    public final void setValue(IAgent iAgent, Double d) {
        ((IGridAgent)iAgent).setValue(d);
    }

    @GamlAnnotations.setter(value="grid_y")
    public final void setY(IAgent iAgent, Integer n) {
    }

    @GamlAnnotations.getter(value="color", initializer=true)
    public GamaColor getColor(IAgent iAgent) {
        return ((IGridAgent)iAgent).getColor();
    }

    @GamlAnnotations.setter(value="color")
    public void setColor(IAgent iAgent, GamaColor gamaColor) {
        ((IGridAgent)iAgent).setColor(gamaColor);
    }

    @GamlAnnotations.getter(value="neighbors", initializer=true)
    public IList<IAgent> getNeighbors(IScope iScope, IAgent iAgent) {
        return ((IGridAgent)iAgent).getNeighbors(iScope);
    }
}

