/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.interfaces.IAsset;
import gama.core.common.interfaces.IDrawDelegate;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.GamaGisFile;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.draw.AssetDrawingAttributes;
import gama.gaml.statements.draw.DrawingData;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.geom.Rectangle2D;
import org.locationtech.jts.geom.Envelope;

public class AssetDrawer
implements IDrawDelegate {
    @Override
    public Rectangle2D executeOn(IScope.IGraphicsScope iGraphicsScope, DrawingData drawingData, IExpression ... iExpressionArray) throws GamaRuntimeException {
        Scaling3D scaling3D;
        IGraphics iGraphics = iGraphicsScope.getGraphics();
        Object object = iExpressionArray[0].value(iGraphicsScope);
        if (!(object instanceof IAsset)) {
            return null;
        }
        IAsset iAsset = (IAsset)object;
        AssetDrawingAttributes assetDrawingAttributes = this.computeAttributes(iGraphicsScope, drawingData, iAsset instanceof IImageProvider, iAsset instanceof GamaGisFile, iGraphics.is2D());
        if (GamaPreferences.Displays.DISPLAY_ONLY_VISIBLE.getValue().booleanValue() && !iGraphicsScope.getExperiment().isHeadless() && (scaling3D = assetDrawingAttributes.getSize()) != null) {
            Envelope3D envelope3D = Envelope3D.of(assetDrawingAttributes.getLocation());
            envelope3D.expandBy(scaling3D.getX() / 2.0, scaling3D.getY() / 2.0);
            Envelope envelope = iGraphics.getVisibleRegion();
            if (envelope != null && !envelope.intersects((Envelope)envelope3D)) {
                return null;
            }
        }
        return iGraphics.drawAsset(iAsset, assetDrawingAttributes);
    }

    AssetDrawingAttributes computeAttributes(IScope iScope, DrawingData drawingData, boolean bl, boolean bl2, boolean bl3) {
        Scaling3D scaling3D;
        AssetDrawingAttributes assetDrawingAttributes = new AssetDrawingAttributes(Scaling3D.of(drawingData.size.get()), drawingData.rotation.get(), drawingData.getLocation(), drawingData.color.get(), drawingData.border.get(), iScope.getAgent(), drawingData.lineWidth.get(), bl, drawingData.lighting.get());
        if (!bl2 && assetDrawingAttributes.getLocation() == null) {
            assetDrawingAttributes.setLocation(iScope.getAgent().getLocation().clone());
        }
        if (bl3 && bl && (scaling3D = assetDrawingAttributes.getSize()) != null) {
            assetDrawingAttributes.setLocation(assetDrawingAttributes.getLocation().minus(scaling3D.getX() / 2.0, scaling3D.getY() / 2.0, scaling3D.getZ() / 2.0));
        }
        return assetDrawingAttributes;
    }

    @Override
    public IType<?> typeDrawn() {
        return Types.FILE;
    }
}

