/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IDrawDelegate;
import gama.core.common.interfaces.IGraphics;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.draw.DrawingData;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="geometry", type={0}, optional=true, doc={@GamlAnnotations.doc(value="any type of data (it can be geometry, image, text)")}), @GamlAnnotations.facet(name="texture", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the texture(s) that should be applied to the geometry. Either a path to a file or a list of paths")}), @GamlAnnotations.facet(name="wireframe", type={3}, optional=true, doc={@GamlAnnotations.doc(value="a condition specifying whether to draw the geometry in wireframe or not")}), @GamlAnnotations.facet(name="border", type={6, 3}, optional=true, doc={@GamlAnnotations.doc(value="if used with a color, represents the color of the geometry border. If set to false, expresses that no border should be drawn. If not set, the borders will be drawn using the color of the geometry.")}), @GamlAnnotations.facet(name="at", type={7}, optional=true, doc={@GamlAnnotations.doc(value="location where the shape/text/icon is drawn")}), @GamlAnnotations.facet(name="anchor", type={7}, optional=true, doc={@GamlAnnotations.doc(value="Only used when perspective: true in OpenGL. The anchor point of the location with respect to the envelope of the text to draw, can take one of the following values: #center, #top_left, #left_center, #bottom_left, #bottom_center, #bottom_right, #right_center, #top_right, #top_center; or any point between {0,0} (#bottom_left) and {1,1} (#top_right)")}), @GamlAnnotations.facet(name="size", type={2, 7}, optional=true, doc={@GamlAnnotations.doc(value="Size of the shape/icon/image to draw, expressed as a bounding box (width, height, depth; if expressed as a float, represents the box as a cube). Does not apply to texts: use a font with the required size instead")}), @GamlAnnotations.facet(name="color", type={6, 16}, optional=true, doc={@GamlAnnotations.doc(value="the color to use to display the object. In case of images, will try to colorize it. You can also pass a list of colors : in that case, each color will be matched to its corresponding vertex.")}), @GamlAnnotations.facet(name="rotate", type={2, 1, 9}, index=2, of=7, optional=true, doc={@GamlAnnotations.doc(value="orientation of the shape/text/icon; can be either an int/float (angle) or a pair float::point (angle::rotation axis). The rotation axis, when expressed as an angle, is by defaut {0,0,1}")}), @GamlAnnotations.facet(name="font", type={19, 4}, optional=true, doc={@GamlAnnotations.doc(value="the font used to draw the text, if any. Applying this facet to geometries or images has no effect. You can construct here your font with the operator \"font\". ex : font:font(\"Helvetica\", 20 , #plain)")}), @GamlAnnotations.facet(name="depth", type={2}, optional=true, doc={@GamlAnnotations.doc(value="(only if the display type is opengl) Add an artificial depth to the geometry previously defined (a line becomes a plan, a circle becomes a cylinder, a square becomes a cube, a polygon becomes a polyhedron with height equal to the depth value). Note: This only works if the geometry is not a point ")}), @GamlAnnotations.facet(name="precision", type={2}, optional=true, doc={@GamlAnnotations.doc(value="(only if the display type is opengl and only for text drawing) controls the accuracy with which curves are rendered in glyphs. Between 0 and 1, the default is 0.1. Smaller values will output much more faithful curves but can be considerably slower, so it is better if they concern text that does not change and can be drawn inside layers marked as 'refresh: false'")}), @GamlAnnotations.facet(name="begin_arrow", type={1, 2}, optional=true, doc={@GamlAnnotations.doc(value="the size of the arrow, located at the beginning of the drawn geometry")}), @GamlAnnotations.facet(name="end_arrow", type={1, 2}, optional=true, doc={@GamlAnnotations.doc(value="the size of the arrow, located at the end of the drawn geometry")}), @GamlAnnotations.facet(name="lighted", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the object should be lighted or not (only applicable in the context of opengl displays)")}), @GamlAnnotations.facet(name="perspective", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether to render the text in perspective or facing the user. Default is in perspective.")}), @GamlAnnotations.facet(name="width", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The line width to use for drawing this object. In OpenGL displays, this attribute is considered as optional and not implemented by all gaphic card vendors. The default value is set by the preference found in Displays>OpenGL Rendering Properties (which, when inspected, also provides the maximal possible value on the local graphics configuration)")})}, omissible="geometry")
@GamlAnnotations.inside(symbols={"aspect"}, kinds={11, 6})
@GamlAnnotations.doc(value="`draw` is used in an aspect block to express how agents of the species will be drawn. It is evaluated each time the agent has to be drawn. It can also be used in the graphics block.", usages={@GamlAnnotations.usage(value="Any kind of geometry as any location can be drawn when displaying an agent (independently of his shape)", examples={@GamlAnnotations.example(value="aspect geometryAspect {", isExecutable=false), @GamlAnnotations.example(value="\tdraw circle(1.0) empty: !hasFood color: #orange ;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Image or text can also be drawn", examples={@GamlAnnotations.example(value="aspect arrowAspect {", isExecutable=false), @GamlAnnotations.example(value="\tdraw \"Current state= \"+state at: location + {-3,1.5} color: #white font: font('Default', 12, #bold) ;", isExecutable=false), @GamlAnnotations.example(value="\tdraw file(ant_shape_full) rotate: heading at: location size: 5", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Arrows can be drawn with any kind of geometry, using begin_arrow and end_arrow facets, combined with the empty: facet to specify whether it is plain or empty", examples={@GamlAnnotations.example(value="aspect arrowAspect {", isExecutable=false), @GamlAnnotations.example(value="\tdraw line([{20, 20}, {40, 40}]) color: #black begin_arrow:5;", isExecutable=false), @GamlAnnotations.example(value="\tdraw line([{10, 10},{20, 50}, {40, 70}]) color: #green end_arrow: 2 begin_arrow: 2 empty: true;", isExecutable=false), @GamlAnnotations.example(value="\tdraw square(10) at: {80,20} color: #purple begin_arrow: 2 empty: true;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
@validator(value=DrawValidator.class)
public class DrawStatement
extends AbstractStatementSequence {
    public static final String END_ARROW = "end_arrow";
    public static final String BEGIN_ARROW = "begin_arrow";
    private static final Map<IType, IDrawDelegate> DELEGATES = new HashMap<IType, IDrawDelegate>();
    private IDrawDelegate delegate;
    private final WeakHashMap<IGraphics, DrawingData> data = new WeakHashMap();

    public static void addDelegate(IDrawDelegate iDrawDelegate) {
        IType<?> iType = iDrawDelegate.typeDrawn();
        if (iType != null) {
            DELEGATES.put(iType, iDrawDelegate);
        }
    }

    public DrawStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
    }

    @Override
    public Rectangle2D privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        if (iScope.isGraphics()) {
            return this.privateExecuteIn((IScope.IGraphicsScope)iScope);
        }
        return null;
    }

    private Rectangle2D privateExecuteIn(IScope.IGraphicsScope iGraphicsScope) throws GamaRuntimeException {
        IGraphics iGraphics = iGraphicsScope.getGraphics();
        if (iGraphicsScope.interrupted() || iGraphics == null || iGraphicsScope.getAgent() == null) {
            return null;
        }
        try {
            DrawingData drawingData;
            if (this.delegate == null) {
                this.delegate = (IDrawDelegate)this.getFacet("delegate").value(iGraphicsScope);
            }
            if ((drawingData = this.data.get(iGraphics)) == null) {
                drawingData = new DrawingData(this);
                this.data.put(iGraphics, drawingData);
            }
            drawingData.refresh(iGraphicsScope);
            IExpression iExpression = this.getFacet("geometry");
            Rectangle2D rectangle2D = this.delegate.executeOn(iGraphicsScope, drawingData, iExpression, this.getFacet(BEGIN_ARROW), this.getFacet(END_ARROW));
            if (rectangle2D != null) {
                iGraphics.accumulateTemporaryEnvelope(rectangle2D);
            }
            return rectangle2D;
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            throw gamaRuntimeException;
        }
        catch (Throwable throwable) {
            DEBUG.ERR((Object)("Error when drawing in a display : " + throwable.getMessage()));
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public void dispose() {
        this.data.clear();
        super.dispose();
    }

    public static class DrawValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            IExpressionDescription iExpressionDescription = statementDescription.getFacet("geometry");
            if (iExpressionDescription != null) {
                Map.Entry<IType, IDrawDelegate> entry2;
                Object object;
                Object object2;
                Object object3 = Arrays.asList("text", "shape", "image").iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    object = statementDescription.getFacet((String)object2);
                    if (object == null) continue;
                    statementDescription.warning("'" + (String)object2 + "' has no effect here", "gaml.conflicting.facets", (String)object2, new String[0]);
                }
                object2 = iExpressionDescription.getExpression();
                Object object4 = object3 = object2 == null ? Types.NO_TYPE : object2.getGamlType();
                if (object2 == null || !this.canDraw((IExpression)object2)) {
                    statementDescription.error("'draw' cannot draw objects of type " + String.valueOf(object3), "gaml.wrong.type.issue", "geometry", new String[0]);
                    return;
                }
                if (object3.equals(Types.STRING) && (object = statementDescription.getFacet("rotate")) != null && (entry2 = statementDescription.getFacet("perspective")) != null && entry2.isConst() && entry2.equalsString("false")) {
                    statementDescription.warning("Rotations cannot be applied when perspective is false", "gaml.conflicting.facets", "rotate", new String[0]);
                }
                object = null;
                for (Map.Entry<IType, IDrawDelegate> entry2 : DELEGATES.entrySet()) {
                    if (!((IType)entry2.getKey()).isAssignableFrom((IType<?>)object3)) continue;
                    object = (IDrawDelegate)entry2.getValue();
                    break;
                }
                if (object == null) {
                    statementDescription.error("'draw' cannot draw objects of type " + String.valueOf(object3), "gaml.wrong.type.issue", "geometry", new String[0]);
                    return;
                }
                object.validate(statementDescription, (IExpression)object2);
                statementDescription.setFacet("delegate", GAML.getExpressionFactory().createConst(object, Types.NO_TYPE));
            }
        }

        private boolean canDraw(IExpression iExpression) {
            IType<?> iType = iExpression.getGamlType();
            if (iType.isDrawable()) {
                return true;
            }
            iType = iType.typeIfCasting(iExpression);
            return iType.isDrawable();
        }
    }
}

