/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.IFieldMatrixProvider;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.IField;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;

@GamlAnnotations.type(name="field", id=31, wraps={IField.class, GamaField.class}, kind=102, concept={"type", "grid", "matrix"}, doc={@GamlAnnotations.doc(value="Fields are two-dimensional matrices holding float values. They can be easily created from arbitrary sources (grid, raster or DEM files, matrices, grids) and of course by hand. The values they hold are accessible by agents like grids are, using their current location. They can be the target of the 'diffuse' statement and can be displayed using the 'mesh' layer definition. As such, they represent a lightweight alternative to grids, as they hold spatialized discrete values without having to build agents, which can be particularly interesting for models with large raster data. Several fields can of course be defined, and it makes sense to define them in the global section as, for the moment, they cover by default the whole environment, exactly like grids, and are created alongside them")})
public class GamaFieldType
extends GamaMatrixType {
    public static IField buildField(IScope iScope, Object object) {
        return GamaFieldType.staticCast(iScope, object, null, null, false);
    }

    public static IField staticCast(IScope iScope, Object object, Object object2, IType iType, boolean bl) {
        GamaPoint gamaPoint;
        if (object == null && object2 == null) {
            return null;
        }
        GamaPoint gamaPoint2 = gamaPoint = object2 instanceof GamaPoint ? (GamaPoint)object2 : null;
        if (gamaPoint == null) {
            ISpecies iSpecies;
            if (object instanceof IField && !bl) {
                return (IField)object;
            }
            if (object instanceof IFieldMatrixProvider) {
                return ((IFieldMatrixProvider)object).getField(iScope);
            }
            if (object instanceof IContainer) {
                return GamaFieldType.staticCast(iScope, ((IContainer)object).matrixValue(iScope, iType, bl), null, iType, bl);
            }
            if (object instanceof ISpecies && (iSpecies = (ISpecies)object).isGrid()) {
                return GamaFieldType.staticCast(iScope, iSpecies.getPopulation(iScope).getTopology().getPlaces(), object2, iType, bl);
            }
        } else if (gamaPoint.x <= 0.0 || gamaPoint.y < 0.0) {
            throw GamaRuntimeException.error("Dimensions of a field should be positive.", iScope);
        }
        if (object instanceof IContainer) {
            return GamaFieldType.staticCast(iScope, ((IContainer)object).matrixValue(iScope, iType, gamaPoint, bl), null, iType, bl);
        }
        return GamaFieldType.with(iScope, object, gamaPoint, iType);
    }

    public static IField with(IScope iScope, Object object, GamaPoint gamaPoint, IType iType) throws GamaRuntimeException {
        int n = gamaPoint == null ? 1 : (int)gamaPoint.x;
        int n2 = gamaPoint == null ? 1 : (int)gamaPoint.y;
        return GamaFieldType.withObject(iScope, object, n, n2, iType);
    }

    public static IField withObject(IScope iScope, Object object, int n, int n2, IType iType) throws GamaRuntimeException {
        Double d = Cast.asFloat(iScope, object);
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(n, n2);
        gamaFloatMatrix.setAllValues(iScope, d);
        return GamaFieldType.buildField(iScope, gamaFloatMatrix);
    }

    @Override
    public IField cast(IScope iScope, Object object, Object object2, IType iType, IType iType2, boolean bl) throws GamaRuntimeException {
        return GamaFieldType.staticCast(iScope, object, object2, iType2, bl);
    }

    @Override
    public IType contentsTypeIfCasting(IExpression iExpression) {
        return Types.FLOAT;
    }

    @Override
    public IType<?> getContentType() {
        return Types.FLOAT;
    }

    @Override
    public boolean isDrawable() {
        return true;
    }

    @GamlAnnotations.operator(value={"field"}, can_be_const=false, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Allows to build a field by specifying, in order, its number of columns, number of rows, the initial value of its cells and the value representing the absence of value")})
    public static IField buildField(IScope iScope, int n, int n2, double d, double d2) {
        double[] dArray = new double[n * n2];
        Arrays.fill(dArray, d);
        return new GamaField(iScope, n, n2, dArray, d2);
    }

    @GamlAnnotations.operator(value={"field"}, can_be_const=false, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Allows to build a field by specifying, in order, its number of columns, number of rows and the initial value of its cells. The value representing the absence of value is set to #max_float")})
    public static IField buildField(IScope iScope, int n, int n2, double d) {
        return GamaFieldType.buildField(iScope, n, n2, d, Double.MAX_VALUE);
    }

    @GamlAnnotations.operator(value={"field_with"}, content_type=2, can_be_const=true, category={"Casting operators"}, concept={"cast", "container"})
    @GamlAnnotations.doc(value="creates a field with a size provided by the first operand, and filled by the evaluation of the second operand for each cell", comment="Note that both components of the right operand point should be positive, otherwise an exception is raised.", see={"matrix", "as_matrix"})
    public static IField buildFieldWith(IScope iScope, GamaPoint gamaPoint, IExpression iExpression) {
        if (gamaPoint == null) {
            throw GamaRuntimeException.error("A nil size is not allowed for matrices", iScope);
        }
        IField iField = GamaFieldType.buildField(iScope, (int)gamaPoint.x, (int)gamaPoint.y, 0.0);
        double[] dArray = iField.getMatrix();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Cast.asFloat(iScope, iExpression.value(iScope));
            ++n;
        }
        return iField;
    }

    @GamlAnnotations.operator(value={"field"}, can_be_const=false, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Allows to build a field by specifying, in order, its number of columns and number of rows. The initial value of its cells is set to 0.0 and the value representing the absence of value is set to #max_float")})
    public static IField buildField(IScope iScope, int n, int n2) {
        return GamaFieldType.buildField(iScope, n, n2, 0.0);
    }

    @GamlAnnotations.operator(value={"field"}, can_be_const=false, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Allows to build a field by specifying an arbitrary object (assuming this object can return a matrix of float) and a value representing the absence of data. ")})
    public static IField buildFieldWithNoData(IScope iScope, Object object, double d) {
        IField iField = GamaFieldType.buildField(iScope, object);
        iField.setNoData(iScope, d);
        return iField;
    }

    @GamlAnnotations.operator(value={"cell_at"}, can_be_const=false, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Returns the rectangular shape that corresponds to the 'cell' in the field at this location. This cell has no attributes. A future version may load it with the value of the field at this attribute")})
    public static IShape buildShapeFromFieldLocation(IScope iScope, IField iField, GamaPoint gamaPoint) {
        return iField.getCellShapeAt(iScope, gamaPoint);
    }

    @GamlAnnotations.operator(value={"cell_at"}, can_be_const=false, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Returns the rectangular shape that corresponds to the 'cell' in the field at this location in the matrix (column, row). This cell has no attributes. A future version may load it with the value of the field at this attribute")})
    public static IShape buildShapeFromFieldLocation(IScope iScope, IField iField, int n, int n2) {
        return iField.getCellShapeAt(iScope, n, n2);
    }

    @GamlAnnotations.operator(value={"cells_in"}, can_be_const=false, content_type=13, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Returns the list of 'cells' that 'intersect' with the geometry passed in argument. (Intersection is understood as the cell center is insside the geometry; if the  geometry is a polyline or a point, results will not be accurate.The cells are ordered by their x-, then y-coordinates")})
    public static IList<IShape> getShapesFromGeometry(IScope iScope, IField iField, IShape iShape) {
        return iField.getCellsIntersecting(iScope, iShape);
    }

    @GamlAnnotations.operator(value={"cells_overlapping"}, can_be_const=false, content_type=13, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Returns the list of 'cells' that 'overlap' the geometry passed in argument. It is much less efficient than the cells_in operator, but is relevant is a polynie or a point. The cells are ordered by their x-, then y-coordinates")})
    public static IList<IShape> getShapesOverGeometry(IScope iScope, IField iField, IShape iShape) {
        return iField.getCellsOverlapping(iScope, iShape);
    }

    @GamlAnnotations.operator(value={"values_in"}, can_be_const=false, content_type=2, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Returns the list of values in the field whose 'cell' 'intersects' with the geometry passed in argument. The values are ordered by the x-, then y-coordinate, of their 'cell'")})
    public static IList<Double> getValuesFromGeometry(IScope iScope, IField iField, IShape iShape) {
        return iField.getValuesIntersecting(iScope, iShape);
    }

    @GamlAnnotations.operator(value={"points_in"}, can_be_const=false, content_type=7, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Returns the list of values in the field whose 'cell' 'intersects' with the geometry passed in argument. The values are ordered by the x-, then y-coordinate, of their 'cell'")})
    public static IList<GamaPoint> getPointsFromGeometry(IScope iScope, IField iField, IShape iShape) {
        return iField.getLocationsIntersecting(iScope, iShape);
    }

    @GamlAnnotations.operator(value={"neighbors_of"}, can_be_const=false, content_type=7, category={"Grid-related operators"}, concept={"grid"}, doc={@GamlAnnotations.doc(value="Returns the list of the 'neighbors' of a given world coordinate point, which correspond to the world coordinates of the cells that surround the cell located at this point")})
    public static IList<GamaPoint> getNeighborsOf(IScope iScope, IField iField, GamaPoint gamaPoint) {
        return iField.getNeighborsOf(iScope, gamaPoint);
    }
}

