/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.test.TestExperimentSummary;
import gama.gaml.statements.test.TestStatement;
import gama.gaml.statements.test.WithTestSummary;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;

@GamlAnnotations.experiment(value="test")
@GamlAnnotations.doc(value="Experiments supporting the collection of success or failure of tests. Can be used in GUI or headless")
public class TestAgent
extends BatchAgent
implements WithTestSummary<TestExperimentSummary> {
    TestExperimentSummary summary;

    public TestAgent(IPopulation iPopulation, int n) throws GamaRuntimeException {
        super(iPopulation, n);
    }

    @Override
    protected IExpression defaultStopCondition() {
        return new AbstractExpression(){

            @Override
            public String serializeToGaml(boolean bl) {
                return "cycle = 1";
            }

            @Override
            public Boolean _value(IScope iScope) throws GamaRuntimeException {
                if (iScope.getClock().getCycle() == 1) {
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public boolean init(IScope iScope) {
        super.init(iScope);
        TestExperimentSummary testExperimentSummary = this.getSummary();
        testExperimentSummary.reset();
        if (!testExperimentSummary.isEmpty()) {
            iScope.getGui().openTestView(iScope, false);
        }
        return true;
    }

    @Override
    public boolean step(IScope iScope) {
        super.step(iScope);
        this.dispose();
        return true;
    }

    @Override
    public void dispose() {
        if (this.dead) {
            return;
        }
        this.getScope().getGui().displayTestsResults(this.getScope(), this.summary);
        this.getScope().getGui().endTestDisplay();
        super.dispose();
    }

    @Override
    protected String endStatus() {
        return "Tests over: " + this.summary.getStringSummary();
    }

    @Override
    public void addSpecificParameters(List<IParameter.Batch> list) {
        list.add(new ParameterAdapter("Stop condition", "Configuration of tests", 4){

            @Override
            public String value() {
                return TestAgent.this.stopCondition != null ? TestAgent.this.stopCondition.serializeToGaml(false) : "none";
            }
        });
        list.add(new ParameterAdapter("Parameter space", "Configuration of tests", "", 4){

            @Override
            public String value() {
                Map<String, IParameter.Batch> map = TestAgent.this.getSpecies().getExplorableParameters();
                if (map.isEmpty()) {
                    return "1";
                }
                Object object = "";
                int n = 1;
                for (Map.Entry<String, IParameter.Batch> entry : map.entrySet()) {
                    object = (String)object + entry.getKey() + " (";
                    int n2 = this.getExplorationDimension(entry.getValue());
                    n *= n2;
                    object = (String)object + String.valueOf(n2) + ") * ";
                }
                if (!((String)object).isEmpty()) {
                    object = ((String)object).substring(0, ((String)object).length() - 2);
                }
                object = (String)object + " = " + n;
                return object;
            }

            int getExplorationDimension(IParameter.Batch batch) {
                IScope iScope = TestAgent.this.getScope();
                if (batch.getAmongValue(iScope) != null) {
                    return batch.getAmongValue(iScope).size();
                }
                return (int)((Cast.asFloat(iScope, batch.getMaxValue(iScope)) - Cast.asFloat(iScope, batch.getMinValue(iScope))) / Cast.asFloat(iScope, batch.getStepValue(iScope))) + 1;
            }
        });
    }

    @Override
    public TestExperimentSummary getSummary() {
        if (this.summary == null) {
            this.summary = new TestExperimentSummary(this);
        }
        return this.summary;
    }

    @Override
    public String getTitleForSummary() {
        String string = this.getSpecies().getDescription().getModelDescription().getModelFilePath();
        String string2 = string.substring(string.lastIndexOf(47) + 1).replace(".experiment", "").replace(".gaml", "");
        return this.getSpecies().getName() + " in " + string2;
    }

    @Override
    public URI getURI() {
        return this.getModel().getURI();
    }

    @Override
    public Collection<? extends WithTestSummary<?>> getSubElements() {
        List<TestStatement> list = this.getModel().getAllTests();
        Consumer<IStatement> consumer = iStatement -> {
            if (iStatement instanceof TestStatement) {
                TestStatement testStatement = (TestStatement)iStatement;
                list.add(testStatement);
            }
        };
        this.getSpecies().getBehaviors().forEach(consumer);
        return list;
    }
}

