/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.experiment.IExperimentDisplayable;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.types.GamaFontType;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="The color with wich the text will be displayed. Not used when HTML text is displayed.")}), @GamlAnnotations.facet(name="background", type={6}, optional=true, doc={@GamlAnnotations.doc(value="The color of the background of the text. Not used when HTML text is displayed.")}), @GamlAnnotations.facet(name="font", type={19, 4}, optional=true, doc={@GamlAnnotations.doc(value="The font used to draw the text, which can be built with the operator \"font\". ex : font:font(\"Helvetica\", 20 , #bold). Not used when HTML text is displayed.")}), @GamlAnnotations.facet(name="category", type={-200}, optional=true, doc={@GamlAnnotations.doc(value="A category label, used to group parameters in the interface")}), @GamlAnnotations.facet(name="message", type={0}, optional=false, doc={@GamlAnnotations.doc(value="The text to display.\nIf the text does not begin with <html>, the font, color, and background are controlled by the respective facets. A few formatting tags: <br/> / <b> ... </b> / <i> ... </i> / <a href=\"..\"> ... </a> are supported. Others are ignored. Weblinks (http, https) are automatically detected. Beware that not closing the tags correctly will result in an error.\nIf the text begins with <html>, it will instead be interpreted and displayed in a mini-browser. Most of the regular html tags can be used, including displaying images, and all links will be treated as external (i.e. opening a new browser).\n")})}, omissible="message")
@GamlAnnotations.doc(value="The statement makes an experiment display formatted text in the parameters view.")
public class TextStatement
extends AbstractStatement
implements IExperimentDisplayable {
    final IExpression message = this.getFacet("message");
    final IExpression color = this.getFacet("color");
    final IExpression category = this.getFacet("category");
    final IExpression font = this.getFacet("font");
    final IExpression background = this.getFacet("background");

    public TextStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        return null;
    }

    public String getText(IScope iScope) {
        return Cast.asString(iScope, this.message.value(iScope));
    }

    public GamaFont getFont(IScope iScope) {
        if (this.font == null) {
            return null;
        }
        return GamaFontType.staticCast(iScope, this.font.value(iScope), false);
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        GamaColor gamaColor = null;
        if (this.color != null) {
            gamaColor = Cast.asColor(iScope, this.color.value(iScope));
        }
        return gamaColor;
    }

    public GamaColor getBackground(IScope iScope) {
        GamaColor gamaColor = null;
        if (this.background != null) {
            gamaColor = Cast.asColor(iScope, this.background.value(iScope));
        }
        return gamaColor;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        return "";
    }

    @Override
    public void setUnitLabel(String string) {
    }

    @Override
    public boolean isDefinedInExperiment() {
        return true;
    }

    @Override
    public String getCategory() {
        if (this.category == null) {
            return IExperimentDisplayable.super.getCategory();
        }
        return this.category.literalValue();
    }
}

