/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.simulation;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.RandomUtils;
import gama.core.kernel.experiment.ActionExecuter;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.agent.ISerialisedAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.ISerialisedPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.continuous.RootTopology;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.metamodel.topology.projection.WorldProjection;
import gama.core.outputs.IOutput;
import gama.core.outputs.IOutputManager;
import gama.core.outputs.SimulationOutputManager;
import gama.core.runtime.ExecutionScope;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.concurrent.SimulationLocal;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaDate;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.IReference;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.GamaGeometryType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;

@GamlAnnotations.species(name="model", internal=true)
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="color", type=6, doc={@GamlAnnotations.doc(value="The color used to identify this simulation in the UI", comment="Can be set freely by the modeler")}), @GamlAnnotations.variable(name="seed", type=2, doc={@GamlAnnotations.doc(value="The seed of the random number generator. Each time it is set, the random number generator is reinitialized. WARNING: Setting it to zero actually means that you let GAMA choose a random seed.")}), @GamlAnnotations.variable(name="rng", type=4, doc={@GamlAnnotations.doc(value="The random number generator to use. Four different ones are at the disposal of the modeler: 'mersenne' represents the default generator, based on the Mersenne-Twister algorithm. Very reliable, fast and deterministic (that is, using the same seed and the same sequence of calls, it will return the same stream of pseudo-random numbers). This algorithm is however not safe to use in simulations where agents can behave in parallel; 'threaded' is a very fast generator, based on the DotMix algorithm, that can be safely used in parallel simulations as it creates one instance per thread. However, determinism cannot be guaranteed and this algorithm does not accept a seed as each instance will compute its own;'parallel' is a version of the Mersenne-Twister algorithm that can be safely used in parallel simulations by preventing a concurrent access to its internal state. Determinism is guaranteed (in terms of generation, but not in terms of execution, as the sequence in which the threads will access it cannot be determined) and it performs a bit slower than its base version.'java' invokes the standard generator provided by the JDK, deterministic and thread-safe, albeit slower than all the other ones")}), @GamlAnnotations.variable(name="experiment", type=-31, doc={@GamlAnnotations.doc(value="Returns the current experiment agent")}), @GamlAnnotations.variable(name="world", type=-27, doc={@GamlAnnotations.doc(value="Represents the 'world' of the agents, i.e. the instance of the model in which they are instantiated. Equivalent to 'simulation' in experiments")}), @GamlAnnotations.variable(name="step", type=2, doc={@GamlAnnotations.doc(value="Represents the value of the interval, in model time, between two simulation cycles", comment="If not set, its value is equal to 1.0 and, since the default time unit is the second, to 1 second")}), @GamlAnnotations.variable(name="time", type=2, doc={@GamlAnnotations.doc(value="Represents the total time passed, in model time, since the beginning of the simulation", comment="Equal to cycle * step if the user does not arbitrarily initialize it.")}), @GamlAnnotations.variable(name="cycle", type=1, doc={@GamlAnnotations.doc(value="Returns the current cycle of the simulation")}), @GamlAnnotations.variable(name="rng_usage", type=1, doc={@GamlAnnotations.doc(value="Returns the number of times the random number generator of the simulation has been drawn")}), @GamlAnnotations.variable(name="paused", type=3, doc={@GamlAnnotations.doc(value="Returns the current pausing state of the simulation")}), @GamlAnnotations.variable(name="duration", type=4, doc={@GamlAnnotations.doc(value="Returns a string containing the duration, in milliseconds, of the previous simulation cycle")}), @GamlAnnotations.variable(name="total_duration", type=4, doc={@GamlAnnotations.doc(value="Returns a string containing the total duration, in milliseconds, of the simulation since it has been launched ")}), @GamlAnnotations.variable(name="average_duration", type=4, doc={@GamlAnnotations.doc(value="Returns a string containing the average duration, in milliseconds, of a simulation cycle.")}), @GamlAnnotations.variable(name="current_date", depends_on={"starting_date"}, type=23, doc={@GamlAnnotations.doc(value="Returns the current date in the simulation", comment="The return value is a date; the starting_date has to be initialized to use this attribute, which otherwise indicates a pseudo-date")}), @GamlAnnotations.variable(name="starting_date", type=23, doc={@GamlAnnotations.doc(value="Represents the starting date of the simulation", comment="If no starting_date is provided in the model, GAMA initializes it with a zero date: 1st of January, 1970 at 00:00:00")})})
public class SimulationAgent
extends GamlAgent
implements ITopLevelAgent {
    public static final String DURATION = "duration";
    public static final String TOTAL_DURATION = "total_duration";
    public static final String AVERAGE_DURATION = "average_duration";
    public static final String TIME = "time";
    public static final String CURRENT_DATE = "current_date";
    public static final String STARTING_DATE = "starting_date";
    public static final String PAUSED = "paused";
    public static final String USAGE = "rng_usage";
    final SimulationClock ownClock;
    GamaColor color;
    final IScope ownScope = new ExecutionScope(this);
    private SimulationOutputManager outputs;
    final ProjectionFactory projectionFactory;
    private Boolean scheduled = false;
    private volatile boolean isOnUserHold;
    private RandomUtils random;
    private final ActionExecuter executer;
    private RootTopology topology;
    private Map simulationLocalMap;
    private Map<String, Object> externalInitsAndParameters;

    public SimulationAgent(IPopulation<? extends IAgent> iPopulation, int n) {
        this((SimulationPopulation)iPopulation, n);
    }

    public void setExternalInits(Map<String, Object> map) {
        if (this.externalInitsAndParameters == null) {
            this.externalInitsAndParameters = map == null ? new HashMap<String, Object>() : new HashMap<String, Object>(map);
        } else if (map != null) {
            this.externalInitsAndParameters.putAll(map);
        }
    }

    public Map<String, Object> getExternalInits() {
        if (this.externalInitsAndParameters == null) {
            return Collections.EMPTY_MAP;
        }
        return this.externalInitsAndParameters;
    }

    public SimulationAgent(SimulationPopulation simulationPopulation, int n) throws GamaRuntimeException {
        super(simulationPopulation, n);
        this.ownClock = new SimulationClock(this.getScope());
        this.executer = new ActionExecuter(this.getScope());
        this.projectionFactory = new ProjectionFactory();
        this.random = new RandomUtils(simulationPopulation.getHost().getSeed(), simulationPopulation.getHost().getRng());
    }

    public Boolean getScheduled() {
        return this.scheduled;
    }

    @Override
    @GamlAnnotations.getter(value="experiment")
    public IExperimentAgent getExperiment() {
        IMacroAgent iMacroAgent = this.getHost();
        if (iMacroAgent instanceof IExperimentAgent) {
            return (IExperimentAgent)iMacroAgent;
        }
        return null;
    }

    @Override
    @GamlAnnotations.getter(value="world")
    public SimulationAgent getSimulation() {
        return this;
    }

    public void setTopology(RootTopology rootTopology) {
        if (this.topology != null) {
            this.topology.dispose();
        }
        this.topology = rootTopology;
    }

    public void setTopology(IScope iScope, IShape iShape) {
        boolean[] blArray = new boolean[]{GamaExecutorService.CONCURRENCY_SPECIES.getValue()};
        if (!blArray[0]) {
            this.getSpecies().getDescription().visitMicroSpecies(speciesDescription -> {
                blArray[0] = GamaExecutorService.getParallelism(iScope, speciesDescription.getFacetExpr("parallel"), GamaExecutorService.Caller.SPECIES) > 0;
                return !blArray[0];
            });
        }
        if (this.topology != null) {
            this.topology.updateEnvironment(iScope, iShape, blArray[0]);
        } else {
            IExpression iExpression = this.getSpecies().getFacet("torus");
            boolean bl = iExpression != null && Cast.asBool(iScope, iExpression.value(iScope)) != false;
            this.setTopology(new RootTopology(iScope, iShape, bl, blArray[0]));
        }
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        SimulationOutputManager simulationOutputManager = this.getOutputManager();
        if (simulationOutputManager != null) {
            simulationOutputManager.updateDisplayOutputsName(this);
        }
    }

    public void setScheduled(Boolean bl) {
        this.scheduled = bl;
    }

    @Override
    @GamlAnnotations.getter(value="color", initializer=true)
    public GamaColor getColor() {
        if (this.color == null) {
            this.color = GamaPreferences.Interface.getColorForSimulation(this.getIndex());
        }
        return this.color;
    }

    @Override
    public RootTopology getTopology() {
        return this.topology;
    }

    @GamlAnnotations.setter(value="color")
    public void setColor(GamaColor gamaColor) {
        this.color = gamaColor;
    }

    @Override
    public void schedule(IScope iScope) {
        super.schedule(this.getScope());
    }

    @Override
    protected boolean preStep(IScope iScope) {
        this.ownClock.beginCycle();
        this.executer.executeBeginActions();
        return super.preStep(iScope);
    }

    @Override
    protected void postStep(IScope iScope) {
        super.postStep(iScope);
        this.executer.executeEndActions();
        this.executer.executeOneShotActions();
        if (this.outputs != null) {
            this.outputs.step(this.getScope());
        }
        this.ownClock.step();
        GAMA.getBufferingController().flushSaveFilesInCycle(this);
        GAMA.getBufferingController().flushWriteInCycle(this);
    }

    @Override
    public Object _init_(IScope iScope) {
        super._init_(this.getScope());
        this.initOutputs();
        return this;
    }

    @Override
    public IScope getScope() {
        return this.ownScope;
    }

    public ProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    @Override
    public SimulationClock getClock() {
        return this.ownClock;
    }

    @Override
    public void dispose() {
        GAMA.getGui().getStatus().beginTask("Disposing " + String.valueOf(this), "status/status.simulation");
        if (this.dead) {
            return;
        }
        this.executer.executeDisposeActions();
        if (this.externMicroPopulations != null) {
            this.externMicroPopulations.clear();
        }
        GAMA.getGui().getStatus().beginTask("Disposing " + String.valueOf(this), "status/status.simulation");
        if (this.outputs != null) {
            this.outputs.dispose();
            this.outputs = null;
        }
        GAMA.getGui().getStatus().beginTask("Disposing " + String.valueOf(this), "status/status.simulation");
        if (this.topology != null) {
            if (!this.isMicroSimulation()) {
                this.topology.dispose();
                this.topology = null;
            } else {
                IPopulation<? extends IAgent>[] iPopulationArray = this.getMicroPopulations();
                int n = iPopulationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPopulation<? extends IAgent> iPopulation = iPopulationArray[n2];
                    this.topology.remove(iPopulation);
                    ++n2;
                }
            }
        }
        if (this.externalInitsAndParameters != null) {
            this.externalInitsAndParameters.clear();
        }
        GAMA.getBufferingController().flushSaveFilesOfAgent(this);
        GAMA.getBufferingController().flushWriteOfAgent(this);
        GAMA.releaseScope(this.getScope());
        GAMA.getGui().getStatus().beginTask("Disposing " + String.valueOf(this), "status/status.simulation");
        super.dispose();
    }

    public boolean isMicroSimulation() {
        return this.getSpecies().getDescription().belongsToAMicroModel();
    }

    @Override
    public GamaPoint setLocation(IScope iScope, GamaPoint gamaPoint) {
        return gamaPoint;
    }

    @Override
    public GamaPoint getLocation(IScope iScope) {
        if (this.geometry == null || this.geometry.getInnerGeometry() == null) {
            return new GamaPoint(0.0, 0.0);
        }
        return super.getLocation(iScope);
    }

    @Override
    public void setGeometry(IScope iScope, IShape iShape) {
        Object object;
        Object object2;
        IShape iShape2 = iShape;
        if (iShape2 == null) {
            iShape2 = GamaGeometryType.buildBox(100.0, 100.0, 100.0, new GamaPoint(50.0, 50.0, 50.0));
        } else {
            object2 = iShape2.getInnerGeometry();
            object = null;
            if (object2 != null) {
                object = object2.getUserData();
            }
            iShape2.setInnerGeometry((Geometry)iShape2.getEnvelope().toGeometry());
            iShape2.getInnerGeometry().setUserData(object);
        }
        object2 = iShape2.getEnvelope();
        if (this.getProjectionFactory().getWorld() == null) {
            this.projectionFactory.setWorldProjectionEnv(iScope, (Envelope3D)object2);
        }
        ((WorldProjection)this.getProjectionFactory().getWorld()).updateTranslations((Envelope3D)object2);
        ((WorldProjection)this.getProjectionFactory().getWorld()).updateUnit(this.getProjectionFactory().getUnitConverter());
        object = new GamaPoint(-object2.getMinX(), -object2.getMinY(), -((Envelope3D)object2).getMinZ());
        this.geometry.setGeometry(SpatialTransformations.translated_by(iScope, iShape2, (GamaPoint)object));
        if (this.getProjectionFactory().getUnitConverter() != null) {
            ((WorldProjection)this.getProjectionFactory().getWorld()).convertUnit(this.geometry.getInnerGeometry());
        }
        this.setTopology(iScope, this.geometry);
    }

    public SimulationPopulation getPopulation() {
        return (SimulationPopulation)this.population;
    }

    @Override
    public IPopulation<? extends IAgent> getPopulationFor(String string) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = super.getPopulationFor(string);
        if (iPopulation != null) {
            return iPopulation;
        }
        ISpecies iSpecies = this.getSpecies().getMicroSpecies(string);
        if (iSpecies == null) {
            return null;
        }
        IScope iScope = this.getScope();
        iPopulation = iScope.getPopulationFactory().createPopulation(iScope, this, iSpecies);
        this.setAttribute(string, iPopulation);
        iPopulation.initializeFor(iScope);
        return iPopulation;
    }

    @GamlAnnotations.getter(value="cycle")
    public Integer getCycle(IScope iScope) {
        SimulationClock simulationClock = this.getClock();
        if (simulationClock != null) {
            return simulationClock.getCycle();
        }
        return 0;
    }

    @GamlAnnotations.getter(value="paused")
    public boolean isPaused(IScope iScope) {
        return this.getScope().isPaused();
    }

    @GamlAnnotations.setter(value="paused")
    public void setPaused(IScope iScope, boolean bl) {
    }

    @Override
    public boolean isOnUserHold() {
        return this.isOnUserHold;
    }

    @Override
    public void setOnUserHold(boolean bl) {
        this.isOnUserHold = bl;
    }

    @GamlAnnotations.getter(value="step", initializer=true)
    public double getTimeStep(IScope iScope) {
        SimulationClock simulationClock = this.getClock();
        if (simulationClock != null) {
            return simulationClock.getStepInSeconds();
        }
        return 1.0;
    }

    @GamlAnnotations.setter(value="step")
    public void setTimeStep(IScope iScope, double d) throws GamaRuntimeException {
        SimulationClock simulationClock = this.getClock();
        if (simulationClock != null) {
            simulationClock.setStep(d);
        }
    }

    @GamlAnnotations.getter(value="time")
    public double getTime(IScope iScope) {
        SimulationClock simulationClock = this.getClock();
        if (simulationClock != null) {
            return simulationClock.getTimeElapsedInSeconds();
        }
        return 0.0;
    }

    @GamlAnnotations.setter(value="time")
    public void setTime(IScope iScope, double d) throws GamaRuntimeException {
    }

    @GamlAnnotations.getter(value="duration")
    public String getDuration() {
        return Long.toString(this.getClock().getDuration());
    }

    @GamlAnnotations.getter(value="total_duration")
    public String getTotalDuration() {
        return Long.toString(this.getClock().getTotalDuration());
    }

    @GamlAnnotations.getter(value="average_duration")
    public String getAverageDuration() {
        return Double.toString(this.getClock().getAverageDuration());
    }

    @GamlAnnotations.setter(value="current_date")
    public void setCurrentDate(GamaDate gamaDate) throws GamaRuntimeException {
    }

    @GamlAnnotations.getter(value="current_date")
    public GamaDate getCurrentDate() {
        return this.ownClock.getCurrentDate();
    }

    @GamlAnnotations.setter(value="starting_date")
    public void setStartingDate(GamaDate gamaDate) throws GamaRuntimeException {
        this.ownClock.setStartingDate(gamaDate);
    }

    @GamlAnnotations.getter(value="starting_date", initializer=true)
    public GamaDate getStartingDate() {
        return this.ownClock.getStartingDate();
    }

    @GamlAnnotations.action(name="pause", doc={@GamlAnnotations.doc(value="Allows to pause the current simulation **ACTUALLY EXPERIMENT FOR THE MOMENT**. It can be resumed with the manual intervention of the user or the 'resume' action.")})
    public Object pause(IScope iScope) {
        IExperimentController iExperimentController = iScope.getExperiment().getSpecies().getController();
        if (iExperimentController != null && !iExperimentController.isPaused()) {
            iExperimentController.processPause(!GAMA.getGui().isInDisplayThread());
        }
        return null;
    }

    @GamlAnnotations.action(name="resume", doc={@GamlAnnotations.doc(value="Allows to resume the current simulation **ACTUALLY EXPERIMENT FOR THE MOMENT**. It can then be paused with the manual intervention of the user or the 'pause' action.")})
    public Object resume(IScope iScope) {
        IExperimentController iExperimentController = iScope.getExperiment().getSpecies().getController();
        if (iExperimentController != null && iExperimentController.isPaused()) {
            iExperimentController.processStart(false);
        }
        return null;
    }

    public String getShortUserFriendlyName() {
        return this.getName();
    }

    public String buildPostfix() {
        boolean bl;
        boolean bl2 = bl = GamaPreferences.Interface.CORE_SIMULATION_NAME.getValue() == false;
        if (!bl) {
            return " (" + this.getName() + ")";
        }
        if (this.getPopulation().size() > 1) {
            return " (S" + this.getIndex() + ")";
        }
        return "";
    }

    public void setOutputs(IOutputManager iOutputManager) {
        if (iOutputManager == null) {
            return;
        }
        IDescription iDescription = ((ISymbol)((Object)iOutputManager)).getDescription();
        if (iDescription == null) {
            return;
        }
        this.outputs = (SimulationOutputManager)iDescription.compile();
        IMap iMap = GamaMapFactory.create();
        this.outputs.forEach((string, iOutput) -> {
            String string2;
            String string3;
            if (!this.scheduled.booleanValue()) {
                string2 = string3 = iOutput.getName() + "#" + this.getSpecies().getDescription().getModelDescription().getAlias() + "#" + this.getExperiment().getSpecies().getName() + "#" + this.getExperiment().getIndex();
            } else {
                String string4 = this.buildPostfix();
                string3 = string + string4;
                string2 = iOutput.getName() + string4;
            }
            iMap.put(string3, iOutput);
            iOutput.setName(string2);
        });
        this.outputs.clear();
        this.outputs.putAll(iMap);
    }

    @Override
    public SimulationOutputManager getOutputManager() {
        return this.outputs;
    }

    public void addOutput(IOutput iOutput) {
        this.outputs.add(iOutput);
    }

    @GamlAnnotations.getter(value="rng_usage", initializer=false)
    public Integer getUsage() {
        Integer n = this.random.getUsage();
        return n == null ? 0 : n;
    }

    @GamlAnnotations.setter(value="rng_usage")
    public void setUsage(Integer n) {
        Integer n2 = n;
        if (n == null) {
            n2 = 0;
        }
        this.getRandomGenerator().setUsage(n2);
    }

    @GamlAnnotations.getter(value="seed", initializer=true)
    public Double getSeed() {
        Double d = this.random.getSeed();
        return d == null ? 0.0 : d;
    }

    @GamlAnnotations.setter(value="seed")
    public void setSeed(Double d) {
        Double d2 = d == null || d == 0.0 ? null : d;
        this.getRandomGenerator().setSeed(d2, true);
    }

    @GamlAnnotations.getter(value="rng", initializer=true)
    public String getRng() {
        return this.getRandomGenerator().getRngName();
    }

    @GamlAnnotations.setter(value="rng")
    public void setRng(String string) {
        this.getRandomGenerator().setGenerator(string, true);
    }

    @Override
    public RandomUtils getRandomGenerator() {
        return this.random;
    }

    public void setRandomGenerator(RandomUtils randomUtils) {
        this.random = randomUtils;
    }

    public void initOutputs() {
        if (this.outputs != null) {
            this.outputs.init(this.getScope());
        }
    }

    @Override
    public void postEndAction(IExecutable iExecutable) {
        this.executer.insertEndAction(iExecutable);
    }

    @Override
    public void postDisposeAction(IExecutable iExecutable) {
        this.executer.insertDisposeAction(iExecutable);
    }

    @Override
    public void postOneShotAction(IExecutable iExecutable) {
        this.executer.insertOneShotAction(iExecutable);
    }

    @Override
    public void executeAction(IExecutable iExecutable) {
        this.executer.executeOneAction(iExecutable);
    }

    @Override
    public void updateWith(IScope iScope, ISerialisedAgent iSerialisedAgent) {
        Double d = null;
        String string = null;
        Integer n = null;
        ArrayList<IReference> arrayList = new ArrayList<IReference>();
        Map<String, Object> map = iSerialisedAgent.attributes();
        for (String object2 : map.keySet()) {
            Object object2 = map.get(object2);
            boolean bl = IReference.isReference(object2);
            boolean iPopulation = object2 instanceof ISerialisedPopulation;
            if (iPopulation) continue;
            if (bl) {
                ((IReference)object2).setAgentAndAttrName(this, object2);
                if (!arrayList.contains(object2)) {
                    arrayList.add((IReference)object2);
                }
            }
            switch (object2) {
                case "seed": {
                    d = (Double)object2;
                    break;
                }
                case "rng": {
                    string = (String)object2;
                    break;
                }
                case "rng_usage": {
                    n = (Integer)object2;
                    break;
                }
                default: {
                    this.setDirectVarValue(iScope, object2, object2);
                }
            }
        }
        this.setRandomGenerator(new RandomUtils(d, string));
        this.setUsage(n);
        Object object = iSerialisedAgent.getAttributeValue("cycle");
        this.ownClock.setCycleNoCheck((Integer)object);
        Map<String, ISerialisedPopulation> map2 = iSerialisedAgent.innerPopulations();
        if (map2 != null) {
            for (Object object2 : map2.keySet()) {
                IPopulation<? extends IAgent> iPopulation = this.getPopulationFor((String)object2);
                if (iPopulation == null) continue;
                Object object3 = GamaMapFactory.createUnordered();
                for (ISerialisedAgent iSerialisedAgent2 : ((ISerialisedPopulation)map2.get(object2)).agents()) {
                    object3.put((String)iSerialisedAgent2.getAttributeValue("name"), iSerialisedAgent2);
                }
                IMap iMap = GamaMapFactory.createUnordered();
                Object object4 = iPopulation.toArray();
                int n2 = ((IAgent[])object4).length;
                int n3 = 0;
                while (n3 < n2) {
                    Map.Entry entry = object4[n3];
                    iMap.put(entry.getName(), entry);
                    ++n3;
                }
                for (Map.Entry entry : object3.entrySet()) {
                    IAgent iAgent = (IAgent)iMap.get(entry.getKey());
                    if (iAgent != null) {
                        iAgent.updateWith(iScope, (ISerialisedAgent)entry.getValue());
                        iMap.remove(entry.getKey());
                    } else {
                        iPopulation.createAgentAt(iScope, ((ISerialisedAgent)entry.getValue()).getIndex(), ((ISerialisedAgent)entry.getValue()).attributes(), true, true);
                    }
                    object4 = iAgent == null ? iPopulation.getAgent(((ISerialisedAgent)entry.getValue()).getIndex()) : iAgent;
                    for (String string2 : ((ISerialisedAgent)entry.getValue()).attributes().keySet()) {
                        Object object5 = ((ISerialisedAgent)entry.getValue()).getAttributeValue(string2);
                        boolean bl = IReference.isReference(object5);
                        if (!bl) continue;
                        ((IReference)object5).setAgentAndAttrName((IAgent)object4, string2);
                        if (arrayList.contains(object5)) continue;
                        arrayList.add((IReference)object5);
                    }
                }
                for (Map.Entry entry : iMap.values()) {
                    entry.dispose();
                }
            }
        }
        this.updateReferences(iScope, arrayList);
    }

    private void updateReferences(IScope iScope, List<IReference> list) {
        for (IReference iReference : list) {
            iReference.resolveReferences(iScope, this);
        }
    }

    public void adoptTopologyOf(SimulationAgent simulationAgent) {
        RootTopology rootTopology = simulationAgent.getTopology();
        rootTopology.mergeWith(this.topology);
        this.setTopology(rootTopology);
        IPopulation<? extends IAgent>[] iPopulationArray = this.getMicroPopulations();
        int n = iPopulationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPopulation<? extends IAgent> iPopulation = iPopulationArray[n2];
            iPopulation.getTopology().setRoot(simulationAgent.getScope(), rootTopology);
            ++n2;
        }
    }

    public <T> Map<SimulationLocal<T>, T> getSimulationLocalMap() {
        return this.simulationLocalMap;
    }

    public <T> void setSimulationLocalMap(Map<SimulationLocal<T>, T> map) {
        this.simulationLocalMap = map;
    }

    @Override
    public String getFamilyName() {
        return "simulation";
    }

    @Override
    public boolean isSimulation() {
        return true;
    }
}

