/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.benchmark;

import gama.core.common.interfaces.IBenchmarkable;
import gama.core.runtime.benchmark.Benchmark;
import gama.core.runtime.benchmark.BenchmarkRecord;
import gama.core.util.tree.GamaTree;
import gama.dev.DEBUG;
import gama.gaml.operators.Strings;

public class BenchmarkConsolePrinter {
    static final String S = "\n------------------------------------------------\n";

    public void print(Benchmark benchmark) {
        StringBuilder stringBuilder = new StringBuilder();
        benchmark.forEach((iScope, scopeRecord) -> {
            BenchmarkRecord benchmarkRecord = scopeRecord.ownRecord;
            stringBuilder.append(S).append(benchmarkRecord.object.getNameForBenchmarks()).append(" (").append(benchmarkRecord.milliseconds).append(" ms)").append(S);
            benchmark.tree.visit(GamaTree.Order.PRE_ORDER, gamaNode -> {
                BenchmarkRecord benchmarkRecord = scopeRecord.find((IBenchmarkable)gamaNode.getData());
                if (benchmarkRecord != BenchmarkRecord.NULL && !benchmarkRecord.isUnrecorded()) {
                    stringBuilder.append(Strings.LN).append(String.format("%30s", "[" + String.valueOf(benchmarkRecord.milliseconds) + " ms, " + String.valueOf(benchmarkRecord.times) + " calls] "));
                    int n = 0;
                    while (n < gamaNode.getWeight()) {
                        stringBuilder.append("-\t");
                        ++n;
                    }
                    stringBuilder.append(' ').append(benchmarkRecord.object.getNameForBenchmarks());
                }
            });
            stringBuilder.append(Strings.LN);
        });
        DEBUG.LOG((Object)stringBuilder.toString());
    }
}

