/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.common.interfaces.IConsoleListener;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.runtime.GAMA;
import gama.core.runtime.server.CommandExecutor;
import gama.core.runtime.server.GamaServerConsoleListener;
import gama.core.runtime.server.GamaServerExperimentConfiguration;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.IGamaServer;
import gama.core.runtime.server.ISocketCommand;
import gama.core.runtime.server.MessageType;
import gama.core.runtime.server.ReceivedMessage;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.dev.DEBUG;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ListenerList;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public abstract class GamaWebSocketServer
extends WebSocketServer
implements IGamaServer {
    static final String SOCKET_ID = "socket_id";
    protected final CommandExecutor cmdHelper = new CommandExecutor();
    public final boolean canPing;
    public final int pingInterval;
    protected final Map<WebSocket, Timer> pingTimers = new HashMap<WebSocket, Timer>();
    protected Json jsonErr = Json.getNew();
    protected final IConsoleListener console = new GamaServerConsoleListener();
    protected final ListenerList<IGamaServer.Listener> listeners = new ListenerList(1);

    protected GamaWebSocketServer(int n, int n2) {
        super(new InetSocketAddress(n));
        this.setReuseAddr(true);
        this.canPing = n2 >= 0;
        this.pingInterval = n2;
        this.configureErrorStream();
    }

    @Override
    public void addListener(IGamaServer.Listener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IGamaServer.Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private void configureErrorStream() {
        PrintStream printStream = new PrintStream(System.err){

            @Override
            public void println(String string) {
                super.println(string);
                GamaWebSocketServer.this.broadcast(GamaWebSocketServer.this.jsonErr.valueOf(new GamaServerMessage(MessageType.GamaServerError, string)).toString());
            }
        };
        System.setErr(printStream);
    }

    public static String getSocketId(WebSocket webSocket) {
        return String.valueOf(webSocket.hashCode());
    }

    public void onStart() {
        DEBUG.BANNER((String)"GAMA", (String)"Server started", (String)"at port", (String)("" + this.getPort()));
    }

    public void onOpen(final WebSocket webSocket, ClientHandshake clientHandshake) {
        webSocket.send(Json.getNew().valueOf(new GamaServerMessage(MessageType.ConnectionSuccessful, String.valueOf(webSocket.hashCode()))).toString());
        if (this.canPing) {
            Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (webSocket.isOpen()) {
                        webSocket.sendPing();
                    }
                }
            }, 0L, (long)this.pingInterval);
            this.pingTimers.put(webSocket, timer);
        }
    }

    public void onClose(WebSocket webSocket, int n, String string, boolean bl) {
        Timer timer = this.pingTimers.remove(webSocket);
        if (timer != null) {
            timer.cancel();
        }
        this.listeners.clear();
    }

    public ReceivedMessage extractParam(WebSocket webSocket, String string) {
        try {
            ReceivedMessage receivedMessage;
            Object object = Json.getNew().parse(string).toGamlValue(GAMA.getRuntimeScope());
            if (object instanceof IMap) {
                IMap iMap = (IMap)object;
                receivedMessage = new ReceivedMessage(string, iMap);
            } else {
                receivedMessage = new ReceivedMessage(string, Map.of("contents", object));
            }
            ReceivedMessage receivedMessage2 = receivedMessage;
            receivedMessage2.put("server", this);
            return receivedMessage2;
        }
        catch (Exception exception) {
            DEBUG.OUT((Object)exception.toString());
            webSocket.send(this.jsonErr.valueOf(new GamaServerMessage(MessageType.MalformedRequest, exception)).toString());
            return null;
        }
    }

    public void onMessage(WebSocket webSocket, String string) {
        try {
            Object object2;
            ReceivedMessage receivedMessage = this.extractParam(webSocket, string);
            for (Object object2 : this.listeners) {
                if (object2.process(receivedMessage)) continue;
                return;
            }
            object2 = receivedMessage.getOrDefault("exp_id", "").toString();
            String string2 = receivedMessage.getOrDefault(SOCKET_ID, GamaWebSocketServer.getSocketId(webSocket)).toString();
            IExperimentPlan iExperimentPlan = this.getExperiment(string2, (String)object2);
            if (iExperimentPlan != null) {
                this.processInSyncWithExperiment(webSocket, receivedMessage, iExperimentPlan);
            } else {
                this.cmdHelper.process(this, webSocket, receivedMessage);
            }
        }
        catch (Exception exception) {
            DEBUG.OUT((Object)exception);
            webSocket.send(this.jsonErr.valueOf(new GamaServerMessage(MessageType.GamaServerError, exception)).toString());
        }
    }

    private void processInSyncWithExperiment(WebSocket webSocket, ReceivedMessage receivedMessage, IExperimentPlan iExperimentPlan) {
        ExperimentAgent experimentAgent = iExperimentPlan.getAgent();
        if (experimentAgent == null || iExperimentPlan.getController().isPaused()) {
            this.cmdHelper.process(this, webSocket, receivedMessage);
        } else {
            experimentAgent.postOneShotAction(iScope -> {
                this.cmdHelper.process(this, webSocket, receivedMessage);
                return null;
            });
        }
    }

    public void onError(WebSocket webSocket, Exception exception) {
        exception.printStackTrace();
    }

    @Override
    public abstract IExperimentPlan getExperiment(String var1, String var2);

    @Override
    public abstract void execute(Runnable var1);

    @Override
    public abstract void addExperiment(String var1, String var2, IExperimentPlan var3);

    @Override
    public abstract GamaServerExperimentConfiguration obtainGuiServerConfiguration();

    @Override
    public abstract IExperimentPlan retrieveExperimentPlan(WebSocket var1, IMap<String, Object> var2) throws ISocketCommand.CommandException;
}

