/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaFile;
import gama.core.util.file.GamaFileMetaData;
import gama.core.util.file.IFieldMatrixProvider;
import gama.core.util.file.IFileMetaDataProvider;
import gama.core.util.file.csv.CsvReader;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

@GamlAnnotations.file(name="csv", extensions={"csv", "tsv"}, buffer_type=8, buffer_index=7, concept={"csv", "file"}, doc={@GamlAnnotations.doc(value="A type of text file that contains comma-separated values")})
public class GamaCSVFile
extends GamaFile<IMatrix<Object>, Object>
implements IFieldMatrixProvider {
    String csvSeparator = null;
    Character textQualifier = Character.valueOf('\"');
    IType contentsType;
    GamaPoint userSize;
    Boolean hasHeader;
    IList<String> headers;
    CSVInfo info;

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file with the default separator (coma), no header, and no assumption on the type of data. No text qualifier will be used", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\");", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string) throws GamaRuntimeException {
        this(iScope, string, (String)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file with the default separator (coma), with specifying if the model has a header or not (boolean), and no assumption on the type of data. No text qualifier will be used", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\",true);", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, Boolean bl) {
        this(iScope, string);
        this.hasHeader = bl;
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file and specify the separator used, without making any assumption on the type of data. Headers should be detected automatically if they exist. No text qualifier will be used", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\", \";\");", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, String string2) {
        this(iScope, string, string2, (IType)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file and specify (1) the separator used; (2) if the model has a header or not, without making any assumption on the type of data. No text qualifier will be used", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\", \";\",true);", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, String string2, Boolean bl) {
        this(iScope, string, string2, (IType)null);
        this.hasHeader = bl;
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file and specify (1) the separator used; (2) the text qualifier used; (3) if the model has a header or not, without making any assumption on the type of data", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\", ';', '\"', true);", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, String string2, String string3, Boolean bl) {
        this(iScope, string, string2, (IType)null);
        this.textQualifier = string3 == null || string3.isEmpty() ? null : Character.valueOf(string3.charAt(0));
        this.hasHeader = bl;
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file with a given separator, no header, and the type of data. No text qualifier will be used", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\", \";\",int);", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, String string2, IType iType) {
        this(iScope, string, string2, iType, (Boolean)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file and specify the separator, text qualifier to use, and the type of data to read.  Headers should be detected automatically if they exist.  ", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\", ';', '\"', int);", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, String string2, String string3, IType iType) {
        this(iScope, string, string2, iType, (Boolean)null);
        this.textQualifier = string3 == null || string3.isEmpty() ? null : Character.valueOf(string3.charAt(0));
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file with a given separator, the type of data, with specifying if the model has a header or not (boolean). No text qualifier will be used", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\", \";\",int,true);", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, String string2, IType iType, Boolean bl) {
        this(iScope, string, string2, iType, (GamaPoint)null);
        this.hasHeader = bl;
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a CSV file with a given separator, the type of data, with specifying the number of cols and rows taken into account. No text qualifier will be used", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\", \";\",int,true, {5, 100});", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, String string2, IType iType, GamaPoint gamaPoint) {
        super(iScope, string);
        this.setCsvSeparators(string2);
        this.contentsType = iType;
        this.userSize = gamaPoint;
    }

    @GamlAnnotations.doc(value="This file constructor allows to store a matrix in a CSV file (it does not save it - just store it in memory),", examples={@GamlAnnotations.example(value="csv_file f <- csv_file(\"file.csv\", matrix([10,10],[10,10]));", isExecutable=false)})
    public GamaCSVFile(IScope iScope, String string, IMatrix<Object> iMatrix) {
        super(iScope, string, iMatrix);
        if (iMatrix != null) {
            this.userSize = iMatrix.getDimensions();
            this.contentsType = iMatrix.getGamlType().getContentType();
        }
    }

    public void setCsvSeparators(String string) {
        if (string == null) {
            return;
        }
        if (string.length() >= 1) {
            this.csvSeparator = string;
        }
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        CSVInfo cSVInfo;
        if (this.getBuffer() == null && (cSVInfo = this.getInfo(iScope, null)) != null) {
            return cSVInfo.header ? GamaListFactory.wrap((IType)Types.STRING, cSVInfo.headers) : GamaListFactory.EMPTY_LIST;
        }
        this.fillBuffer(iScope);
        return this.headers == null ? GamaListFactory.EMPTY_LIST : this.headers;
    }

    public CSVInfo getInfo(IScope iScope, String string) {
        Object object;
        if (this.info != null) {
            return this.info;
        }
        IFileMetaDataProvider iFileMetaDataProvider = iScope.getGui().getMetaDataProvider();
        if (iFileMetaDataProvider != null && (object = iFileMetaDataProvider.getMetaData(this.getFile(iScope), false, true)) instanceof CSVInfo) {
            this.info = (CSVInfo)object;
            if (string != null && this.info != null && !this.info.delimiter.equals(Character.valueOf(string.charAt(0)))) {
                this.info = null;
            }
        }
        if (this.info == null) {
            this.info = new CSVInfo(this.getFile(iScope).getAbsolutePath(), 0L, string);
        }
        if (this.hasHeader != null && this.hasHeader.booleanValue()) {
            if (!this.info.header) {
                try {
                    object = null;
                    Object var5_6 = null;
                    try (CsvReader csvReader = new CsvReader(this.getPath(iScope), this.info.delimiter.charValue());){
                        if (csvReader.readHeaders()) {
                            this.info.headers = csvReader.getHeaders();
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException iOException) {}
            }
            this.info.header = this.hasHeader;
        }
        return this.info;
    }

    @Override
    public void fillBuffer(IScope iScope) {
        Object object;
        if (this.getBuffer() != null) {
            return;
        }
        if (this.csvSeparator == null || this.contentsType == null || this.userSize == null) {
            iScope.getGui().getStatus().beginTask("Opening file " + this.getName(iScope), "status/status.download");
            object = this.getInfo(iScope, this.csvSeparator);
            this.csvSeparator = this.csvSeparator == null ? String.valueOf(((CSVInfo)object).delimiter) : this.csvSeparator;
            IType iType = this.contentsType = this.contentsType == null ? ((CSVInfo)object).type : this.contentsType;
            if (this.userSize == null) {
                this.userSize = new GamaPoint(((CSVInfo)object).cols, ((CSVInfo)object).rows);
            }
            this.hasHeader = this.hasHeader == null ? ((CSVInfo)object).header : this.hasHeader;
            iScope.getGui().getStatus().endTask("", "status/status.download");
        }
        try {
            try {
                object = null;
                Object var3_5 = null;
                try (CsvReader csvReader = new CsvReader(this.getPath(iScope), this.csvSeparator.charAt(0));){
                    csvReader.setTextQualifier(this.textQualifier);
                    if (this.hasHeader.booleanValue()) {
                        csvReader.readHeaders();
                        this.headers = GamaListFactory.createWithoutCasting((IType)Types.STRING, csvReader.getHeaders());
                        this.userSize.y -= 1.0;
                        this.userSize.x = this.headers.size();
                    }
                    this.setBuffer(this.createMatrixFrom(iScope, csvReader));
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.create(iOException, iScope);
            }
        }
        finally {
            if (this.hasHeader != null && this.hasHeader.booleanValue()) {
                this.userSize.y = this.userSize.y + 1.0;
            }
        }
    }

    @Override
    public IContainerType getGamlType() {
        IType<?> iType = this.getBuffer() == null ? Types.NO_TYPE : ((IMatrix)this.getBuffer()).getGamlType().getContentType();
        return Types.FILE.of(iType);
    }

    private IMatrix createMatrixFrom(IScope iScope, CsvReader csvReader) throws IOException {
        int n = this.contentsType.id();
        double d = 0.0;
        try {
            GamaMatrix gamaMatrix;
            String string = "Reading file " + this.getName(iScope);
            iScope.getGui().getStatus().beginTask(string, "status/status.download");
            if (n == 1) {
                gamaMatrix = new GamaIntMatrix(this.userSize);
                int[] nArray = ((GamaIntMatrix)gamaMatrix).getMatrix();
                int n2 = 0;
                while (csvReader.readRecord()) {
                    d = (double)csvReader.getCurrentRecord() / this.userSize.y;
                    iScope.getGui().getStatus().setTaskCompletion(string, d);
                    int n3 = 0;
                    String[] stringArray = csvReader.getValues();
                    int n4 = stringArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String string2 = stringArray[n5];
                        nArray[n2++] = Cast.asInt(iScope, string2);
                        ++n3;
                        ++n5;
                    }
                    while (n3 < gamaMatrix.getCols(null)) {
                        nArray[n2++] = 0;
                        ++n3;
                    }
                }
            } else if (n == 2) {
                gamaMatrix = new GamaFloatMatrix(this.userSize);
                double[] dArray = ((GamaFloatMatrix)gamaMatrix).getMatrix();
                int n6 = 0;
                while (csvReader.readRecord()) {
                    d = (double)csvReader.getCurrentRecord() / this.userSize.y;
                    iScope.getGui().getStatus().setTaskCompletion(string, d);
                    int n7 = 0;
                    String[] stringArray = csvReader.getValues();
                    int n8 = stringArray.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        String string3 = stringArray[n9];
                        dArray[n6++] = Cast.asFloat(iScope, string3);
                        ++n7;
                        ++n9;
                    }
                    while (n7 < gamaMatrix.getCols(null)) {
                        dArray[n6++] = 0.0;
                        ++n7;
                    }
                }
            } else {
                gamaMatrix = new GamaObjectMatrix(this.userSize, Types.STRING);
                Object[] objectArray = ((GamaObjectMatrix)gamaMatrix).getMatrix();
                int n10 = 0;
                while (csvReader.readRecord()) {
                    d = (double)csvReader.getCurrentRecord() / this.userSize.y;
                    iScope.getGui().getStatus().setTaskCompletion(string, d);
                    int n11 = 0;
                    String[] stringArray = csvReader.getValues();
                    int n12 = stringArray.length;
                    int n13 = 0;
                    while (n13 < n12) {
                        String string4 = stringArray[n13];
                        if (n10 == objectArray.length) {
                            GAMA.reportError(iScope, GamaRuntimeException.warning("The file " + this.getFile(iScope).getName() + " seems to contain data that have not been processed", iScope), false);
                            break;
                        }
                        ++n11;
                        objectArray[n10++] = string4;
                        ++n13;
                    }
                    while (n11 < gamaMatrix.getCols(null)) {
                        objectArray[n10++] = null;
                        ++n11;
                    }
                }
            }
            GamaMatrix gamaMatrix2 = gamaMatrix;
            return gamaMatrix2;
        }
        finally {
            iScope.getGui().getStatus().endTask("Reading CSV File", "status/status.download");
        }
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        return null;
    }

    public void forceHeader(Boolean bl) {
        this.hasHeader = bl;
    }

    public Boolean hasHeader(IScope iScope) {
        this.fillBuffer(iScope);
        return this.hasHeader == null ? false : this.hasHeader;
    }

    @Override
    public int getRows(IScope iScope) {
        return this.getInfo((IScope)iScope, null).rows;
    }

    @Override
    public int getCols(IScope iScope) {
        return this.getInfo((IScope)iScope, null).cols;
    }

    @Override
    public double[] getBand(IScope iScope, int n) {
        if (n > 0) {
            return null;
        }
        GamaFloatMatrix gamaFloatMatrix = (GamaFloatMatrix)GamaMatrixType.from(iScope, (IMatrix)this.getContents(iScope), Types.FLOAT, null, false);
        return gamaFloatMatrix.getMatrix();
    }

    public static class CSVInfo
    extends GamaFileMetaData {
        public int cols;
        public int rows;
        public boolean header;
        public boolean atLeastOneNumber;
        public Character delimiter;
        public IType type;
        public IType firstLineType;
        public String[] headers;

        public CSVInfo(String string, long l, String string2) {
            super(l);
            try {
                Throwable throwable = null;
                Object var6_6 = null;
                try (CsvReader csvReader = new CsvReader(string);){
                    this.process(csvReader, string2);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }

        public void process(CsvReader csvReader, String string) {
            boolean bl = false;
            try {
                String string2 = csvReader.skipLine();
                this.headers = this.processFirstLine(string2, string);
                bl = this.atLeastOneNumber;
                this.atLeastOneNumber = false;
                csvReader.setDelimiter(this.delimiter.charValue());
                if (!csvReader.readRecord()) {
                    this.type = this.firstLineType;
                    this.rows = 1;
                } else {
                    this.type = this.processRecord(csvReader.getValues());
                }
                while (csvReader.readRecord()) {
                    if (csvReader.columnsCount <= this.cols) continue;
                    this.cols = csvReader.columnsCount;
                }
            }
            catch (IOException iOException) {}
            if (!this.type.equals(this.firstLineType) || !bl && this.atLeastOneNumber) {
                this.header = true;
                this.cols = this.headers.length;
            }
            this.rows = (int)csvReader.currentRecord + 1;
            csvReader.close();
        }

        private String[] processFirstLine(String string, String string2) {
            String[] stringArray;
            this.delimiter = string2 != null && !string2.isEmpty() ? Character.valueOf(string2.charAt(0)) : ((stringArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)string, (String)",")).length != 1 || stringArray[0].indexOf(32) == -1 && stringArray[0].indexOf(59) == -1 && stringArray[0].indexOf(9) == -1 ? Character.valueOf(',') : ((stringArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)string, (String)";")).length == 1 ? ((stringArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)string, (String)"\t")).length == 1 ? ((stringArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)string, (String)" ")).length == 1 ? Character.valueOf('|') : Character.valueOf(' ')) : Character.valueOf('\t')) : Character.valueOf(';')));
            stringArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)string, (String)this.delimiter.toString());
            this.firstLineType = this.processRecord(stringArray);
            return stringArray;
        }

        private IType processRecord(String[] stringArray) {
            if (stringArray.length > this.cols) {
                this.cols = stringArray.length;
            }
            IType iType = null;
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                StringAnalysis stringAnalysis = new StringAnalysis(string);
                boolean bl = this.atLeastOneNumber = stringAnalysis.isFloat || stringAnalysis.isInt || stringAnalysis.isNumberSequence;
                if (stringAnalysis.isInt) {
                    if (iType == null) {
                        iType = Types.INT;
                    }
                } else if (stringAnalysis.isFloat) {
                    if (iType == null || iType == Types.INT) {
                        iType = Types.FLOAT;
                    }
                } else {
                    iType = Types.NO_TYPE;
                }
                ++n2;
            }
            if (iType == null) {
                iType = Types.NO_TYPE;
            }
            return iType;
        }

        public CSVInfo(String string) {
            super(string);
            String[] stringArray = this.split(string);
            this.cols = Integer.parseInt(stringArray[1]);
            this.rows = Integer.parseInt(stringArray[2]);
            this.header = Boolean.parseBoolean(stringArray[3]);
            this.delimiter = Character.valueOf(stringArray[4].charAt(0));
            this.type = Types.get(stringArray[5]);
            if (this.header) {
                this.headers = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[6], (String)"@%@");
            } else {
                this.headers = new String[this.cols];
                Arrays.fill(this.headers, "");
            }
        }

        @Override
        public IGamlDescription.Doc getDocumentation() {
            IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc();
            regularDoc.append("CSV File ").append(this.header ? "with header" : "no header").append(Strings.LN);
            regularDoc.append("Dimensions: ").append(this.cols + " columns x " + (this.header ? this.rows - 1 : this.rows) + " rows").append(Strings.LN);
            regularDoc.append("Delimiter: ").append(this.delimiter).append(Strings.LN).append("Contents type: ").append(this.type.toString()).append(Strings.LN);
            if (this.header && this.headers != null) {
                regularDoc.append("Headers: ");
                String[] stringArray = this.headers;
                int n = this.headers.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    regularDoc.append(string).append(" | ");
                    ++n2;
                }
            }
            return regularDoc;
        }

        @Override
        public String getSuffix() {
            return this.cols + "x" + (this.header ? this.rows - 1 : this.rows) + " | " + (this.header ? "with header" : "no header") + " | delimiter: '" + String.valueOf(this.delimiter) + "' | " + String.valueOf(this.type);
        }

        @Override
        public void appendSuffix(StringBuilder stringBuilder) {
            stringBuilder.append(this.cols).append("x").append(this.rows).append(" | ");
            stringBuilder.append(this.header ? "with header" : "no header").append(" | ");
            stringBuilder.append("delimiter: '").append(this.delimiter).append("'").append(" | ").append(this.type);
        }

        @Override
        public String toPropertyString() {
            return super.toPropertyString() + "_!_" + this.cols + "_!_" + this.rows + "_!_" + this.header + "_!_" + String.valueOf(this.delimiter) + "_!_" + String.valueOf(this.type) + (String)(this.header ? "_!_" + String.join((CharSequence)"@%@", this.headers) : "");
        }
    }

    private static class StringAnalysis {
        boolean isFloat = true;
        boolean isInt = true;
        boolean isNumberSequence = true;

        StringAnalysis(String string) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                boolean bl = Character.isDigit(c);
                if (!bl) {
                    if (c == '.') {
                        this.isInt = false;
                    } else {
                        if (Character.isLetter(c)) {
                            this.isInt = false;
                            this.isFloat = false;
                            this.isNumberSequence = false;
                            break;
                        }
                        if (c == ',' || c == ';' || c == '|' || c == ':' || c == '/' || Character.isWhitespace(c) || c == '\"') {
                            this.isInt = false;
                            this.isFloat = false;
                        }
                    }
                }
                ++n2;
            }
            if (this.isInt && this.isFloat) {
                this.isFloat = false;
            }
        }
    }
}

