/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaFile;
import gama.gaml.operators.Strings;
import gama.gaml.statements.Facets;
import gama.gaml.types.IContainerType;
import gama.gaml.types.Types;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

@GamlAnnotations.file(name="text", extensions={"txt", "data", "text"}, buffer_type=5, buffer_content=4, buffer_index=1, concept={"file", "text", "csv", "xml"}, doc={@GamlAnnotations.doc(value="Represents an arbitrary text file. The internal contents is a list of strings (lines)")})
public class GamaTextFile
extends GamaFile<IList<String>, String> {
    @GamlAnnotations.doc(value="This file constructor allows to read a text file (.txt, .data, .text)", examples={@GamlAnnotations.example(value="file f <-text_file(\"file.txt\");", isExecutable=false)})
    public GamaTextFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    @GamlAnnotations.doc(value="This file constructor allows to store a list of string in a text file (it does not save it - just store it in memory)", examples={@GamlAnnotations.example(value="file f <-text_file(\"file.txt\", [\"item1\",\"item2\",\"item3\"]);", isExecutable=false)})
    public GamaTextFile(IScope iScope, String string, IList<String> iList) {
        super(iScope, string, iList);
    }

    @Override
    public IContainerType<?> getGamlType() {
        return Types.FILE.of(Types.INT, Types.STRING);
    }

    @Override
    public String _stringValue(IScope iScope) throws GamaRuntimeException {
        this.getContents(iScope);
        StringBuilder stringBuilder = new StringBuilder(((IList)this.getBuffer()).length(iScope) * 200);
        for (String string : ((IList)this.getBuffer()).iterable(iScope)) {
            stringBuilder.append(string).append(Strings.LN);
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getFile(iScope)));){
                IList iList = GamaListFactory.create(Types.STRING);
                String string = bufferedReader.readLine();
                while (string != null) {
                    iList.add(string);
                    string = bufferedReader.readLine();
                }
                this.setBuffer(iList);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope);
        }
    }

    @Override
    protected void flushBuffer(IScope iScope, Facets facets2) throws GamaRuntimeException {
        if (this.getBuffer() != null && !((IList)this.getBuffer()).isEmpty()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.getFile(iScope)));){
                    for (String string : (IList)this.getBuffer()) {
                        bufferedWriter.append(string).append(Strings.LN);
                    }
                    bufferedWriter.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.create(iOException, iScope);
            }
        }
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        return null;
    }
}

