/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.operators;

import gama.annotations.precompiler.GamlProperties;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.ICollector;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.AbstractExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.data.ListExpression;
import gama.gaml.expressions.data.MapExpression;
import gama.gaml.expressions.operators.IOperator;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.function.Predicate;

public class UnaryOperator
extends AbstractExpression
implements IOperator {
    protected final IExpression child;
    protected final OperatorProto prototype;

    public static IExpression create(OperatorProto operatorProto, IDescription iDescription, IExpression iExpression) {
        return new UnaryOperator(operatorProto, iDescription, iExpression).optimized();
    }

    @Override
    public boolean isConst() {
        return this.prototype.canBeConst && this.child.isConst();
    }

    @Override
    public String getDefiningPlugin() {
        return this.prototype.getDefiningPlugin();
    }

    public UnaryOperator(OperatorProto operatorProto, IDescription iDescription, IExpression ... iExpressionArray) {
        this.child = iExpressionArray[0];
        this.prototype = operatorProto;
        if (operatorProto != null) {
            this.type = operatorProto.returnType;
            this.computeType();
            operatorProto.verifyExpectedTypes(iDescription, iExpressionArray[0].getGamlType().getContentType());
        }
    }

    @Override
    public Object _value(IScope iScope) throws GamaRuntimeException {
        IExpression iExpression = this.prototype.getLazyness()[0] ? this.child : this.child.value(iScope);
        try {
            return this.prototype.getHelper().get(iScope, iExpression);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("when applying the " + this.literalValue() + " operator on " + String.valueOf(iExpression));
            throw gamaRuntimeException;
        }
        catch (Throwable throwable) {
            GamaRuntimeException gamaRuntimeException = GamaRuntimeException.create(throwable, iScope);
            gamaRuntimeException.addContext("when applying the " + this.literalValue() + " operator on " + String.valueOf(iExpression));
            throw gamaRuntimeException;
        }
    }

    @Override
    public String serializeToGaml(boolean bl) {
        String string = this.literalValue();
        StringBuilder stringBuilder = new StringBuilder(string);
        if (OperatorProto.noMandatoryParenthesis.contains(string)) {
            UnaryOperator.parenthesize(stringBuilder, this.child);
        } else {
            stringBuilder.append("(").append(this.child.serializeToGaml(bl)).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean shouldBeParenthesized() {
        return false;
    }

    public String toString() {
        return this.literalValue() + "(" + String.valueOf(this.child) + ")";
    }

    @Override
    public String getTitle() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("operator ").append(this.getName()).append(" (");
        stringBuilder.append(this.child == null ? this.prototype.signature : this.child.getGamlType().getName());
        stringBuilder.append(") returns ").append(this.getGamlType().getName());
        return stringBuilder.toString();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return this.prototype.getDocumentation();
    }

    private IType computeType(int n, IType iType) {
        boolean bl;
        int n2 = n;
        boolean bl2 = bl = n2 < -1000;
        if (bl) {
            n2 += 1000;
        }
        IType<?> iType2 = iType;
        switch (n2) {
            case -30: {
                iType2 = this.child.getGamlType().getWrappedType();
                break;
            }
            case -22: {
                if (this.child instanceof ListExpression) {
                    IExpression[] iExpressionArray = ((ListExpression)this.child).getElements();
                    if (iExpressionArray.length == 0) {
                        iType2 = Types.NO_TYPE;
                        break;
                    }
                    iType2 = iExpressionArray[0].getGamlType().getContentType();
                    break;
                }
                if (this.child instanceof MapExpression) {
                    IExpression[] iExpressionArray = ((MapExpression)this.child).valuesArray();
                    if (iExpressionArray.length == 0) {
                        iType2 = Types.NO_TYPE;
                        break;
                    }
                    iType2 = iExpressionArray[0].getGamlType().getContentType();
                    break;
                }
                IType<?> iType3 = this.child.getGamlType().getContentType().getContentType();
                if (iType3 == Types.NO_TYPE) break;
                iType2 = iType3;
                break;
            }
            case -26: {
                IType<?> iType4 = this.child.getGamlType();
                IType<?> iType5 = iType4.getContentType();
                if (iType5 == Types.NO_TYPE) {
                    iType2 = iType4;
                    break;
                }
                iType2 = iType5;
                break;
            }
            default: {
                IType<?> iType6 = n2 == -199 ? this.child.getGamlType() : (n2 == -299 ? this.child.getGamlType().getContentType() : (n2 == -399 ? this.child.getGamlType().getKeyType() : (n2 >= 0 ? Types.get(n2) : (n2 == -349 ? this.child.getDenotedType() : (iType2 = n2 == -449 ? Types.PAIR.of(this.child.getGamlType().getKeyType(), this.child.getGamlType().getContentType()) : iType)))));
            }
        }
        if (bl && iType2 == Types.INT) {
            return Types.FLOAT;
        }
        return iType2;
    }

    protected void computeType() {
        this.type = this.computeType(this.prototype.typeProvider, this.type);
        if (this.type.isContainer()) {
            IType iType;
            IType<?> iType2 = this.computeType(this.prototype.contentTypeProvider, this.type.getContentType());
            if (iType2.isParametricFormOf(Types.PAIR) && this.type == Types.LIST) {
                this.type = Types.LIST.of(iType2);
            } else if (iType2.isContainer()) {
                if (iType2.getKeyType() == Types.NO_TYPE && iType2.getContentType() == Types.NO_TYPE) {
                    iType2 = GamaType.from(iType2, this.child.getGamlType().getKeyType(), this.child.getGamlType().getContentType());
                }
                iType = this.computeType(this.prototype.contentTypeContentTypeProvider, iType2.getContentType());
                iType2 = ((IContainerType)iType2).of(iType);
            }
            if (!this.type.isParametricFormOf(Types.LIST)) {
                iType = this.computeType(this.prototype.keyTypeProvider, this.type.getKeyType());
                this.type = GamaType.from(this.type, iType, iType2);
            }
        }
    }

    @Override
    public IOperator resolveAgainst(IScope iScope) {
        return new UnaryOperator(this.prototype, null, this.child.resolveAgainst(iScope));
    }

    @Override
    public String getName() {
        return this.prototype.getName();
    }

    @Override
    public IExpression arg(int n) {
        return n == 0 ? this.child : null;
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        this.prototype.collectMetaInformation(gamlProperties);
        this.child.collectMetaInformation(gamlProperties);
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        this.prototype.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
        this.child.collectUsedVarsOf(speciesDescription, iCollector, iCollector2);
    }

    @Override
    public boolean isContextIndependant() {
        return this.child.isContextIndependant();
    }

    @Override
    public boolean isAllowedInParameters() {
        return this.child.isAllowedInParameters();
    }

    @Override
    public OperatorProto getPrototype() {
        return this.prototype;
    }

    @Override
    public void visitSuboperators(IOperator.IOperatorVisitor iOperatorVisitor) {
        if (this.child instanceof IOperator) {
            iOperatorVisitor.visit((IOperator)this.child);
        }
    }

    @Override
    public boolean findAny(Predicate<IExpression> predicate) {
        if (predicate.test(this)) {
            return true;
        }
        return this.child != null && this.child.findAny(predicate);
    }
}

