/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.factories;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.ISymbolKind;
import gama.core.util.Collector;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IAgentConstructor;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.compilation.ast.SyntacticFactory;
import gama.gaml.descriptions.FacetProto;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.factories.ExperimentFactory;
import gama.gaml.factories.ModelFactory;
import gama.gaml.factories.PlatformFactory;
import gama.gaml.factories.SpeciesFactory;
import gama.gaml.factories.StatementFactory;
import gama.gaml.factories.SymbolFactory;
import gama.gaml.factories.VariableFactory;
import gama.gaml.statements.Facets;
import gama.gaml.types.IType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class DescriptionFactory {
    static Map<Integer, SymbolFactory> FACTORIES = new HashMap<Integer, SymbolFactory>();
    static Map<String, SymbolProto> STATEMENT_KEYWORDS_PROTOS = new HashMap<String, SymbolProto>();
    static Map<String, SymbolProto> VAR_KEYWORDS_PROTOS = new HashMap<String, SymbolProto>();
    static Map<Integer, SymbolProto> KINDS_PROTOS = new HashMap<Integer, SymbolProto>();

    static {
        DEBUG.ON();
        DescriptionFactory.initialize();
    }

    private static void add(SymbolFactory symbolFactory, Integer ... integerArray) {
        Integer[] integerArray2 = integerArray;
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = integerArray2[n2];
            FACTORIES.put(n3, symbolFactory);
            ++n2;
        }
    }

    public static void initialize() {
        DescriptionFactory.add(new ExperimentFactory(), 13);
        DescriptionFactory.add(new ModelFactory(), 1);
        DescriptionFactory.add(new PlatformFactory(), 16);
        DescriptionFactory.add(new SpeciesFactory(), 0);
        DescriptionFactory.add(new StatementFactory(), 11, 2, 3, 11, 6, 9, 5);
        DescriptionFactory.add(new VariableFactory(), 102, 101, 104, 4);
    }

    public static final SymbolProto getProto(String string, IDescription iDescription) {
        SymbolProto symbolProto = DescriptionFactory.getStatementProto(string);
        if (symbolProto == null) {
            return DescriptionFactory.getVarProto(string, iDescription);
        }
        return symbolProto;
    }

    public static final SymbolProto getStatementProto(String string) {
        return STATEMENT_KEYWORDS_PROTOS.get(string);
    }

    public static final SymbolProto getVarProto(String string, IDescription iDescription) {
        SymbolProto symbolProto = VAR_KEYWORDS_PROTOS.get(string);
        if (symbolProto == null) {
            if (iDescription == null) {
                return null;
            }
            ModelDescription modelDescription = iDescription.getModelDescription();
            if (modelDescription == null) {
                return null;
            }
            IType<?> iType = modelDescription.getTypesManager().get(string);
            if (iType.isAgentType()) {
                return DescriptionFactory.getVarProto("agent", null);
            }
        }
        return symbolProto;
    }

    public static final Iterable<String> getProtoNames() {
        return Iterables.concat(DescriptionFactory.getStatementProtoNames(), DescriptionFactory.getVarProtoNames());
    }

    public static final Iterable<String> getStatementProtoNames() {
        return STATEMENT_KEYWORDS_PROTOS.keySet();
    }

    public static final Iterable<String> getVarProtoNames() {
        return VAR_KEYWORDS_PROTOS.keySet();
    }

    public static final boolean isStatementProto(String string) {
        return STATEMENT_KEYWORDS_PROTOS.containsKey(string) || "method".equals(string);
    }

    public static SymbolFactory getFactory(int n) {
        return FACTORIES.get(n);
    }

    public static String getOmissibleFacetForSymbol(String string) {
        SymbolProto symbolProto = DescriptionFactory.getProto(string, null);
        if (symbolProto == null) {
            return "name";
        }
        return symbolProto.getOmissible();
    }

    public static void addProto(SymbolProto symbolProto, Iterable<String> iterable) {
        int n = symbolProto.getKind();
        if (ISymbolKind.Variable.KINDS.contains(n)) {
            for (String string : iterable) {
                VAR_KEYWORDS_PROTOS.putIfAbsent(string, symbolProto);
            }
        } else {
            for (String string : iterable) {
                STATEMENT_KEYWORDS_PROTOS.put(string, symbolProto);
            }
        }
        KINDS_PROTOS.put(n, symbolProto);
    }

    public static void addNewTypeName(String string, int n) {
        if (VAR_KEYWORDS_PROTOS.containsKey(string)) {
            return;
        }
        SymbolProto symbolProto = KINDS_PROTOS.get(n);
        if (symbolProto != null) {
            if ("species".equals(string)) {
                VAR_KEYWORDS_PROTOS.put("species_var", symbolProto);
            } else {
                VAR_KEYWORDS_PROTOS.put(string, symbolProto);
            }
        }
    }

    public static SymbolFactory getFactory(String string) {
        SymbolProto symbolProto = DescriptionFactory.getProto(string, null);
        if (symbolProto != null) {
            return symbolProto.getFactory();
        }
        return null;
    }

    public static void addSpeciesNameAsType(String string) {
        if (!"agent".equals(string) && !"experiment".equals(string)) {
            VAR_KEYWORDS_PROTOS.putIfAbsent(string, VAR_KEYWORDS_PROTOS.get("agent"));
        }
    }

    public static synchronized IDescription create(SymbolFactory symbolFactory, String string, IDescription iDescription, Iterable<IDescription> iterable, Facets facets2) {
        return DescriptionFactory.create(SyntacticFactory.create(string, facets2, iterable != null, new Object[0]), iDescription, iterable);
    }

    public static synchronized IDescription create(String string, IDescription iDescription, Iterable<IDescription> iterable, Facets facets2) {
        return DescriptionFactory.create(DescriptionFactory.getFactory(string), string, iDescription, iterable, facets2);
    }

    public static synchronized IDescription create(String string, IDescription iDescription, Iterable<IDescription> iterable) {
        return DescriptionFactory.create(DescriptionFactory.getFactory(string), string, iDescription, iterable, null);
    }

    public static synchronized IDescription create(String string, IDescription iDescription, Iterable<IDescription> iterable, String ... stringArray) {
        return DescriptionFactory.create(DescriptionFactory.getFactory(string), string, iDescription, iterable, new Facets(stringArray));
    }

    public static synchronized IDescription create(String string, IDescription iDescription, String ... stringArray) {
        return DescriptionFactory.create(string, iDescription, null, stringArray);
    }

    public static synchronized IDescription create(String string, String ... stringArray) {
        return DescriptionFactory.create(string, (IDescription)GAML.getModelContext(), stringArray);
    }

    public static ModelFactory getModelFactory() {
        return (ModelFactory)DescriptionFactory.getFactory(1);
    }

    public static Set<String> getAllowedFacetsFor(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            SymbolProto symbolProto = DescriptionFactory.getProto(string, null);
            if (symbolProto != null) {
                hashSet.addAll(symbolProto.getPossibleFacets().keySet());
            }
            ++n2;
        }
        return hashSet;
    }

    public static SpeciesDescription createBuiltInSpeciesDescription(String string, Class clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, IAgentConstructor iAgentConstructor, Set<String> set, String string2) {
        return ((SpeciesFactory)DescriptionFactory.getFactory(0)).createBuiltInSpeciesDescription(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, set, null, string2);
    }

    public static SpeciesDescription createPlatformSpeciesDescription(String string, Class clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, IAgentConstructor iAgentConstructor, Set<String> set, String string2) {
        return ((SpeciesFactory)DescriptionFactory.getFactory(16)).createBuiltInSpeciesDescription(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, set, null, string2);
    }

    public static SpeciesDescription createBuiltInExperimentDescription(String string, Class clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, IAgentConstructor iAgentConstructor, Set<String> set, String string2) {
        return ((ExperimentFactory)DescriptionFactory.getFactory(13)).createBuiltInSpeciesDescription(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, (Set)set, (Facets)null, string2);
    }

    public static ModelDescription createRootModelDescription(String string, Class clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, IAgentConstructor iAgentConstructor, Set<String> set, String string2) {
        return ModelFactory.createRootModel(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, set, string2);
    }

    public static final IDescription create(ISyntacticElement iSyntacticElement2, IDescription iDescription, Iterable<IDescription> iterable) {
        ISyntacticElement.SyntacticVisitor syntacticVisitor;
        Object object;
        if (iSyntacticElement2 == null) {
            return null;
        }
        String string = iSyntacticElement2.getKeyword();
        SymbolProto symbolProto = DescriptionFactory.getProto(string, iDescription);
        if (symbolProto == null) {
            if (iDescription == null) {
                throw new RuntimeException("Description of " + string + " cannot be built");
            }
            iDescription.error("Unknown statement " + string, "gaml.unknown.keyword.issue", iSyntacticElement2.getElement(), string);
            return null;
        }
        Iterable<IDescription> iterable2 = iterable;
        if (iterable2 == null) {
            object = Collector.getList();
            syntacticVisitor = iSyntacticElement -> {
                IDescription iDescription2 = DescriptionFactory.create(iSyntacticElement, iDescription, null);
                if (iDescription2 != null) {
                    object.add(iDescription2);
                }
            };
            iSyntacticElement2.visitChildren(syntacticVisitor);
            iSyntacticElement2.visitGrids(syntacticVisitor);
            iSyntacticElement2.visitSpecies(syntacticVisitor);
            iSyntacticElement2.visitExperiments(syntacticVisitor);
            iterable2 = object.items();
        }
        object = iSyntacticElement2.copyFacets(symbolProto);
        syntacticVisitor = iSyntacticElement2.getElement();
        return symbolProto.getFactory().buildDescription(string, (Facets)object, (EObject)syntacticVisitor, iterable2, iDescription, symbolProto);
    }

    public static Iterable<SymbolProto> getStatementProtos() {
        return Iterables.concat(STATEMENT_KEYWORDS_PROTOS.values(), VAR_KEYWORDS_PROTOS.values());
    }

    public static Iterable<? extends FacetProto> getFacetsProtos() {
        return Iterables.concat((Iterable)Iterables.transform(DescriptionFactory.getStatementProtos(), symbolProto -> symbolProto.getPossibleFacets().values()));
    }
}

