/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.batch.exploration.AExplorationAlgorithm;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IMap;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.operators.Cast;
import java.util.List;
import java.util.Map;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="sampling", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The name of the sampling method among: latinhypercube, orthogonal, factorial, uniform, saltelli, morris")}), @GamlAnnotations.facet(name="from", type={4}, optional=true, doc={@GamlAnnotations.doc(value="a path to a file where each lines correspond to one parameter set and each colon a parameter")}), @GamlAnnotations.facet(name="with", type={5}, of=10, optional=true, doc={@GamlAnnotations.doc(value="the list of parameter sets to explore; a parameter set is defined by a map: key: name of the variable, value: expression for the value of the variable")}), @GamlAnnotations.facet(name="outputs", type={5}, of=4, optional=true, doc={@GamlAnnotations.doc(value="The list of output variables to track throughout exploration")}), @GamlAnnotations.facet(name="results", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The path to the file where the automatic batch report will be written")}), @GamlAnnotations.facet(name="sample", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The number of sample required, 132 by default")}), @GamlAnnotations.facet(name="factorial", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The number of slice (value) applied to each parameter to build the factorial experimental plan.")}), @GamlAnnotations.facet(name="levels", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The number of levels for morris sampling, 4 by default")}), @GamlAnnotations.facet(name="iterations", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The number of iteration for orthogonal sampling, 5 by default")})}, omissible="name")
@GamlAnnotations.doc(value="This is the standard batch method. The exploration mode is defined by default when there is no method element present in the batch section. It explores all the combination of parameter values in a sequential way. You can also choose a sampling method for the exploration. See [batch161 the batch dedicated page].", usages={@GamlAnnotations.usage(value="As other batch methods, the basic syntax of the exploration statement uses `method exploration` instead of the expected `exploration name: id` : ", examples={@GamlAnnotations.example(value="method exploration;", isExecutable=false)}), @GamlAnnotations.usage(value="Simplest example: ", examples={@GamlAnnotations.example(value="method exploration;", isExecutable=false)}), @GamlAnnotations.usage(value="Using sampling facet: ", examples={@GamlAnnotations.example(value="method exploration sampling:latinhypercube sample:100; ", isExecutable=false)}), @GamlAnnotations.usage(value="Using from facet: ", examples={@GamlAnnotations.example(value="method exploration from:\"../path/to/my/exploration/plan.csv\"; ", isExecutable=false)}), @GamlAnnotations.usage(value="Using with facet: ", examples={@GamlAnnotations.example(value="method exploration with:[[\"a\"::0.5, \"b\"::10],[\"a\"::0.1, \"b\"::100]]; ", isExecutable=false)})})
public class Exploration
extends AExplorationAlgorithm {
    public static final String METHODS = "sampling";
    public static final String SAMPLE_SIZE = "sample";
    public static final String SAMPLE_FACTORIAL = "factorial";
    public static final int DEFAULT_FACTORIAL = 9;
    public static final String NB_LEVELS = "levels";
    public static final String ITERATIONS = "iterations";
    public static final String FROM_FILE = "FROMFILE";
    public static final String FROM_LIST = "FROMLIST";
    public static final String DEFAULT_SAMPLING = "Exhaustive";
    private List<IParameter.Batch> parameters;

    public Exploration(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    @Override
    public void explore(IScope iScope) throws GamaRuntimeException {
        List<ParametersSet> list;
        List<IParameter.Batch> list2 = this.parameters = this.parameters == null ? this.currentExperiment.getParametersToExplore() : this.parameters;
        if (this.hasFacet(SAMPLE_SIZE)) {
            this.sample_size = Cast.asInt(iScope, this.getFacet(SAMPLE_SIZE).value(iScope));
        }
        if ((list = this.getExperimentPlan(this.parameters, iScope)).isEmpty()) {
            list.add(new ParametersSet());
        }
        this.sample_size = list.size();
        IMap<ParametersSet, Map<String, List<Object>>> iMap = this.currentExperiment.runSimulationsAndReturnResults(list);
        if (this.hasFacet("outputs")) {
            this.saveRawResults(iScope, iMap);
        }
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, final BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Sampled points", "Exploration experiment", 4){

            @Override
            public Object value() {
                return Exploration.this.sample_size;
            }
        });
        list.add(new ParameterAdapter("Sampling method", "Exploration experiment", 4){

            @Override
            public Object value() {
                if (Exploration.this.hasFacet("from")) {
                    return Exploration.FROM_FILE;
                }
                if (Exploration.this.hasFacet("with")) {
                    return Exploration.FROM_LIST;
                }
                return Exploration.this.hasFacet(Exploration.METHODS) ? Cast.asString(batchAgent.getScope(), Exploration.this.getFacet(Exploration.METHODS).value(batchAgent.getScope())) : Exploration.DEFAULT_SAMPLING;
            }
        });
    }
}

