/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.core.runtime.IScope;
import gama.gaml.statements.IExecutable;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActionExecuter {
    private static final int BEGIN = 0;
    private static final int END = 1;
    private static final int DISPOSE = 2;
    private static final int ONE_SHOT = 3;
    final Collection<IExecutable>[] actions = new Collection[]{new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList()};
    protected final IScope scope;

    public ActionExecuter(IScope iScope) {
        this.scope = iScope.copy("of ActionExecuter");
    }

    private IExecutable insertAction(IExecutable iExecutable, int n) {
        if (this.actions[n].add(iExecutable)) {
            return iExecutable;
        }
        return null;
    }

    public IExecutable insertDisposeAction(IExecutable iExecutable) {
        return this.insertAction(iExecutable, 2);
    }

    public IExecutable insertEndAction(IExecutable iExecutable) {
        return this.insertAction(iExecutable, 1);
    }

    public IExecutable insertOneShotAction(IExecutable iExecutable) {
        return this.insertAction(iExecutable, 3);
    }

    public void executeEndActions() {
        if (this.scope.interrupted()) {
            return;
        }
        this.executeActions(1);
    }

    public void executeDisposeActions() {
        this.executeActions(2);
    }

    public void executeOneShotActions() {
        if (this.scope.interrupted()) {
            return;
        }
        try {
            this.executeActions(3);
        }
        finally {
            this.actions[3].clear();
        }
    }

    private void executeActions(int n) {
        for (IExecutable iExecutable : this.actions[n]) {
            if (this.scope.interrupted()) continue;
            iExecutable.executeOn(this.scope);
        }
    }

    public synchronized void executeOneAction(IExecutable iExecutable) {
        boolean bl = this.scope.isPaused();
        if (bl) {
            iExecutable.executeOn(this.scope);
        } else {
            this.insertOneShotAction(iExecutable);
        }
    }

    public void executeBeginActions() {
        if (this.scope.interrupted()) {
            return;
        }
        this.executeActions(0);
    }
}

