/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.Font;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="name", type=4, doc={@GamlAnnotations.doc(value="Returns the name of this font")}), @GamlAnnotations.variable(name="size", type=1, doc={@GamlAnnotations.doc(value="Returns the size (in points) of this font")}), @GamlAnnotations.variable(name="style", type=1, doc={@GamlAnnotations.doc(value="Returns the style of this font (0 for plain, 1 for bold, 2 for italic, 3 for bold+italic)")})})
public class GamaFont
extends Font
implements IValue {
    public GamaFont(String string, int n, int n2) {
        super(string, n, n2);
    }

    public GamaFont(Font font) {
        super(font);
    }

    @Override
    @GamlAnnotations.getter(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @GamlAnnotations.getter(value="size")
    public int getSize() {
        return this.size;
    }

    @Override
    @GamlAnnotations.getter(value="style")
    public int getStyle() {
        return this.style;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        String string = this.isBold() ? (this.isItalic() ? "#bold + #italic" : "#bold") : (this.isItalic() ? "#italic" : "#plain");
        return "font('" + this.name + "'," + this.pointSize + "," + string + ")";
    }

    @Override
    public IType<?> getGamlType() {
        return Types.FONT;
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.toString();
    }

    @Override
    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.name + "-" + string + "-" + this.size;
    }

    @Override
    public IValue copy(IScope iScope) throws GamaRuntimeException {
        return new GamaFont(this.name, this.style, this.size);
    }

    @GamlAnnotations.operator(value={"font"}, category={"Casting operators"}, concept={"text", "display"}, can_be_const=true)
    @GamlAnnotations.doc(value="Creates a new font, by specifying its name (either a font face name like 'Lucida Grande Bold' or 'Helvetica', or a logical name like 'Dialog', 'SansSerif', 'Serif', etc.), a size in points and a style, either #bold, #italic or #plain or a combination (addition) of them.", masterDoc=true, examples={@GamlAnnotations.example(value="font ('Helvetica Neue',12, #bold + #italic)", equals="a bold and italic face of the Helvetica Neue family", test=false)})
    public static GamaFont font(String string, Integer n, Integer n2) {
        return new GamaFont(string, n2, n);
    }

    @GamlAnnotations.operator(value={"with_size"}, category={"Casting operators"}, concept={"text", "display"}, can_be_const=true)
    @GamlAnnotations.doc(value="Creates a new font from an existing font, with a new size in points", masterDoc=true, examples={@GamlAnnotations.example(value="font ('Helvetica Neue',12, #bold + #italic) with_size 24", equals="a bold and italic face of the Helvetica Neue family with a size of 24 points", test=false)})
    public static GamaFont withSize(GamaFont gamaFont, Integer n) {
        return new GamaFont(gamaFont.name, gamaFont.style, n);
    }

    @GamlAnnotations.operator(value={"with_style"}, category={"Casting operators"}, concept={"text", "display"}, can_be_const=true)
    @GamlAnnotations.doc(value="Creates a new font from an existing font, with a new style: either #bold, #italic or #plain or a combination (addition) of them.", masterDoc=true, examples={@GamlAnnotations.example(value="font ('Helvetica Neue',12, #bold + #italic) with_style #plain", equals="a plain face of the Helvetica Neue family with a size of 12 points", test=false)})
    public static GamaFont withStyle(GamaFont gamaFont, Integer n) {
        return new GamaFont(gamaFont.name, n, gamaFont.size);
    }

    @GamlAnnotations.operator(value={"font"}, category={"Casting operators"}, concept={"text", "display"}, can_be_const=true)
    @GamlAnnotations.doc(value="Creates a new font, by specifying its name (either a font face name like 'Lucida Grande Bold' or 'Helvetica', or a logical name like 'Dialog', 'SansSerif', 'Serif', etc.) and a size in points. No style is attached to this font")
    public static GamaFont font(String string, Integer n) {
        return new GamaFont(string, 0, n);
    }

    @Override
    public int intValue(IScope iScope) {
        return this.getSize();
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "name", this.name, "style", this.style, "size", this.size);
    }
}

