/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import gama.core.common.interfaces.IValue;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IMap;
import gama.core.util.IModifiableContainer;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.matrix.IMatrix;
import gama.dev.FLAGS;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaIntegerType;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.GamaPairType;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface IList<E>
extends IModifiableContainer<Integer, E, Integer, E>,
IAddressableContainer<Integer, E, Integer, E>,
List<E> {
    @Override
    default public boolean containsKey(IScope iScope, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n >= 0 && n < this.size();
        }
        return false;
    }

    @Override
    default public IList<E> listValue(IScope iScope, IType iType, boolean bl) {
        if (!GamaType.requiresCasting(iType, this.getGamlType().getContentType())) {
            if (bl) {
                return GamaListFactory.createWithoutCasting(iType, this);
            }
            return this;
        }
        return GamaListFactory.create(iScope, iType, this);
    }

    @Override
    default public IMatrix<E> matrixValue(IScope iScope, IType iType, boolean bl) {
        return GamaMatrixType.from(iScope, this, iType, null);
    }

    @Override
    default public IMatrix<E> matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) {
        return GamaMatrixType.from(iScope, this, iType, gamaPoint);
    }

    @Override
    default public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.serializeToGaml(false);
    }

    @Override
    default public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.size() * 10);
        stringBuilder.append('[');
        int n = 0;
        while (n < this.size()) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(StringUtils.toGaml(this.get(n), bl));
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    default public IMap<?, ?> mapValue(IScope iScope, IType iType, IType iType2, boolean bl) {
        IType<?> iType3;
        IType<?> iType4;
        IType<?> iType5 = this.getGamlType().getContentType();
        if (iType5.isParametricFormOf(Types.PAIR) || iType5.equals(Types.PAIR)) {
            iType4 = GamaType.findSpecificType(iType, iType5.getKeyType());
            iType3 = GamaType.findSpecificType(iType2, iType5.getContentType());
        } else {
            iType4 = GamaType.findSpecificType(iType, iType5);
            iType3 = GamaType.findSpecificType(iType2, iType5);
        }
        IMap iMap = GamaMapFactory.create(iType4, iType3);
        for (Object e : this) {
            iMap.addValue(iScope, GamaPairType.staticCast(iScope, e, iType4, iType3, bl));
        }
        return iMap;
    }

    @Override
    default public void addValue(IScope iScope, E e) {
        this.add(this.buildValue(iScope, e));
    }

    @Override
    default public void addValueAtIndex(IScope iScope, Object object, E e) {
        this.add(this.buildIndex(iScope, object), this.buildValue(iScope, e));
    }

    @Override
    default public void setValueAtIndex(IScope iScope, Object object, E e) {
        this.set(this.buildIndex(iScope, object), this.buildValue(iScope, e));
    }

    default public void replaceRange(IScope iScope, GamaPair gamaPair, E e) {
        this.subList(Cast.asInt(iScope, gamaPair.key), Cast.asInt(iScope, gamaPair.value)).replaceAll(object2 -> this.buildValue(iScope, e));
    }

    @Override
    default public void addValues(IScope iScope, Object object, IContainer iContainer) {
        if (object == null) {
            this.addAll(this.buildValues(iScope, iContainer));
        } else {
            int n = this.buildIndex(iScope, object);
            this.addAll(n, this.buildValues(iScope, iContainer));
        }
    }

    @Override
    default public void setAllValues(IScope iScope, E e) {
        E e2 = this.buildValue(iScope, e);
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            this.set(n, e2);
            ++n;
        }
    }

    @Override
    default public void removeValue(IScope iScope, Object object) {
        this.remove(object);
    }

    @Override
    default public void removeIndex(IScope iScope, Object object) {
        int n = Cast.asInt(iScope, object);
        this.remove(n);
    }

    @Override
    default public void removeValues(IScope iScope, IContainer<?, ?> iContainer) {
        if (iContainer instanceof Collection) {
            this.removeAll((Collection)((Object)iContainer));
        } else {
            this.removeAll(iContainer.listValue(iScope, Types.NO_TYPE, false));
        }
    }

    @Override
    default public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
        this.removeIf(object2 -> Objects.equals(object2, object));
    }

    @Override
    default public E firstValue(IScope iScope) {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    default public E lastValue(IScope iScope) {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    default public E get(IScope iScope, Integer n) {
        return this.get(n);
    }

    @Override
    default public int length(IScope iScope) {
        return this.size();
    }

    @Override
    default public IContainer<Integer, E> reverse(IScope iScope) {
        IValue iValue = this.copy(iScope);
        Collections.reverse(iValue);
        return iValue;
    }

    @Override
    default public IList<E> copy(IScope iScope) {
        return GamaListFactory.createWithoutCasting(this.getGamlType().getContentType(), this);
    }

    @Override
    default public E anyValue(IScope iScope) {
        if (this.isEmpty()) {
            return null;
        }
        int n = iScope.getRandom().between(0, this.size() - 1);
        return this.get(n);
    }

    @Override
    default public boolean contains(IScope iScope, Object object) throws GamaRuntimeException {
        return this.contains(object);
    }

    @Override
    default public boolean isEmpty(IScope iScope) {
        return this.isEmpty();
    }

    @Override
    default public Iterable<? extends E> iterable(IScope iScope) {
        return this;
    }

    @Override
    default public E getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return this.get(iScope, Cast.asInt(iScope, iList.get(0)));
    }

    @Override
    default public void removeIndexes(IScope iScope, IContainer<?, ?> iContainer) {
        IList<?> iList = iContainer.listValue(iScope, Types.INT, false);
        Collections.sort(iList, Collections.reverseOrder());
        for (Integer n : iList) {
            this.removeIndex(iScope, n);
        }
    }

    default public E buildValue(IScope iScope, Object object) {
        if (!FLAGS.CAST_CONTAINER_CONTENTS) {
            return (E)object;
        }
        return (E)this.getGamlType().getContentType().cast(iScope, object, null, false);
    }

    default public IList<E> buildValues(IScope iScope, IContainer iContainer) {
        if (!FLAGS.CAST_CONTAINER_CONTENTS) {
            return (IList)iContainer;
        }
        return (IList)this.getGamlType().cast(iScope, iContainer, null, false);
    }

    default public Integer buildIndex(IScope iScope, Object object) {
        if (!FLAGS.CAST_CONTAINER_CONTENTS) {
            return (Integer)object;
        }
        return GamaIntegerType.staticCast(iScope, object, null, false);
    }

    default public IContainer<?, Integer> buildIndexes(IScope iScope, IContainer iContainer) {
        IList<Integer> iList = GamaListFactory.create(Types.INT);
        for (Object ValueType : iContainer.iterable(iScope)) {
            iList.add(this.buildIndex(iScope, ValueType));
        }
        return iList;
    }

    @Override
    default public JsonValue serializeToJson(Json json) {
        return json.array(this);
    }
}

