/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaGeometryFile;
import gama.dependencies.kabeja.dxf.DXFArc;
import gama.dependencies.kabeja.dxf.DXFBlock;
import gama.dependencies.kabeja.dxf.DXFCircle;
import gama.dependencies.kabeja.dxf.DXFDocument;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFLayer;
import gama.dependencies.kabeja.dxf.DXFLine;
import gama.dependencies.kabeja.dxf.DXFPolyline;
import gama.dependencies.kabeja.dxf.DXFSolid;
import gama.dependencies.kabeja.dxf.DXFVertex;
import gama.dependencies.kabeja.parser.Parser;
import gama.dependencies.kabeja.parser.ParserBuilder;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;

@GamlAnnotations.file(name="dxf", extensions={"dxf"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"dxf", "file"}, doc={@GamlAnnotations.doc(value="DXF files are 2D geometrical files. The internal representation is a list of geometries")})
public class GamaDXFFile
extends GamaGeometryFile {
    GamaPoint size;
    Double unit;
    double x_t;
    double y_t;
    protected static final double QUARTER_CIRCLE_ANGLE = Math.tan(0.39269908169872414);

    @GamlAnnotations.doc(value="This file constructor allows to read a dxf (.dxf) file", examples={@GamlAnnotations.example(value="file f <- dxf_file(\"file.dxf\");", isExecutable=false)})
    public GamaDXFFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a dxf (.dxf) file and specify the unit (meter by default)", examples={@GamlAnnotations.example(value="file f <- dxf_file(\"file.dxf\",#m);", isExecutable=false)})
    public GamaDXFFile(IScope iScope, String string, Double d) throws GamaRuntimeException {
        super(iScope, string);
        if (d <= 0.0) {
            throw GamaRuntimeException.error("the unit given has to be higher than 0", iScope);
        }
        this.unit = d;
    }

    @Override
    protected IShape buildGeometry(IScope iScope) {
        return GamaGeometryType.geometriesToGeometry(iScope, this.getBuffer());
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    public IShape createPolyline(IScope iScope, IList iList) {
        if (iList.isEmpty()) {
            return null;
        }
        IShape iShape = GamaGeometryType.buildPolyline(iList);
        if (iShape != null) {
            if (this.size != null) {
                return SpatialTransformations.scaled_to(iScope, iShape, this.size);
            }
            return iShape;
        }
        return null;
    }

    public IShape createPolygon(IScope iScope, IList iList) {
        if (iList.isEmpty()) {
            return null;
        }
        IShape iShape = GamaGeometryType.buildPolygon(iList);
        if (iShape != null) {
            if (this.size != null) {
                return SpatialTransformations.scaled_to(iScope, iShape, this.size);
            }
            return iShape;
        }
        return null;
    }

    public IShape createCircle(IScope iScope, GamaPoint gamaPoint, double d) {
        GamaShape gamaShape = GamaGeometryType.buildCircle(d, gamaPoint).getExteriorRing(iScope);
        if (gamaShape != null) {
            if (this.size != null) {
                return SpatialTransformations.scaled_to(iScope, gamaShape, this.size);
            }
            return gamaShape;
        }
        return null;
    }

    public IShape manageObj(IScope iScope, DXFSolid dXFSolid) {
        if (dXFSolid == null) {
            return null;
        }
        IList iList = GamaListFactory.create(Types.POINT);
        iList.add(new GamaPoint(dXFSolid.getPoint1().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFSolid.getPoint1().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFSolid.getPoint1().getZ() * (this.unit == null ? 1.0 : this.unit)));
        iList.add(new GamaPoint(dXFSolid.getPoint2().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFSolid.getPoint2().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFSolid.getPoint2().getZ() * (this.unit == null ? 1.0 : this.unit)));
        iList.add(new GamaPoint(dXFSolid.getPoint3().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFSolid.getPoint3().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFSolid.getPoint3().getZ() * (this.unit == null ? 1.0 : this.unit)));
        iList.add(new GamaPoint(dXFSolid.getPoint4().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFSolid.getPoint4().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFSolid.getPoint4().getZ() * (this.unit == null ? 1.0 : this.unit)));
        return this.createPolygon(iScope, iList);
    }

    public IShape manageObj(IScope iScope, DXFCircle dXFCircle) {
        if (dXFCircle == null) {
            return null;
        }
        GamaPoint gamaPoint = new GamaPoint(dXFCircle.getCenterPoint().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFCircle.getCenterPoint().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFCircle.getCenterPoint().getZ() * (this.unit == null ? 1.0 : this.unit));
        return this.createCircle(iScope, gamaPoint, dXFCircle.getRadius() * (this.unit == null ? 1.0 : this.unit));
    }

    public IShape manageObj(IScope iScope, DXFLine dXFLine) {
        if (dXFLine == null) {
            return null;
        }
        IList iList = GamaListFactory.create(Types.POINT);
        iList.add(new GamaPoint(dXFLine.getStartPoint().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFLine.getStartPoint().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFLine.getStartPoint().getZ() * (this.unit == null ? 1.0 : this.unit)));
        iList.add(new GamaPoint(dXFLine.getEndPoint().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFLine.getEndPoint().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFLine.getEndPoint().getZ() * (this.unit == null ? 1.0 : this.unit)));
        return this.createPolyline(iScope, iList);
    }

    public IShape manageObj(IScope iScope, DXFArc dXFArc) {
        if (dXFArc == null) {
            return null;
        }
        IList iList = GamaListFactory.create(Types.POINT);
        iList.add(new GamaPoint(dXFArc.getStartPoint().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFArc.getStartPoint().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFArc.getStartPoint().getZ() * (this.unit == null ? 1.0 : this.unit)));
        iList.add(new GamaPoint(dXFArc.getEndPoint().getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, dXFArc.getEndPoint().getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, dXFArc.getEndPoint().getZ() * (this.unit == null ? 1.0 : this.unit)));
        return this.createPolyline(iScope, iList);
    }

    public GamaPoint toGamaPoint(DXFVertex dXFVertex) {
        return new GamaPoint(dXFVertex.getPoint().getX(), dXFVertex.getPoint().getY(), dXFVertex.getPoint().getZ());
    }

    protected void addToLists(IScope iScope, DXFPolyline dXFPolyline, DXFVertex dXFVertex, DXFVertex dXFVertex2, IList iList) {
        IList iList2 = GamaListFactory.create(Types.POINT);
        iList2.add(new GamaPoint(dXFVertex.getPoint().getX(), dXFVertex.getPoint().getY(), dXFVertex.getPoint().getZ()));
        GamaPoint gamaPoint = this.toGamaPoint(dXFVertex);
        GamaPoint gamaPoint2 = this.toGamaPoint(dXFVertex2);
        if (dXFVertex.getBulge() == 0.0) {
            iList.add(gamaPoint);
            iList.add(gamaPoint2);
        } else {
            double d = gamaPoint.distance(gamaPoint2);
            double d2 = dXFVertex.getBulge() * d / 2.0;
            IShape iShape = SpatialCreation.ellipticalArc(iScope, gamaPoint, gamaPoint2, d2, 20);
            iList.addAll(iShape.getPoints());
        }
    }

    public IList<GamaPoint> getPoints(IScope iScope, DXFPolyline dXFPolyline) {
        GamaPoint gamaPoint;
        IList<GamaPoint> iList = GamaListFactory.create(Types.POINT);
        Iterator iterator = dXFPolyline.getVertexIterator();
        if (iterator.hasNext()) {
            DXFVertex dXFVertex;
            gamaPoint = null;
            Object object = dXFVertex = (DXFVertex)iterator.next();
            iList.add(new GamaPoint(object.getPoint().getX(), object.getPoint().getY(), object.getPoint().getZ()));
            while (iterator.hasNext()) {
                gamaPoint = (DXFVertex)iterator.next();
                this.addToLists(iScope, dXFPolyline, (DXFVertex)object, (DXFVertex)gamaPoint, iList);
                object = gamaPoint;
            }
            if (gamaPoint != null && gamaPoint.getBulge() != 0.0) {
                this.addToLists(iScope, dXFPolyline, (DXFVertex)gamaPoint, dXFVertex, iList);
            }
        }
        boolean bl = true;
        block1: while (bl) {
            bl = false;
            int n = 0;
            while (n < iList.size() - 1) {
                GamaPoint gamaPoint2;
                gamaPoint = (GamaPoint)iList.get(n);
                if (gamaPoint.euclidianDistanceTo(gamaPoint2 = (GamaPoint)iList.get(n + 1)) < 1.0E-6) {
                    iList.remove(n + 1);
                    bl = true;
                    continue block1;
                }
                ++n;
            }
        }
        return iList;
    }

    public IShape manageObj(IScope iScope, DXFPolyline dXFPolyline) {
        if (dXFPolyline == null) {
            return null;
        }
        IList<GamaPoint> iList = this.getPoints(iScope, dXFPolyline);
        GamaPoint gamaPoint = (GamaPoint)iList.get(iList.size() - 1);
        if (gamaPoint.getX() == 0.0 && gamaPoint.getY() == 0.0 && gamaPoint.getZ() == 0.0) {
            iList.remove(gamaPoint);
        }
        IList iList2 = GamaListFactory.create(Types.POINT);
        for (GamaPoint gamaPoint2 : iList) {
            iList2.add(new GamaPoint(gamaPoint2.getX() * (this.unit == null ? 1.0 : this.unit) - this.x_t, gamaPoint2.getY() * (this.unit == null ? 1.0 : this.unit) - this.y_t, gamaPoint2.getZ() * (this.unit == null ? 1.0 : this.unit)));
        }
        if (iList2.size() < 2) {
            return null;
        }
        if (dXFPolyline.isClosed() && iList2.get(0) != iList2.get(iList2.size() - 1)) {
            iList2.add((GamaPoint)iList2.firstValue(iScope));
        }
        return this.createPolyline(iScope, iList2);
    }

    public IShape defineGeom(IScope iScope, Object object) {
        if (object != null) {
            if (object instanceof DXFArc) {
                return this.manageObj(iScope, (DXFArc)object);
            }
            if (object instanceof DXFLine) {
                return this.manageObj(iScope, (DXFLine)object);
            }
            if (object instanceof DXFPolyline) {
                return this.manageObj(iScope, (DXFPolyline)object);
            }
            if (object instanceof DXFSolid) {
                return this.manageObj(iScope, (DXFSolid)object);
            }
            if (object instanceof DXFCircle) {
                return this.manageObj(iScope, (DXFCircle)object);
            }
        }
        return null;
    }

    protected void fillBuffer(IScope iScope, DXFDocument dXFDocument) {
        List list;
        Object object;
        Iterator iterator;
        Iterator iterator2;
        IList iList = GamaListFactory.create(Types.GEOMETRY);
        double d = (dXFDocument.getBounds().getMaximumX() - dXFDocument.getBounds().getMinimumX()) * (this.unit == null ? 1.0 : this.unit);
        double d2 = (dXFDocument.getBounds().getMaximumY() - dXFDocument.getBounds().getMinimumY()) * (this.unit == null ? 1.0 : this.unit);
        IShape iShape = GamaGeometryType.buildPolygon(GamaListFactory.wrap((IType)Types.POINT, new GamaPoint(0.0, 0.0), new GamaPoint(d, 0.0), new GamaPoint(d, d2), new GamaPoint(0.0, d2), new GamaPoint(0.0, 0.0)));
        Iterator iterator3 = dXFDocument.getDXFLayerIterator();
        ArrayList<IShape> arrayList = new ArrayList<IShape>();
        while (iterator3.hasNext()) {
            iterator2 = (DXFLayer)iterator3.next();
            iterator = iterator2.getDXFEntityTypeIterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                list = iterator2.getDXFEntities((String)object);
                for (IShape iShape2 : list) {
                    IShape iShape3 = this.defineGeom(iScope, iShape2);
                    if (iShape3 == null || !iShape3.intersects(iShape) || arrayList.contains(iShape3)) continue;
                    arrayList.add(iShape3);
                    iShape3.setAttribute("layer", iShape2.getLayerName());
                    iShape3.setAttribute("id", iShape2.getID());
                    iShape3.setAttribute("scale_factor", iShape2.getLinetypeScaleFactor());
                    iShape3.setAttribute("thickness", iShape2.getThickness());
                    iShape3.setAttribute("is_visible", iShape2.isVisibile());
                    iShape3.setAttribute("is_omit", iShape2.isOmitLineType());
                    iShape3.setAttribute("color_index", iShape2.getColor());
                    if (iShape2.getColorRGB() != null) {
                        iShape3.setAttribute("color", GamaColor.get(iShape2.getColorRGB()[0], (int)iShape2.getColorRGB()[1], (int)iShape2.getColorRGB()[2], 255));
                    }
                    if (iShape2.getLineType() != null) {
                        iShape3.setAttribute("line_type", iShape2.getLineType());
                    }
                    iList.add(iShape3);
                }
            }
        }
        iterator2 = dXFDocument.getDXFBlockIterator();
        while (iterator2.hasNext()) {
            iterator = (DXFBlock)iterator2.next();
            object = iterator.getDXFEntitiesIterator();
            while (object.hasNext()) {
                IShape iShape2;
                list = (DXFEntity)object.next();
                iShape2 = this.defineGeom(iScope, list);
                if (iShape2 == null || !iShape2.intersects(iShape) || arrayList.contains(iShape2)) continue;
                arrayList.add(iShape2);
                iShape2.setAttribute("layer", list.getLayerName());
                iShape2.setAttribute("id", list.getID());
                iShape2.setAttribute("scale_factor", list.getLinetypeScaleFactor());
                iShape2.setAttribute("thickness", list.getThickness());
                iShape2.setAttribute("is_visible", list.isVisibile());
                iShape2.setAttribute("is_omit", list.isOmitLineType());
                iShape2.setAttribute("color_index", list.getColor());
                if (list.getColorRGB() != null) {
                    iShape2.setAttribute("color", GamaColor.get(list.getColorRGB()[0], (int)list.getColorRGB()[1], (int)list.getColorRGB()[2], 255));
                }
                if (list.getLineType() != null) {
                    iShape2.setAttribute("line_type", list.getLineType());
                }
                iList.add(iShape2);
            }
        }
        this.setBuffer(iList);
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        Parser parser = ParserBuilder.createDefaultParser();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fileInputStream = new FileInputStream(this.getFile(iScope));){
                parser.parse((InputStream)fileInputStream, "");
                DXFDocument dXFDocument = parser.getDocument();
                this.x_t = dXFDocument.getBounds().getMinimumX() * (this.unit == null ? 1.0 : this.unit);
                this.y_t = dXFDocument.getBounds().getMinimumY() * (this.unit == null ? 1.0 : this.unit);
                this.fillBuffer(iScope, dXFDocument);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        Parser parser = ParserBuilder.createDefaultParser();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fileInputStream = new FileInputStream(this.getFile(iScope));){
                parser.parse((InputStream)fileInputStream, "");
                DXFDocument dXFDocument = parser.getDocument();
                return Envelope3D.of(new Envelope(0.0, (dXFDocument.getBounds().getMaximumX() - dXFDocument.getBounds().getMinimumX()) * (this.unit == null ? 1.0 : this.unit), 0.0, (dXFDocument.getBounds().getMaximumY() - dXFDocument.getBounds().getMinimumY()) * (this.unit == null ? 1.0 : this.unit)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

